<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/function.php");
include_once("./functions/utils.php");
include_once("./functions/parseutils.php");

include_once("./functions/widgets.php");
include_once("./functions/admin.php");
include_once("./functions/listings.php");

function display_menu_header($type=NULL)
{
    $admin_tools = get_admin_tools_r();
	
	echo("<div align=left><table width=800 border=0><tr><td align=center>");
	while(list(,$tool) = each($admin_tools))
	{
		$tool_config_r = get_admin_config_r($tool);

		if(strcmp($type,$tool)!=0)
		{
			echo("&nbsp;&nbsp;<a href=\"admin.php?type=$tool\">");
			if(file_exists("admin/$tool/icon.gif"))
				echo("<img src=\"admin/$tool/icon.gif\" border=0 valign=absmiddle align=absmiddle title=\"".$tool_config_r['type_description']."\">");
			else
				echo($tool_config_r['menu_link_name']);
			echo("</a>");
		}
	}
	echo("</td></tr></table></div>");
}

// This check will also be performed in each site plugin, but who cares!
session_start();
if(is_opendb_valid_session())
{
	if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
	{
		if(strlen($HTTP_VARS['type'])==0 && $HTTP_VARS['op']== 'errmsg' && strlen($HTTP_VARS['title'])>0 && strlen($HTTP_VARS['error'])>0)
		{
			echo _theme_header($HTTP_VARS['title'],FALSE);
			echo("<h2>".$HTTP_VARS['title']."</h2>");
			echo urldecode($HTTP_VARS['error']);
		}
		else if(is_legal_admin_type($HTTP_VARS['type']))
		{
			if(file_exists("./admin/".$HTTP_VARS['type']."/config.php"))
				include("admin/".$HTTP_VARS[type]."/config.php");

			if($HTTP_VARS['inc_theme'] != 'N' && $HTTP_VARS['inc_header'] != 'N')
			{
				echo _theme_header($type_description, $HTTP_VARS['inc_menu']);
				
				// The printable theme handles the call to _theme_header,
				// so it should be included.
				if ($HTTP_VARS['mode'] != 'printable')
				{
					display_menu_header($HTTP_VARS['type']);
					echo("<h2>");
					if(file_exists("admin/".$HTTP_VARS['type']."/icon.gif"))
						echo("<img src=\"admin/".$HTTP_VARS['type']."/icon.gif\" border=0 valign=absmiddle align=absmiddle title=\"".$type_description."\">&nbsp;");
					echo($type_description);
					echo("</h2>");
				}
			}

			// Declare so it can be used within child scripts.
			$ADMIN_TYPE = $HTTP_VARS['type'];
			
			if(file_exists("./admin/".$HTTP_VARS['type']."/functions.php"))
				include("./admin/".$HTTP_VARS['type']."/functions.php");
				
			include("./admin/".$HTTP_VARS['type']."/index.php");
		}
		else if(strlen($HTTP_VARS['type'])>0)
		{
			echo _theme_header("Illegal Type specified");
			display_menu_header();
			echo _theme_error("Illegal Type specified");
		}
		else
		{
			echo _theme_header("OpenDb Administrator");
			display_menu_header();
		}
	}
	else //not an administrator or own user.
	{
		echo _theme_header($LANG_VARS['not_authorized_to_page']);
		echo _theme_error($LANG_VARS['not_authorized_to_page']);
	}
	
	if($HTTP_VARS['inc_theme'] != 'N' && $HTTP_VARS['inc_footer'] != 'N')
		echo _theme_footer();
}
else//not a valid session.
{
	include("./include/invalidsession.php");
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
