## Copyright (C) 1996, 1997, 1999  Kurt Hornik
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## asave (x, filename [, cw [, rw [, FS [, NA]]]])
##
## Save x into the flat ASCII data file `filename'.
##
## With the optional parameters cw and rw one can select the data
## columns (variables) and rows (observations) to save.  Both cw and rw
## may be index vectors or Inf (default), meaning to save everything.
##
## With FS, one can specify the field separator to be used in the data
## file, as one would do in AWK.  Default is " ".
##
## With NA, one can specify how unavailable data are represented in x
## and in the data file.  The default is "NaN/NA", meaning that NaN's
## should be converted to NA.
  
## Author:  KH <Kurt.Hornik@ci.tuwien.ac.at>
## Description:  Save to a flat ASCII data file

function asave (x, filename, cw, rw, FS, NA)

  if ((nargin < 2) || (nargin > 6))
    usage ("asave (x, filename [, cw [, rw [, FS [, NA]]]])");
  endif

  if (nargin < 6)
    NA = "NaN/NA";
  endif
  if (nargin < 5)
    FS = " ";
  endif
  if (nargin < 4)
    rw = Inf;
  endif
  if (nargin < 3)
    cw = Inf;
  endif

  ## get Octave's version number, split it into a numerical array
  OV = str2num(split(version, "."));
  if (OV(1) > 2) || (OV(1) == 2 && OV(2) > 0) || \
       	(OV(1) == 2 && OV(2) == 0 && OV(3) >= 14)
    nrows = 5;
  else
    nrows = 4;
  endif

  ## maybe_do_more_sanity_checks ();  

  if is_struct (stat (filename))
    error (sprintf ("asave:  File '%s' already exists", filename));
  endif

  [rf, cf] = size (x);

  if (cw == Inf)
    cw = 1 : cf;
  elseif (min (size (cw)) == 1)
    cw = cw (find (cw <= cf));
  else
    error ("asave:  cw must be a scalar or a vector");
  endif

  if (rw == Inf)
    rw = 1 : rf;
  elseif (min (size (rw)) == 1)
    rw = rw (find (rw <= rf));
  else
    error ("asave:  rw must be a scalar or a vector");
  endif
  
  tmpfile = octave_tmp_file_name ();

  x = x (rw, cw);

  eval (["save -ascii ", tmpfile, " x"]);

  s = "$1";
  for i = 2 : length (cw)
    s = sprintf ("%s, $%d", s, i);
  endfor

  system (["cat ", tmpfile, " | ", ...
	   "sed -e 's/", NA, "/g' | ", ...
	   "awk 'BEGIN { OFS=\"", FS, "\" }; ", ...
	   " { if (NR > ", num2str(nrows), ") print ", s, " }'", ...
	   " > ", filename]);

  system (sprintf ("rm -f %s", tmpfile));

endfunction
