/* ssl_port.h    - standard porting things 
 *
 * The modifications to support SSLeay were done by Tim Hudson
 * tjh@mincom.oz.au
 *
 * You can do whatever you like with these patches except pretend that
 * you wrote them. 
 *
 * Email ssl-users-request@mincom.oz.au to get instructions on how to
 * join the mailing list that discusses SSLeay and also these patches.
 *
 */

#ifndef HEADER_SSL_PORT_H
#define HEADER_SSL_PORT_H

#ifdef USE_SSL

#include <stdio.h>

#define OLDPROTO NOPROTO
#define NOPROTO
#include <openssl/buffer.h>
#undef NOPROTO
#define NOPROTO OLDPROTO

#include <openssl/x509.h>
#include <openssl/ssl.h>
#include <openssl/err.h>

extern SSL *ssl_con;
extern SSL_CTX *ssl_ctx;
extern int ssl_debug_flag;
extern int ssl_only_flag;
extern int ssl_active_flag;
extern int ssl_verify_flag;
extern int ssl_secure_flag;
extern int ssl_enabled;

extern int ssl_encrypt_data;
extern SSL *ssl_data_con;
extern int ssl_data_active_flag;

extern char *my_ssl_cert_file;
extern char *my_ssl_key_file;
extern int ssl_certsok_flag;

extern int set_ssl_trace(SSL *s);

extern FILE *cin, *cout;

#define is_ssl_fd(X,Y)    ( (SSL_get_fd((X))==0) || \
                            (SSL_get_fd((X))==1) || \
                            (SSL_get_fd((X))==pdata) || \
			    (SSL_get_fd((X))==(Y)) \
			  )

#define is_ssl_fp(X,Y)    ( ( (SSL_get_fd((X))==0) && (fileno((Y))==0) ) || \
                            ( (SSL_get_fd((X))==1) && (fileno((Y))==1) ) || \
                            ( (SSL_get_fd((X))==pdata) && \
			    			  (fileno((Y))==pdata) ) || \
			    (SSL_get_fd((X))==fileno(Y)) \
			  )

/* these macros make things much easier to handle ... */

#define FFLUSH(X)         (ssl_active_flag && (((X)==cin)||((X)==cout)) ? 1 : fflush((X)) )

#define GETC(X)           (ssl_active_flag && (((X)==cin)||((X)==cout)) ? ssl_getc(ssl_con) : getc((X)) )

#define DATAGETC(X)       (ssl_data_active_flag && ((fileno(X)==data)||(fileno(X)==pdata)) ? ssl_getc(ssl_data_con) : getc((X)) )
#define DATAPUTC(X,Y)     (ssl_data_active_flag && ((fileno(Y)==data)||(fileno(Y)==pdata)) ? ssl_putc(ssl_data_con,(X)) : putc((X),(Y)) )
#define DATAFLUSH(X)      (ssl_data_active_flag && ((fileno(X)==data)||(fileno(X)==pdata)) ? ssl_putc_flush(ssl_data_con) : fflush((X)) )

#else

#define GETC(X)           getc((X))
#define DATAGETC(X)       getc((X))
#define DATAPUTC(X,Y)     putc((X),(Y))
#define DATAFLUSH(X)      fflush((X))
#define FFLUSH(X)         fflush((X))

#endif /* USE_SSL */

#endif /*  HEADER_SSL_PORT_H */
