package com.mysql.grt;

import java.util.HashMap;
import java.util.Iterator;

public class GrtHashMap implements GrtXml {

	protected boolean isGlobalObject = false;

	protected String globalObjectPath;

	protected HashMap map;

	private String contentType = "";

	private String contentStructName = "";

	private GrtObject owner;

	public GrtHashMap() {
		super();
	}

	public GrtHashMap(GrtObject owner) {
		this();

		this.owner = owner;
	}

	public GrtHashMap(String contentStructName) {
		this();

		if (!contentStructName.equals("")) {
			this.contentType = "dict";
			this.contentStructName = contentStructName;
		}
	}

	public GrtHashMap(String contentStructName, String globalObjectPath) {
		this(contentStructName);

		this.isGlobalObject = !globalObjectPath.equals("");
		this.globalObjectPath = globalObjectPath;
	}

	protected boolean getIsGlobalObject() {
		return isGlobalObject;
	}

	protected String getGlobalObjectPath() {
		return globalObjectPath;
	}

	public Object addObject(String key, Object item) {
		if (getIsGlobalObject())
			Grt.getInstance().addGrtGlobalDictItem(getGlobalObjectPath(), key,
					item);
		else {
			if (map == null)
				map = new HashMap();

			map.put(key, item);
		}

		return getObject(key);
	}

	public Object getObject(String key) {
		if (getIsGlobalObject())
			return Grt.getInstance().getGrtGlobalDictItem(
					getGlobalObjectPath(), key);
		else {
			if (map == null)
				map = new HashMap();

			return map.get(key);
		}
	}

	public void remove(String key) {
		if (getIsGlobalObject())
			Grt.getInstance().removeGrtGlobalDictItem(getGlobalObjectPath(),
					key);
		else {
			if (map == null)
				map = new HashMap();

			map.remove(key);
		}
	}

	public String[] getKeys() {
		if (map == null)
			map = new HashMap();

		return (String[]) map.keySet().toArray(new String[map.keySet().size()]);
	}

	public String getContentType() {
		return contentType;
	}

	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

	public String getContentStructName() {
		return contentStructName;
	}

	public void setContentStructName(String contentStructName) {
		this.contentStructName = contentStructName;
	}

	public String getGrtXml() {
		return getGrtXml("");
	}

	public String getGrtXml(String keyTag) {
		String xml = "<value type=\"dict\"" + keyTag;

		if (!getContentType().equals(""))
			xml += " content-type=\"" + getContentType() + "\"";

		if (!getContentStructName().equals(""))
			xml += " content-struct-name=\"" + getContentStructName() + "\"";

		if (getIsGlobalObject())
			xml += " global-object-path=\""
					+ Grt.escapeStringForXml(getGlobalObjectPath()) + "\"";

		xml += ">\n";

		if (map != null) {
			Iterator keys = map.keySet().iterator();

			while (keys.hasNext()) {
				String key = (String) keys.next();
				xml += Grt.getObjectAsXml(getObject(key), " key=\"" + key
						+ "\"");
			}
		}

		return xml + "</value>\n";
	}
}