#include <qvbox.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qvaluelist.h>
#include <qpixmap.h>
#include <qstatusbar.h>
#include <qlistview.h>
#include <qfile.h>
#include <qlineedit.h>
#include <qdir.h>
#include <qmenubar.h>
#include <stdlib.h>

#include "mainwindow.h"
#include "mdiwindow.h"
#include "include/resource.h"
#include "base64.h"

MainWindow::MainWindow() :
QMainWindow(0,QString::fromLocal8Bit("MySQL Navigator"),WDestructiveClose)
{
	initialize();
}

MainWindow::~MainWindow()
{
}	

void MainWindow::initialize()
{
	make_layout();

	signal_connect();

	open = FALSE;

	mysql_init(&mysql);

	hay = NULL;

	load_session();

	resize(option.size);

	disable_menu();

	slot_xpm();
}

void MainWindow::set_base_color(QWidget *widget,QColor color)
{
	QPalette z(widget->palette());

	z.setColor(QColorGroup::Base,color);

	widget->setPalette(z);	
}

void MainWindow::set_xpm_color(QWidget *widget,QColor color)
{
	QPalette z(widget->palette());

	z.setColor(QColorGroup::Background,color);

	widget->setPalette(z);	
}

void MainWindow::load_query()
{
	char buffer[255];
	int z;

#ifndef WIN32
	sprintf(buffer, "%s/%s", getenv("HOME"), ".mysqlnavigator.history");
#else
	sprintf(buffer, "%s/%s", "c:", ".mysqlnavigator.history");
#endif

	QFile s(buffer);

	if(s.open(IO_ReadOnly) == FALSE)
	{
		return;
	}

	while((z = s.readLine(buffer, sizeof(buffer))))
	{
		if(z == -1)
		{
			break;
		}	
		
		QString s_ = buffer;
		s_ = s_.stripWhiteSpace();

		if(s_.at(0) == '$')
		{
			s_ = s_.remove(0, 1);
			char *z = new char[s_.length() + 1];
			FromBase64(z, (const void *)s_.latin1(), s_.length(), TRUE);
			query->insertItem(QString::fromLocal8Bit(z));
			delete []z;
		}
		else
		{
			query->insertItem(QString::fromLocal8Bit(s_));
		}
	}
	
	query->lineEdit()->setText("");
	
	s.close();	
}

void MainWindow::save_query()
{
	char buffer[255];

	QString sql;

#ifndef WIN32
	sprintf(buffer, "%s/%s", getenv("HOME"), ".mysqlnavigator.history");  
#else
	sprintf(buffer, "%s/%s", "c:", ".mysqlnavigator.history");  
#endif

	QFile s(buffer);

	if(s.open(IO_WriteOnly) == FALSE)
		return;

	for(int z = 0; z < query->count(); z++)
	{
		char *s_  = new char[query->text(z).local8Bit().length() * 4 + 1];
		ToBase64(s_, (const void *)query->text(z).local8Bit().data(), query->text(z).local8Bit().length(), TRUE);
		sql += "$";
		sql += s_;
		sql += "\n";
		delete []s_;
	}

	s.writeBlock(sql.latin1(), sql.length());

	s.close();
}

void MainWindow::clear_query()
{
	query->clear();
}

void MainWindow::enable_menu()
{
	menuBar()->setItemEnabled(ID_OPEN, FALSE);
	menuBar()->setItemEnabled(ID_OPEN2, FALSE);
	menuBar()->setItemEnabled(ID_NEW, TRUE);
	menuBar()->setItemEnabled(ID_QUIT, TRUE);
	menuBar()->setItemEnabled(ID_CLOSE, TRUE);
	menuBar()->setItemEnabled(ID_CLOSE_ALL, TRUE);
	menuBar()->setItemEnabled(ID_CLOSE_ALL_EXCEPT_SCHEMA, TRUE);
	menuBar()->setItemEnabled(ID_SCHEMA, TRUE);
	menuBar()->setItemEnabled(ID_USER, TRUE);
	menuBar()->setItemEnabled(ID_TABLE, TRUE);
	menuBar()->setItemEnabled(ID_FIELD, TRUE);
	menuBar()->setItemEnabled(ID_LOG, TRUE);
	menuBar()->setItemEnabled(ID_QUERY, TRUE);
	menuBar()->setItemEnabled(ID_SCRIPT, TRUE);
	menuBar()->setItemEnabled(ID_PROCESS, TRUE);
	menuBar()->setItemEnabled(ID_PASSWORD, TRUE);
	menuBar()->setItemEnabled(ID_FLUSH, TRUE);
	menuBar()->setItemEnabled(ID_XPORT, TRUE);
	menuBar()->setItemEnabled(ID_PRIVILEGE, TRUE);
	menuBar()->setItemEnabled(ID_FIND, TRUE);
	menuBar()->setItemEnabled(ID_KEY, TRUE);

	query->setEditable(TRUE);
}

void MainWindow::disable_menu()
{
	menuBar()->setItemEnabled(ID_OPEN, TRUE);
	menuBar()->setItemEnabled(ID_OPEN2, TRUE);
	menuBar()->setItemEnabled(ID_NEW, FALSE);
	menuBar()->setItemEnabled(ID_QUIT, FALSE);
	menuBar()->setItemEnabled(ID_CLOSE, FALSE);
	menuBar()->setItemEnabled(ID_CLOSE_ALL, FALSE);
	menuBar()->setItemEnabled(ID_CLOSE_ALL_EXCEPT_SCHEMA, FALSE);
	menuBar()->setItemEnabled(ID_SCHEMA, FALSE);
	menuBar()->setItemEnabled(ID_USER, FALSE);
	menuBar()->setItemEnabled(ID_TABLE, FALSE);
	menuBar()->setItemEnabled(ID_FIELD, FALSE);
	menuBar()->setItemEnabled(ID_LOG, FALSE);
	menuBar()->setItemEnabled(ID_QUERY, FALSE);
	menuBar()->setItemEnabled(ID_SCRIPT, FALSE);
	menuBar()->setItemEnabled(ID_PROCESS, FALSE);
	menuBar()->setItemEnabled(ID_PASSWORD, FALSE);
	menuBar()->setItemEnabled(ID_FLUSH, FALSE);
	menuBar()->setItemEnabled(ID_XPORT, FALSE);
	menuBar()->setItemEnabled(ID_PRIVILEGE, FALSE);
	menuBar()->setItemEnabled(ID_FIND, FALSE);
	menuBar()->setItemEnabled(ID_KEY, FALSE);
	
	query->setEditable(FALSE);
}
