/* Copyright (C) 2000-2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   There are special exceptions to the terms and conditions of the GPL as it
   is applied to this software. View the full text of the exception in file
   EXCEPTIONS in the directory of this software distribution.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef MYODBCSETUP_H
#define MYODBCSETUP_H

#include <qglobal.h>

#ifndef Q_WS_MACX
#include <malloc.h>
#endif

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef Q_WS_WIN
#include <windows.h>
#define strcasecmp( a, b ) stricmp( a, b )
#endif

#ifdef Q_WS_MACX
#include <iodbcinst.h>
#else
#include <odbcinst.h>
#include <sqlext.h>
#endif

#include <sqlext.h>

#ifndef FALSE 
#define FALSE 0
#define TRUE 1
#endif

#ifndef max
#define max( a, b ) (((a) > (b)) ? (a) : (b))
#define min( a, b ) (((a) < (b)) ? (a) : (b))
#endif

#define MYODBC_MAX_DSN_NAMES 50

#ifdef __cplusplus
extern "C" {
#endif

#ifdef Q_WS_MACX
int GetPrivateProfileString( LPCSTR lpszSection,
                             LPCSTR lpszEntry,
                             LPCSTR lpszDefault,
                             LPSTR lpszRetBuffer,
                             int cbRetBuffer,
                             LPCSTR lpszFilename);
#endif

/*!
    \internal
    \brief  A single attribute.

            Each attribute has a name and usually has a value.
*/  
typedef struct tMYODBC_NAMEVALUE
{
  char *pszName;
  char *pszValue;
  
} MYODBC_NAMEVALUE;

BOOL                MYODBCSetupConfigDSNAdd( HWND hWnd, LPCSTR pszDriver, MYODBC_NAMEVALUE **aNameValues );
BOOL                MYODBCSetupConfigDSNEdit( HWND hWnd, MYODBC_NAMEVALUE **aNameValues );
BOOL                MYODBCSetupConfigDSNRemove( MYODBC_NAMEVALUE **aNameValues );
BOOL                MYODBCSetupDataSourceConfig( HWND hWnd, WORD nRequest, LPCSTR pszDriver, MYODBC_NAMEVALUE **aNameValues );
BOOL                MYODBCSetupDSNExists( char *pszDataSourceName );
void                MYODBCSetupFreeAttributesParsed( MYODBC_NAMEVALUE **aNameValues );
int                 MYODBCSetupGetAttributeIndex( MYODBC_NAMEVALUE **aNameValues, char *pszName );
MYODBC_NAMEVALUE ** MYODBCSetupGetAttributesParsed( LPCSTR pszAttributes );
void                MYODBCSetupHandleInstallerError();
BOOL                MYODBCSetupWriteAttributes( MYODBC_NAMEVALUE **aNameValues, int nDataSourceName );


#ifdef __cplusplus
}
#endif

#endif


