// sgi_dac.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifdef SGI_DACS

// Converter subclass for the Silicon Graphics Indy and Indigo workstation
// D-to-A converters.

#ifndef SGI_DAC_H
#ifdef __GNUG__
#pragma interface
#endif
#define SGI_DAC_H

extern "C" {
#include <audio.h>
#include <audiofile.h>
}

#include "converter.h"
#include "localdefs.h"

class Action;
class ProgressAction;

class SGIConverter : public RealConverter {
    typedef RealConverter Super;
public:
    SGIConverter();
    virtual ~SGIConverter();
    redefined int configure(Sound *sound, GoingTo);
    redefined int pause();
    redefined int resume();
    redefined int stop();
    redefined int currentPlayLevel() const;
    redefined int currentRecordLevel() const;
    redefined boolean setPlayLevel(int volume);
    redefined boolean setRecordLevel(int volume);
    redefined boolean setSpeakerOutput(boolean);
    redefined DataType bestPlayableType() { return ShortData; }
    int setInputDevice(int);
    int setOutputDevice(int);
protected:
    redefined boolean isPlayableFormat(DataType type);
    redefined int doConfigure();
    redefined int doConversion(ProgressAction* askedToStop);
    redefined int doRecording(ProgressAction* askedToStop);
    redefined int waitForStop(ProgressAction *);
    redefined int checkSampleRate(int rate);
    redefined int checkChannels(int chans);
    redefined int checkDataType(DataType);
    redefined void catchSignals(boolean);
    redefined void ignoreSignals(boolean);

    static int currentInputDevice() { return inputDevice; }
    static int currentOutputDevice() { return outputDevice; }
    int currentDevice() const;
    ALconfig currentConfig() const;

    class SGIConfigRequester : public RealConverter::ConfigRequester {
    public:
        SGIConfigRequester(RealConverter* cvtr) : ConfigRequester(cvtr) {}
    protected:
        redefined void configureRequest(Request *);
        redefined boolean confirmValues();
    private:
        ChoiceValue inputDeviceValue;
        ChoiceValue outputDeviceValue;
        ChoiceValue polite;
    };
    friend void SGIConfigRequester::configureRequest(Request *);
    friend boolean SGIConfigRequester::confirmValues();
    redefined Requester* configRequester() {
        return new SGIConfigRequester(this);
    }
    friend class Controller;
private:
    ChoiceValue inputDeviceToChoice(int dev) const;
    ChoiceValue outputDeviceToChoice(int dev) const;
    int inputChoiceToDevice(ChoiceValue index) const;
    int outputChoiceToDevice(ChoiceValue index) const;
    int inputDeviceToIndex(int dev) const;
    int outputDeviceToIndex(int dev) const;
    int getDefaults();
    void resetDefaults();
    int initialize();
    int displayError(const char *msg = nil);
    int sampleSize();            // size of each sample in bytes
    long bestQueueSize();        // converter queue size in samples
    long writeSamps();            // size of write buffer in samples
    long readSamps();            // size of read buffer in samples
    char* convertToSigned(char *, char*, long);    // converts unsigned chars to signed
    long getParameter(long param) const;
    int setParameter(long param, long value);
    int lockMemory();
    int unlockMemory();
private:
    static void signalExit(...);
    static void signalIgnore(...);
    static void signalQuit(...);
private:
    struct AudioDevice {
	char *label;
	int resourceID;
	int choiceIndex;
	double minGain, maxGain;
    };
    ALpv pvarray[8];
    ALconfig inPortConfig;
    ALconfig outPortConfig;
    ALport audio_port;
    static boolean dontInterrupt;    // true: do not play if cvtr in use
    static int inputDevice;
    static int outputDevice;
    static int inputDeviceCount;
    static int outputDeviceCount;
    AudioDevice inputDevices[8];
    AudioDevice outputDevices[8];
};

#endif

#endif /* SGI_DACS */
