// repclone.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// RepClones are derived from DataRep subclasses and the Clone class, which
// is an encapsulation of the common redefined features of all the RepClone
// subclasses.  RepClones are created by the clone() method of the DataRep
// subclasses in response to the clone() method of the Data subclass.
//
// A RepClone is in a sense a shallow copy of the DataRep from which it comes,
// in that it contains a pointer to the same Array instance.  It also contains
// a pointer to the "master" DataRep from which it was cloned, so that under
// certain circumstances it can access the source object.  In most other ways
// these clones respond as if they were a DataRep, except they return length
// and channel count values that are subsets of the master Rep.  The key to
// their functionality is in the getAddressOfContiguousData() method, where an
// offset is added to the value based upon the location of the starting point
// of the Clone in the original master.  This allows the calling of
// modification methods upon a Data subclass clone (and hence its DataRep
// pointer member), saying in essence "process your whole self", and this will,
// via the clone's redefined methods, perform that modification upon the
// portion of the original object which was cloned to begin with.
//
// Reference counting, which is available via the Resource base class in
// InterViews, allows me to keep track of memory, and allow deletion only when
// all references are destroyed.  This happens at three levels:  the
// DataRep::Array class, the DataRep class, and the Data class.

#ifndef REPCLONE_H
#ifdef __GNUG__
#pragma interface
#endif
#define REPCLONE_H

#include "localdefs.h"
#include "datarep.h"

class Data;
class Range;

class Clone {
public:
	Clone(DataRep* mstr, int len, int chans)
		: master(mstr), cloneLen(len), cloneChans(chans) {}
	int length() const { return cloneLen; }
	int channels() const { return cloneChans; }
	void changeNChans(int);
	int read(DataFile *) {
		Application::die("Illegal operation - read() - on clone."); return 0;
	}	
	int write(DataFile *) const {
		Application::die("Illegal operation - write() - on clone."); return 0;
	}
	DataRep* clone(const Range &, const Range &) {
		Application::die("Illegal operation - clone(Range&, Range&) - on clone."); return 0;
	}	
protected:
	DataRep* master;
	int cloneLen;
	int cloneChans;
private:
	Clone(const Clone &);
};

template <class Rep>
class Cloned : public Rep, public Clone {
public:
	Cloned(Rep *, const Range &, const Range &);
	virtual ~Cloned() {}
	redefined void valueRange(Range &r, int start, int end, int chf, int chl, boolean real=false) const;
protected:
	redefined DataRep *clone(const Range& selection) {
		return Rep::clone(selection, Range(0, channels() - 1));
	}
	redefined DataRep *clone(const Range&r1, const Range&r2) {
		return Clone::clone(r1, r2);
	}
	redefined int write(DataFile *f) const { return Clone::write(f); }
	redefined int read(DataFile *f) { return Clone::read(f); }
	redefined int channels() const { return Clone::channels(); }
	redefined int length() const { return Clone::length(); }
	redefined void changeNChans(int newchans);
	redefined addr getAddressOfContiguousData() const { return (*a)[offset]; }
	redefined int changeLength(int newlen);
private:
	friend class Data;
	Cloned(const Cloned&);
};

#endif /* REPCLONE_H */
