//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: globals.cpp,v 1.1.1.1 2003/10/29 10:05:18 wschweer Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#include "globals.h"
#include <qpixmap.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>

int recFileNumber = 1;
bool alsaFound = false;
bool audioTimebase = true;

int division    = 384;             // internal division (ticks/quarternote)
int rtcTicks    = 4096;
int minMeter    = -60;
double minSlider   = -60;
int guiRefresh  = 20;

QString helpBrowser("konqueror");

volatile int sampleRate  = 44100;
volatile int segmentSize = 1024;    // segmentSize in samples
bool noAudio             = false;
bool noJack              = true;
bool noAlsa              = true;
bool useJackAudio        = true;
bool useAlsaAudio        = false;

bool hIsB = true;             // call note h "b"

const signed char sharpTab[14][7] = {
      { 0, 3, -1, 2, 5, 1, 4 },
      { 0, 3, -1, 2, 5, 1, 4 },
      { 0, 3, -1, 2, 5, 1, 4 },
      { 0, 3, -1, 2, 5, 1, 4 },
      { 2, 5,  1, 4, 7, 3, 6 },
      { 2, 5,  1, 4, 7, 3, 6 },
      { 2, 5,  1, 4, 7, 3, 6 },
      { 4, 0,  3, -1, 2, 5, 1 },
      { 7, 3,  6, 2, 5, 1, 4 },
      { 5, 8,  4, 7, 3, 6, 2 },
      { 3, 6,  2, 5, 1, 4, 7 },
      { 1, 4,  0, 3, 6, 2, 5 },
      { 6, 2,  5, 1, 4, 0, 3 },
      { 0, 3, -1, 2, 5, 1, 4 },
      };
const signed char flatTab[14][7]  = {
      { 4, 1, 5, 2, 6, 3, 7 },
      { 4, 1, 5, 2, 6, 3, 7 },
      { 4, 1, 5, 2, 6, 3, 7 },
      { 4, 1, 5, 2, 6, 3, 7 },
      { 6, 3, 7, 4, 8, 5, 9 },
      { 6, 3, 7, 4, 8, 5, 9 },
      { 6, 3, 7, 4, 8, 5, 9 },

      { 1, 5, 2, 6, 3, 7, 4 },
      { 4, 1, 5, 2, 6, 3, 7 },
      { 2, 6, 3, 7, 4, 8, 5 },
      { 7, 4, 1, 5, 2, 6, 3 },
      { 5, 2, 6, 3, 7, 4, 8 },
      { 3, 0, 4, 1, 5, 2, 6 },
      { 4, 1, 5, 2, 6, 3, 7 },
      };

QString museGlobalLib("");
QString museGlobalShare("");
QString museUser("");
QString museProject("");

bool debugMode = false;
bool debugMsg = false;
bool midiInputTrace = false;
bool midiOutputTrace = false;
bool realTimeScheduling = false;
int realTimePriority = 80;
bool loadPlugins = true;

const char* midi_file_pattern[] = {
      "Midi/Kar (*.mid *.kar *.mid.gz *.mid.bz2)",
      "Midi (*.mid *.mid.gz *.mid.bz2)",
      "Karaoke (*.kar *.kar.gz *.kar.bz2)",
      "All Files (*)",
      0
      };
const char* med_file_pattern[] = {
      "med Files (*.med *.med.gz *.med.bz2)",
      "All Files (*)",
      0
      };
const char* image_file_pattern[] = {
      "(*.jpg *.gif *.png)",
      "(*.jpg)",
      "(*.gif)",
      "(*.png)",
      "All Files (*)",
      0
      };

const char* ctrl_file_pattern[] = {
      "ctrl Files (*.ctrl *.ctrl.gz *.ctrl.bz2)",
      "All Files (*)",
      0
      };

QString scoreBg("");        // Background Pixmap Pathname for score canvas

double paperWidth   = 210.0;  // mm
double paperHeight  = 297.0;
double topMargin    = 10.0;
double bottomMargin = 10.0;
double leftMargin   = 10.0;
double rightMargin  = 10.0;
double printScale   = 1.0;

double beamWidth        = 3.0;
double beamSpacing      = 2.125;
double beamSlopeTrigger = 0.5;

int barsPage        = 4;

QString family("arial");

QFont font0(QString("arial"), 12, QFont::Normal);
QFont font1(QString("arial"), 8,  QFont::Normal);
QFont font2(QString("arial"), 10, QFont::Normal);
QFont font3(QString("arial"), 10, QFont::Bold);
QFont font4(QString("arial"), 8,  QFont::Bold);    // timescale numbers
QFont font5(QString("Lucidatypewriter"), 14,  QFont::Bold);

Qt::ButtonState globalKeyState;

bool extendedMidi = true;
int midiDivision  = 384;      // division for midi export

// Midi Filter Parameter
int midiInputPorts   = 0;    // receive from all devices
int midiInputChannel = 0;    // receive all channel
int midiRecordType   = 0;    // receive all events
int midiThruType = 0;        // transmit all events
int midiFilterCtrl1 = 0;
int midiFilterCtrl2 = 0;
int midiFilterCtrl3 = 0;
int midiFilterCtrl4 = 0;

QActionGroup* undoRedo;
QAction* undoAction;
QAction* redoAction;
QActionGroup* transportAction;
QAction* playAction;
QAction* startAction;
QAction* stopAction;
QAction* rewindAction;
QAction* forwardAction;
QAction* loopAction;
QAction* punchinAction;
QAction* punchoutAction;
QAction* recordAction;
QAction* panicAction;

AudioMixerApp* audioMixer;
MusE* muse;

int preMeasures = 2;
unsigned char measureClickNote = 63;
unsigned char measureClickVelo = 127;
unsigned char beatClickNote    = 63;
unsigned char beatClickVelo    = 70;
unsigned char clickChan = 9;
unsigned char clickPort = 0;
bool precountEnableFlag = true;
bool precountFromMastertrackFlag = true;
int precountSigZ = 4;
int precountSigN = 4;
bool precountPrerecord = false;
bool precountPreroll = false;
bool midiClickFlag   = true;
bool audioClickFlag  = false;

bool rcEnable = false;
unsigned char rcStopNote = 28;
unsigned char rcRecordNote = 31;
unsigned char rcGotoLeftMarkNote = 33;
unsigned char rcPlayNote = 29;

uid_t euid, ruid;  // effective user id, real user id

//---------------------------------------------------------
//   doSetuid
//    Restore the effective UID to its original value.
//---------------------------------------------------------

void doSetuid()
      {
#ifdef RTCAP
      extern void getCapabilities();
      getCapabilities();
#else
      int status;
#ifdef _POSIX_SAVED_IDS
      status = seteuid (euid);
#else
      status = setreuid (ruid, euid);
#endif
      if (status < 0) {
            perror("doSetuid: Couldn't set uid");
            }
#endif
      }

//---------------------------------------------------------
//   undoSetuid
//    Set the effective UID to the real UID.
//---------------------------------------------------------

void undoSetuid()
      {
#ifndef RTCAP
      int status;

#ifdef _POSIX_SAVED_IDS
      status = seteuid (ruid);
#else
      status = setreuid (euid, ruid);
#endif
      if (status < 0) {
            fprintf(stderr, "undoSetuid: Couldn't set uid (eff:%d,real:%d): %s\n",
               euid, ruid, strerror(errno));
            exit (status);
            }
#endif
      }

