
#include <lcms.h>

static cmsCIEXYZTRIPLE dimagePrimaries = {
	{ 0.581818, 0.241455, 0.123322 },
	{ 0.333633, 0.924133,-0.236435 },
	{ 0.048737,-0.165588, 0.938004 }
};
static cmsCIEXYZ dimageWhitePt = { 0.963577, 1.000000, 0.823654 };
static cmsCIEXYZ dimageIlluminant = { 0.964188, 1.000000, 0.824875 };

double bTRC[512] = {
#include "btrc.dat"
};
double gTRC[512] = {
#include "gtrc.dat"
};
double rTRC[512] = {
#include "rtrc.dat"
};
double iTRC[512] = {
#include "itrc.dat"
};

unsigned short
applyTone (double *trc, unsigned short val)
{
	double v = (val * 511) / 65535.0;
	unsigned idx = v;
	double w;

	if (idx > 510) { idx= 510; w = 1; }
	else { w = v - idx; }
	printf ("applyTone: val=%d idx=%d trc[idx]=%g trc[idx+1]=%g w=%g\n",
		val, idx, trc[idx], trc[idx+1], w);
	return (unsigned short)((trc[idx] + w*(trc[idx+1]-trc[idx])) * 65535.0 + 0.5);
}

cmsHPROFILE
Create_DiMAGEProfile()
{
	cmsCIExyY wPt;
	cmsCIExyYTRIPLE primaries;
	cmsHPROFILE dimageProfile;
	LPGAMMATABLE transferFunction[3];

	cmsXYZ2xyY (&wPt, &dimageWhitePt);
	cmsXYZ2xyY (&primaries.Red, &dimagePrimaries.Red);
	cmsXYZ2xyY (&primaries.Green, &dimagePrimaries.Green);
	cmsXYZ2xyY (&primaries.Blue, &dimagePrimaries.Blue);

	transferFunction[0] = transferFunction[1] = transferFunction[2] = cmsBuildGamma (256, 1.0);
	dimageProfile = cmsCreateRGBProfile(&wPt, &primaries, transferFunction);
	_cmsAddTextTag(dimageProfile, icSigProfileDescriptionTag, "dimage (built-in)");
	return dimageProfile;
}

/* f(t) = t1/3      		for t > 0.008856
 * f(t) = 7.787 * t + 16/116    otherwise
 */
static double f(double t)
{
	if (t > 0.008856)
		return pow (t, 1.0/3.0);
	else
		return 7.787 * t + 16.0/116.0;
}

/* L* = 116 * (Y/Yn)1/3 - 16    for Y/Yn > 0.008856
 * L* = 903.3 * Y/Yn             otherwise
 *
 * a* = 500 * ( f(X/Xn) - f(Y/Yn) )
 * b* = 200 * ( f(Y/Yn) - f(Z/Zn) )
 */
myXYZ2Lab (LPcmsCIEXYZ wPt, LPcmsCIELab Lab, LPcmsCIEXYZ XYZ)
{
	double YoverYn = XYZ->Y / wPt->Y;
	double fYoverYn = f (YoverYn);

	if (YoverYn > 0.008856)
		Lab->L = 116.0 * pow (YoverYn, 1.0/3.0) - 16.0;
	else
		Lab->L = 903.3 * YoverYn;

	Lab->a = 500.0 * ( f(XYZ->X/wPt->X) - fYoverYn );
	Lab->b = 200.0 * ( fYoverYn - f(XYZ->Z/wPt->Z) );
}

int
main ()
{
	cmsHPROFILE minImageProfile;
	cmsHPROFILE myImageProfile;
	cmsHPROFILE srgbProfile;
	cmsHPROFILE labProfile;
	cmsHPROFILE dimageLabProfile;
	cmsHPROFILE xyzProfile;
	cmsHTRANSFORM myInTransform;
	cmsHTRANSFORM minInTransform;
	cmsHTRANSFORM outTransform;
	cmsHTRANSFORM myDirTransform;
	cmsHTRANSFORM minDirTransform;
	cmsHTRANSFORM myXYZTransform;
	cmsHTRANSFORM minXYZTransform;
	unsigned short in[3], incpy[3], lab[3], out[3], xyz[3];
	char buffer[1024];
	cmsCIExyY wPt;
	cmsCIEXYZ XYZ, adaptedXYZ;
	cmsCIExyY xyY;
	int i;
	MAT3 dimageMat;
	cmsCIExyYTRIPLE dimagePrimrs;
	double col[3];

	srgbProfile = cmsCreate_sRGBProfile();
	xyzProfile = cmsCreateXYZProfile();
	myImageProfile = Create_DiMAGEProfile();
	minImageProfile = cmsOpenProfileFromFile (DATAPREFIX"/profiles/MLTDim5r.icc", "r");
	labProfile = cmsCreateLabProfile (NULL);
	cmsXYZ2xyY (&wPt, &dimageWhitePt);
        _cmsIdentifyWhitePoint(buffer, &dimageWhitePt);
	printf ("%s\n", buffer);

	dimageLabProfile = cmsCreateLabProfile (&wPt);

	minXYZTransform = cmsCreateTransform (minImageProfile,
					    TYPE_RGB_16,
					    xyzProfile,
					    TYPE_XYZ_16,
					    // INTENT_PERCEPTUAL, cmsFLAGS_NOTPRECALC);
					    INTENT_ABSOLUTE_COLORIMETRIC, cmsFLAGS_NOTPRECALC);
	myXYZTransform = cmsCreateTransform (myImageProfile,
					    TYPE_RGB_16,
					    xyzProfile,
					    TYPE_XYZ_16,
					    // INTENT_PERCEPTUAL, cmsFLAGS_NOTPRECALC);
					    INTENT_ABSOLUTE_COLORIMETRIC, cmsFLAGS_NOTPRECALC);
	myInTransform = cmsCreateTransform (myImageProfile,
					    TYPE_RGB_16,
					    dimageLabProfile,
					    TYPE_Lab_16,
					    // INTENT_PERCEPTUAL, cmsFLAGS_NOTPRECALC);
					    INTENT_ABSOLUTE_COLORIMETRIC, cmsFLAGS_NOTPRECALC);
	minInTransform = cmsCreateTransform (minImageProfile,
					    TYPE_RGB_16,
					    dimageLabProfile,
					    TYPE_Lab_16,
					    // INTENT_PERCEPTUAL, cmsFLAGS_NOTPRECALC);
					    INTENT_ABSOLUTE_COLORIMETRIC, cmsFLAGS_NOTPRECALC);
	outTransform = cmsCreateTransform (labProfile,
					    TYPE_Lab_16,
					    srgbProfile,
					    TYPE_RGB_16,
					    INTENT_ABSOLUTE_COLORIMETRIC, cmsFLAGS_NOTPRECALC);
	myDirTransform = cmsCreateTransform (myImageProfile,
					    TYPE_RGB_16,
					    srgbProfile,
					    TYPE_RGB_16,
					    INTENT_ABSOLUTE_COLORIMETRIC, cmsFLAGS_NOTPRECALC);
	minDirTransform = cmsCreateTransform (minImageProfile,
					    TYPE_RGB_16,
					    srgbProfile,
					    TYPE_RGB_16,
					    INTENT_ABSOLUTE_COLORIMETRIC, cmsFLAGS_NOTPRECALC);

	cmsXYZ2xyY (&dimagePrimrs.Red, &dimagePrimaries.Red);
	cmsXYZ2xyY (&dimagePrimrs.Green, &dimagePrimaries.Green);
	cmsXYZ2xyY (&dimagePrimrs.Blue, &dimagePrimaries.Blue);
        cmsBuildRGB2XYZtransferMatrix(&dimageMat, &wPt, &dimagePrimrs);

	while (printf ("> "), gets (buffer)) {
		cmsCIELab Lab;
		unsigned short gains[3];
		int n;

		n = sscanf (buffer, "%hd %hd %hd %hd %hd %hd",
				     in, in+1, in+2, gains, gains+1, gains+2);
		if (n != 3 && n != 6) {
			printf ("?\n");
			continue;
		}
		if (n == 3) {
			gains[0] = gains[1] = gains[2] = 256;
		}
#if 0
		in[0] *= 256;
		in[1] *= 256;
		in[2] *= 256;
#endif
		printf ("%g %g %g\n", in[0] / 65535.0, in[1]/65535.0, in[2]/65535.0);
		incpy[0] = in[0];
		incpy[1] = in[1];
		incpy[2] = in[2];

		cmsDoTransform (minXYZTransform, in, xyz, 1);
		printf ("MRW %d,%d,%d -> XYZ %d,%d,%d", in[0]/256, in[1]/256, in[2]/256, xyz[0], xyz[1], xyz[2]);
		cmsXYZEncoded2Float (&XYZ, xyz);
		printf (" (%g,%g,%g)", XYZ.X, XYZ.Y, XYZ.Z);
		cmsXYZ2xyY (&xyY, &XYZ);
		printf (" -> xyY (%g,%g,%g)\n", xyY.x, xyY.y, xyY.Y);

		cmsDoTransform (minInTransform, in, lab, 1);
		cmsLabEncoded2Float (&Lab, lab);
		printf ("MRW RGB->LAB:  %d,%d,%d => %d,%d,%d == %g,%g,%g\n", in[0], in[1], in[2], lab[0], lab[1], lab[2], Lab.L, Lab.a, Lab.b);
		if (lab[0] == 0) {
			lab[0] = 1;
		}
		cmsDoTransform (outTransform, lab, out, 1);
		printf ("   LAB->sRGB: %d,%d,%d => %d,%d,%d\n", lab[0], lab[1], lab[2], out[0]/256, out[1]/256, out[2]/256);
		cmsDoTransform (minDirTransform, in, out, 1);
		printf ("Mn RGB->sRGB: %d,%d,%d => %d,%d,%d\n", in[0]/256, in[1]/256, in[2]/256, out[0]/256, out[1]/256, out[2]/256);

		in[0] = in[0] * (gains[0]/256.0);
		in[1] = in[1] * (gains[1]/256.0);
		in[2] = in[2] * (gains[2]/256.0);
		cmsDoTransform (minXYZTransform, in, xyz, 1);
		printf ("MRW %d,%d,%d -> XYZ %d,%d,%d", in[0]/256, in[1]/256, in[2]/256, xyz[0], xyz[1], xyz[2]);
		cmsXYZEncoded2Float (&XYZ, xyz);
		printf (" (%g,%g,%g)", XYZ.X, XYZ.Y, XYZ.Z);
		cmsXYZ2xyY (&xyY, &XYZ);
		printf (" -> xyY (%g,%g,%g)\n", xyY.x, xyY.y, xyY.Y);

		cmsDoTransform (minInTransform, in, lab, 1);
		cmsLabEncoded2Float (&Lab, lab);
		printf ("MRW RGB->LAB:  %d,%d,%d => %d,%d,%d == %g,%g,%g\n", in[0], in[1], in[2], lab[0], lab[1], lab[2], Lab.L, Lab.a, Lab.b);
		if (lab[0] == 0) {
			lab[0] = 1;
		}
		cmsDoTransform (outTransform, lab, out, 1);
		printf ("   LAB->sRGB: %d,%d,%d => %d,%d,%d\n", lab[0], lab[1], lab[2], out[0]/256, out[1]/256, out[2]/256);
		cmsDoTransform (minDirTransform, in, out, 1);
		printf ("Mn RGB->sRGB: %d,%d,%d => %d,%d,%d\n", in[0]/256, in[1]/256, in[2]/256, out[0]/256, out[1]/256, out[2]/256);

		printf ("\n");
		printf ("Apply tone curves: %d,%d,%d \n", in[0]/256, in[1]/256, in[2]/256);
#if 1
		in[0] = applyTone (rTRC, in[0]);
		in[1] = applyTone (gTRC, in[1]);
		in[2] = applyTone (bTRC, in[2]);
#endif
		printf (" --> %d,%d,%d ==", in[0]/256, in[1]/256, in[2]/256);
		printf (" %g,%g,%g\n", in[0]/65535.0, in[1]/65535.0, in[2]/65535.0);
		cmsDoTransform (myInTransform, in, lab, 1);
		cmsLabEncoded2Float (&Lab, lab);
		printf ("My RGB->LAB:  %d,%d,%d => %d,%d,%d == %g,%g,%g\n", in[0]/256, in[1]/256, in[2]/256, lab[0], lab[1], lab[2], Lab.L, Lab.a, Lab.b);
		if (lab[0] == 0) {
			lab[0] = 1;
		}
		printf ("Apply iTRC: %d ->", lab[0]);
#if 0
		lab[0] = applyTone (iTRC, lab[0]);
#endif
		printf (" %d\n", lab[0]);
		cmsDoTransform (outTransform, lab, out, 1);
		printf ("   LAB->sRGB: %d,%d,%d => %d,%d,%d\n", lab[0], lab[1], lab[2], out[0]/256, out[1]/256, out[2]/256);
		cmsDoTransform (myDirTransform, in, out, 1);
		printf ("My RGB->sRGB: %d,%d,%d => %d,%d,%d\n", in[0]/256, in[1]/256, in[2]/256, out[0]/256, out[1]/256, out[2]/256);

#if 1
		incpy[0] = in[0];
		incpy[1] = in[1];
		incpy[2] = in[2];
#endif
		printf ("\n");
		cmsDoTransform (myXYZTransform, incpy, xyz, 1);
		printf ("BMB %d,%d,%d to XYZ -> %d,%d,%d", incpy[0]/256, incpy[1]/256, incpy[2]/256, xyz[0], xyz[1], xyz[2]);
		cmsXYZEncoded2Float (&XYZ, xyz);
		printf (" (%g,%g,%g)\n", XYZ.X, XYZ.Y, XYZ.Z);
		cmsXYZ2xyY (&xyY, &XYZ);
		printf (" == xyY (%g,%g,%g)\n", xyY.x, xyY.y, xyY.Y);
		XYZ.X = dimagePrimaries.Red.X * incpy[0] / 65535.0 +
		        dimagePrimaries.Green.X * incpy[1] / 65535.0 +
		        dimagePrimaries.Blue.X * incpy[2] / 65535.0;
		XYZ.Y = dimagePrimaries.Red.Y * incpy[0] / 65535.0 +
		        dimagePrimaries.Green.Y * incpy[1] / 65535.0 +
		        dimagePrimaries.Blue.Y * incpy[2] / 65535.0;
		XYZ.Z = dimagePrimaries.Red.Z * incpy[0] / 65535.0 +
		        dimagePrimaries.Green.Z * incpy[1] / 65535.0 +
		        dimagePrimaries.Blue.Z * incpy[2] / 65535.0;
		printf ("By hand: (%g,%g,%g)\n", XYZ.X, XYZ.Y, XYZ.Z);
		cmsXYZ2xyY (&xyY, &XYZ);
		printf (" == xyY (%g,%g,%g)\n", xyY.x, xyY.y, xyY.Y);
#if 0
		adaptedXYZ = XYZ;
#else
		cmsAdaptToIlluminant (&adaptedXYZ, &dimageWhitePt, &dimageIlluminant, &XYZ);
#endif
		printf ("  Adjust for Illuminant -> %g,%g,%g\n", adaptedXYZ.X, adaptedXYZ.Y, adaptedXYZ.Z);
		cmsXYZ2Lab (&dimageWhitePt, &Lab, &adaptedXYZ);
		printf ("  Convert to Lab -> (%g,%g,%g)\n", Lab.L, Lab.a, Lab.b);
		myXYZ2Lab (&dimageWhitePt, &Lab, &adaptedXYZ);
		printf ("  My Convert to Lab -> (%g,%g,%g)\n", Lab.L, Lab.a, Lab.b);
		cmsFloat2LabEncoded (lab, &Lab);
		cmsDoTransform (outTransform, lab, out, 1);
		printf ("   LAB->sRGB: %d,%d,%d => %d,%d,%d\n", lab[0], lab[1], lab[2], out[0]/256, out[1]/256, out[2]/256);

		printf ("\n");

		printf ("Conversion using dimageMat\n");
#if 0
		incpy[0] = in[0];
		incpy[1] = in[1];
		incpy[2] = in[2];
#endif
		printf ("\n");
		cmsDoTransform (myXYZTransform, incpy, xyz, 1);
		printf ("BMB %d,%d,%d to XYZ -> %d,%d,%d", incpy[0]/256, incpy[1]/256, incpy[2]/256, xyz[0], xyz[1], xyz[2]);
		cmsXYZEncoded2Float (&XYZ, xyz);
		printf (" (%g,%g,%g)\n", XYZ.X, XYZ.Y, XYZ.Z);
		cmsXYZ2xyY (&xyY, &XYZ);
		printf (" == xyY (%g,%g,%g)\n", xyY.x, xyY.y, xyY.Y);
		XYZ.X = dimageMat.v[0].n[0] * incpy[0] / 65535.0 +
		        dimageMat.v[0].n[1] * incpy[1] / 65535.0 +
		        dimageMat.v[0].n[2] * incpy[2] / 65535.0;
		XYZ.Y = dimageMat.v[1].n[0] * incpy[0] / 65535.0 +
		        dimageMat.v[1].n[1] * incpy[1] / 65535.0 +
		        dimageMat.v[1].n[2] * incpy[2] / 65535.0;
		XYZ.Z = dimageMat.v[2].n[0] * incpy[0] / 65535.0 +
		        dimageMat.v[2].n[1] * incpy[1] / 65535.0 +
		        dimageMat.v[2].n[2] * incpy[2] / 65535.0;
		printf ("By dimageMat: (%g,%g,%g)\n", XYZ.X, XYZ.Y, XYZ.Z);
		cmsXYZ2xyY (&xyY, &XYZ);
		printf (" == xyY (%g,%g,%g)\n", xyY.x, xyY.y, xyY.Y);
#if 0
		adaptedXYZ = XYZ;
#else
		cmsAdaptToIlluminant (&adaptedXYZ, &dimageWhitePt, &dimageIlluminant, &XYZ);
#endif
		printf ("  Adjust for Illuminant -> %g,%g,%g\n", adaptedXYZ.X, adaptedXYZ.Y, adaptedXYZ.Z);
		cmsXYZ2Lab (&dimageWhitePt, &Lab, &adaptedXYZ);
		printf ("  Convert to Lab -> (%g,%g,%g)\n", Lab.L, Lab.a, Lab.b);
		myXYZ2Lab (&dimageWhitePt, &Lab, &adaptedXYZ);
		printf ("  My Convert to Lab -> (%g,%g,%g)\n", Lab.L, Lab.a, Lab.b);
		cmsFloat2LabEncoded (lab, &Lab);
		cmsDoTransform (outTransform, lab, out, 1);
		printf ("   LAB->sRGB: %d,%d,%d => %d,%d,%d\n", lab[0], lab[1], lab[2], out[0]/256, out[1]/256, out[2]/256);
		cmsDoTransform (myXYZTransform, in, xyz, 1);
		printf ("Convert to XYZ -> %d,%d,%d", xyz[0], xyz[1], xyz[2]);
		cmsXYZEncoded2Float (&XYZ, xyz);
		printf (" (%g,%g,%g)\n", XYZ.X, XYZ.Y, XYZ.Z);
		cmsAdaptToIlluminant (&adaptedXYZ, &dimageWhitePt, &dimageIlluminant, &XYZ);
		printf ("  Adjust for Illuminant -> %g,%g,%g\n", adaptedXYZ.X, adaptedXYZ.Y, adaptedXYZ.Z);
		cmsXYZ2Lab (&dimageWhitePt, &Lab, &adaptedXYZ);
		printf ("  Convert to Lab -> (%g,%g,%g)\n", Lab.L, Lab.a, Lab.b);
		cmsFloat2LabEncoded (lab, &Lab);

	}
}
