#include "uptime.h"
#include "util.h"
#include <stdio.h>
#include <string.h>
#include <ctype.h>

void print_ipacct(char *dev)
{
  char buf[1024];
  char *p;
  FILE *f;
  unsigned long long in = 0, out = 0;

  f = fopen("/proc/net/dev", "r");
  if (!f) return;
  while (!feof(f)) {
    fgets(buf, sizeof(buf), f);
    p = buf;
    while (isspace(*p)) p++;
    if (strncmp(dev, p, strlen(dev)) == 0) {
      while (*p != ':') p++; p++;
      sscanf(p, "%Lu %*d %*d %*d %*d %*d %*d %*d %Lu %*d %*d %*d %*d %*d %*d %*d", &in, &out);
    }
  }
  fclose(f);
  
  printf("%Lu\n%Lu\n", in, out);
}
  
int main(int argc, char **argv)
{
  char *device = "eth0";
  if (argc > 1) device = argv[1];
  
  print_ipacct(device);
  print_uptime();
  print_hostname();
  return 0;
}
