/***************************************************************************
                          rename.cpp  -  description
                             -------------------
    begin                : Sun Sep 23 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qgroupbox.h>

#include <klocale.h>

#include "rename.h"


Rename::Rename (MyDb* db, QWidget* parent, const char* name, const char* type)
	: QDialog (parent, name, TRUE), db (db), type (type)
{
	initDialog();
	initValue();
	connect(butOk, SIGNAL(clicked()), this, SLOT(slotButOk()));
	connect(butCancel, SIGNAL(clicked()), this, SLOT(slotButCancel()));
}

Rename::~Rename()
{
}

void Rename::initDialog()
{

	QGridLayout* layout = new QGridLayout (this, 3, 3, 12, 14);

	QGroupBox* groupOldName = new QGroupBox (this);
	groupOldName->setTitle(i18n("Old Name"));
	groupOldName->setLineWidth(1);
	groupOldName->setMidLineWidth( 0 );
	layout->addMultiCellWidget(groupOldName, 0, 0, 0, 2);

	QGridLayout* layoutOldName = new QGridLayout (groupOldName, 1, 1, 22, 16);
	oldName = new QComboBox(groupOldName);
	layoutOldName->addWidget(oldName,0,0);

	QGroupBox* groupNewName = new QGroupBox (this);
	groupNewName->setTitle(i18n("New Name"));
	groupNewName->setLineWidth(1);
	groupNewName->setMidLineWidth( 0 );
	layout->addMultiCellWidget(groupNewName, 1, 1, 0, 2);

	QGridLayout* layoutNewName = new QGridLayout (groupNewName, 1, 1, 22, 16);
	newName = new QLineEdit(groupNewName);
	layoutNewName->addWidget(newName,0,0);

	butOk = new QPushButton(this);
	butOk->setText(i18n("OK"));
	layout->addWidget(butOk, 2, 0);

	butCancel = new QPushButton(this);
	butCancel->setText(i18n("Cancel"));
	layout->addWidget(butCancel, 2, 2);

	if (/*type.isEqual("Volume")*/type == "Volume")
	{
		setCaption(i18n("Rename Volume"));
		newName->setMaxLength(40);
	}
	else if (/*type.isEqual("PList")*/ type == "PList")
	{
		setCaption(i18n("Rename PlayList"));
		newName->setMaxLength(50);
	}
	resize (310, 210);
}

void Rename::initValue()
{
	MYSQL_ROW row;
	if (/*type.isEqual("Volume")*/type == "Volume")
	{
		db->getVolname();
	}
	else if (/*type.isEqual("PList")*/type == "PList")
	{
		db->getPLName();
	}

	while ((row=db->getRow()))
		oldName->insertItem(row[0]);
	db->freeRes();
}

QString Rename::getNewName()
{
	return (newName->text());
}

QString Rename::getOldName()
{
	return (oldName->currentText());
}

void Rename::slotButOk()
{
	if (!(newName->text().isEmpty()))
		done(0);
	else
		done(1);
}

void Rename::slotButCancel()
{
	done(1);
}

#include "rename.moc"
