/***************************************************************************
                          localpldial.cpp  -  description
                             -------------------
    begin                : Tue Mar 20 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "localpldial.h"

#include "resources.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qgroupbox.h>

#include <klocale.h>
#include <kmessagebox.h>
#include <kfiledialog.h>



LocalPLDial::LocalPLDial (MyDb* db, QWidget* parent, const char* dname, const char* name)
     :QDialog (parent, name, TRUE), db(db) , defname(dname)
{
     int length;
     initDialog();
     connect (butdirdial, SIGNAL (clicked()), this, SLOT (slotbutdirdial()));
     connect (butok, SIGNAL(clicked()), SLOT (slotbutok()));
     connect (butcancel, SIGNAL(clicked()), SLOT (slotbutcancel()));

     defname.truncate(41);
     defname = defname + " - LOCAL";
     length = defname.length();
     plname->setText(defname);
     plname->setSelection(0, length);

}

void LocalPLDial::initDialog()
{


     QGridLayout* grid = new QGridLayout (this,4,3,8,14);

     QLabel *lplname= new QLabel(i18n("Playlist"), this);
     lplname->resize( lplname->sizeHint() );
     grid->addWidget(lplname,0,0);

     plname = new QLineEdit(this);
     plname->setMaxLength(MAX_PL_L);
     grid->addMultiCellWidget(plname,0,0,1,2);

     grid->addRowSpacing (0, 40);

     QGroupBox* group = new QGroupBox (this);
     group->setTitle(i18n("Base Directory"));
     group->setLineWidth(1);
     group->setMidLineWidth( 0 );
     grid->addMultiCellWidget(group, 1, 2, 0, 2);

     QGridLayout* grid1 = new QGridLayout (group, 1, 2, 15, 4);

     dir = new QLineEdit(group);
     grid1->addWidget(dir,0,0);
     /*ldir->setBuddy (dir);*/


     butdirdial = new QPushButton (group, "Dir..." );
     butdirdial->setText ("...");
     butdirdial->resize (butdirdial->sizeHint() );
     grid1->addWidget (butdirdial, 0,1);
     /*connect (butdirdial, SIGNAL(clicked>()),*/


     butok = new QPushButton (this, "Push_Ok");
     butok->resize (butok->sizeHint() );
     butok->setText( i18n("Ok") );
     grid->addWidget (butok, 3,0);


     butcancel = new QPushButton( this, "Push_Cancel" );
     grid->addWidget(butcancel,3,2);
     butcancel->resize (butcancel->sizeHint() );
     butcancel->setText( i18n("Cancel") );


     plname->setFocus();

     resize (340, 220);
}

QString LocalPLDial::getDirPath()
{
     return (dir->text());
}

QString LocalPLDial::getPLName()
{
     return (plname->text());
}

void LocalPLDial::slotbutok()
{
     MYSQL_ROW row;
     QString pl;

   if ((plname->text()=="") || (dir->text()=="") )
     {
       KMessageBox::sorry( this, i18n("Volume Name and \n"
                                      "Directory Base \n\n"
                                      "Must be NOT NULL !!"  ));
       return;
     }
   //MyDb* db = new MyDb();
   db->getPLName();
   while ((row=db->getRow()))
   {
     pl = row[0];
     if (pl == (plname->text()))
     {
          KMessageBox::sorry( this, i18n("Another Volume exists \n"
                                              "with the same name !"  ));
          return;
     }
   }
   db->freeRes();

     done(0);
}

void LocalPLDial::slotbutcancel()
{
    done(1);
}

void LocalPLDial::slotbutdirdial()
{
     QString dirbase;
     dirbase = KFileDialog::getExistingDirectory(QDir::homeDirPath(), this, i18n("Create in..."));
     dir->setText(dirbase);
}

#include "localpldial.moc"
