/*
 *	draw.c
 *
 *	Routines for drawing text on images
 *
 *	Copyright 2000, Jeroen Vreeken
 *	This program is published under the GNU public license version 2
 *	See also the file 'COPYING'
 *
 */

#include <ctype.h>
#include "motion.h"

struct draw_char {
	char ascii;
	char pix[7][6];
};

struct draw_char draw_table[]= {
	{
		'0',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,1,1},
			{0,1,0,1,0,1},
			{0,1,0,1,0,1},
			{0,1,1,0,0,1},
			{0,0,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'1',	
		{
			{0,0,0,1,0,0},
			{0,0,1,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'2',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,0,0,1,1,0},
			{0,0,1,0,0,0},
			{0,1,0,0,0,0},
			{0,1,1,1,1,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'3',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,0,0,1,1,0},
			{0,0,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'4',
		{
			{0,0,0,0,1,0},
			{0,0,0,1,1,0},
			{0,0,1,0,1,0},
			{0,1,1,1,1,1},
			{0,0,0,0,1,0},
			{0,0,0,0,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'5',
		{
			{0,1,1,1,1,1},
			{0,1,0,0,0,0},
			{0,1,1,1,1,0},
			{0,0,0,0,0,1},
			{0,0,0,0,0,1},
			{0,1,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'6',
		{
			{0,0,1,1,1,1},
			{0,1,0,0,0,0},
			{0,1,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'7',
		{
			{0,1,1,1,1,1},
			{0,0,0,0,0,1},
			{0,0,0,0,1,0},
			{0,0,0,1,0,0},
			{0,0,1,0,0,0},
			{0,0,1,0,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'8',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'9',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,0,1,1,1,1},
			{0,0,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'"',
		{
			{0,0,1,0,1,0},
			{0,0,1,0,1,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'/',
		{
			{0,0,0,0,1,0},
			{0,0,0,0,1,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,1,0,0,0},
			{0,0,1,0,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'(',
		{
			{0,0,0,1,0,0},
			{0,0,1,0,0,0},
			{0,0,1,0,0,0},
			{0,0,1,0,0,0},
			{0,0,1,0,0,0},
			{0,0,0,1,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		')',
		{
			{0,0,0,1,0,0},
			{0,0,0,0,1,0},
			{0,0,0,0,1,0},
			{0,0,0,0,1,0},
			{0,0,0,0,1,0},
			{0,0,0,1,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'@',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,1,1,1},
			{0,1,0,1,1,1},
			{0,1,0,0,0,0},
			{0,0,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'~',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,1,0,0,0},
			{0,1,0,1,0,1},
			{0,0,0,0,1,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'#',
		{
			{0,0,1,0,1,0},
			{0,1,1,1,1,1},
			{0,0,1,0,1,0},
			{0,0,1,0,1,0},
			{0,1,1,1,1,1},
			{0,0,1,0,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'<',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,1},
			{0,0,0,1,1,0},
			{0,1,1,0,0,0},
			{0,0,0,1,1,0},
			{0,0,0,0,0,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'>',
		{
			{0,0,0,0,0,0},
			{0,1,0,0,0,0},
			{0,0,1,1,0,0},
			{0,0,0,0,1,1},
			{0,0,1,1,0,0},
			{0,1,0,0,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'|',
		{
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		',',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,1,1,0,0},
			{0,0,1,1,0,0},
			{0,0,1,0,0,0}
		}
	},
	{
		'.',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,1,1,0,0},
			{0,0,1,1,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		':',
		{
			{0,0,1,1,0,0},
			{0,0,1,1,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,1,1,0,0},
			{0,0,1,1,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'-',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,1,1,1,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'+',
		{
			{0,0,0,0,0,0},
			{0,0,0,1,0,0},
			{0,0,1,1,1,0},
			{0,0,0,1,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'_',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,1,1,1,1,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'\'',
		{
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'a',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,1,1,1,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'b',
		{
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'c',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,1,1,1,1},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,0,1,1,1,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'd',
		{
			{0,0,0,0,0,1},
			{0,0,0,0,0,1},
			{0,0,1,1,1,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'e',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,1,1,1,0},
			{0,1,1,0,0,1},
			{0,1,0,1,1,0},
			{0,0,1,1,1,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'f',
		{
			{0,0,0,0,1,1},
			{0,0,0,1,0,0},
			{0,0,1,1,1,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'g',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,1,1,1,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,1},
			{0,0,0,0,0,1},
			{0,0,1,1,1,0}
		}
	},
	{
		'h',
		{
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,0,1,1,0},
			{0,1,1,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'i',
		{
			{0,0,0,1,0,0},
			{0,0,0,0,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'j',
		{
			{0,0,0,1,0,0},
			{0,0,0,0,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,1,0,0,0}
		}
	},
	{
		'k',
		{
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,0,0,1,0},
			{0,1,0,1,0,0},
			{0,1,1,0,1,0},
			{0,1,0,0,0,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'l',
		{
			{0,0,1,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,0,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'm',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,1,1,0,1,0},
			{0,1,0,1,0,1},
			{0,1,0,1,0,1},
			{0,1,0,1,0,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'n',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,1,0,1,1,0},
			{0,1,1,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'o',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'p',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,1,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,1,1,1,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0}
		}
	},
	{
		'q',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,0,1,1,1,1},
			{0,0,0,0,0,1},
			{0,0,0,0,0,1}
		}
	},
	{
		'r',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,1,0,1,1,0},
			{0,1,1,0,0,1},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		's',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,1,1,1,1},
			{0,1,1,1,0,0},
			{0,0,0,1,1,1},
			{0,1,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		't',
		{
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,1,1,1,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,0,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'u',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,1,1},
			{0,0,1,1,0,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'v',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,0,1,0},
			{0,0,0,1,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'w',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,1,0,1},
			{0,0,1,0,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'x',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,1,0,0,1,0},
			{0,0,1,1,0,0},
			{0,0,1,1,0,0},
			{0,1,0,0,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'y',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,1,0,0,0,1},
			{0,0,1,0,1,0},
			{0,0,0,1,0,0},
			{0,0,1,0,0,0},
			{0,1,0,0,0,0}
		}
	},
	{
		'z',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,1,1,1,1,0},
			{0,0,0,1,0,0},
			{0,0,1,0,0,0},
			{0,1,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'A',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,1,1,1,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'B',
		{
			{0,1,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'C',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'D',
		{
			{0,1,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'E',
		{
			{0,1,1,1,1,1},
			{0,1,0,0,0,0},
			{0,1,1,1,1,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,1,1,1,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'F',
		{
			{0,1,1,1,1,1},
			{0,1,0,0,0,0},
			{0,1,1,1,1,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'G',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,0},
			{0,1,0,1,1,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'H',
		{
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,1,1,1,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'I',
		{
			{0,0,1,1,1,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'J',
		{
			{0,0,1,1,1,1},
			{0,0,0,0,0,1},
			{0,0,0,0,0,1},
			{0,0,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'K',
		{
			{0,1,0,0,0,1},
			{0,1,0,0,1,0},
			{0,1,0,1,0,0},
			{0,1,1,1,0,0},
			{0,1,0,0,1,0},
			{0,1,0,0,0,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'L',
		{
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'M',
		{
			{0,1,0,0,0,1},
			{0,1,1,0,1,1},
			{0,1,0,1,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'N',
		{
			{0,1,0,0,0,1},
			{0,1,1,0,0,1},
			{0,1,0,1,0,1},
			{0,1,0,0,1,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'O',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'P',
		{
			{0,1,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,1,1,1,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'Q',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,1,0,1},
			{0,1,0,0,1,0},
			{0,0,1,1,0,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'R',
		{
			{0,1,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,1,1,1,0},
			{0,1,0,1,0,0},
			{0,1,0,0,1,0},
			{0,1,0,0,0,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'S',
		{
			{0,0,1,1,1,1},
			{0,1,0,0,0,0},
			{0,0,1,1,1,0},
			{0,0,0,0,0,1},
			{0,0,0,0,0,1},
			{0,1,1,1,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'T',
		{
			{0,1,1,1,1,1},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'U',
		{
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'V',
		{
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,0,1,0},
			{0,0,0,1,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'W',
		{
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,1,0,1},
			{0,1,0,1,0,1},
			{0,0,1,0,1,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'X',
		{
			{0,1,0,0,0,1},
			{0,0,1,0,1,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,1,0,1,0},
			{0,1,0,0,0,1},
			{0,0,0,0,0,0}
		}
	},
	{
		'Y',
		{
			{0,1,0,0,0,1},
			{0,0,1,0,1,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		'Z',
		{
			{0,1,1,1,1,1},
			{0,0,0,0,1,0},
			{0,0,0,1,0,0},
			{0,0,1,0,0,0},
			{0,1,0,0,0,0},
			{0,1,1,1,1,1},
			{0,0,0,0,0,0}
		}
	},
	{
		' ',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		0,
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0}
		}
	}
};


#define LINE_SPACE 9
#define NEWLINE "\\n"

static int draw_textn (char *image, int startx, int starty, int height, int width, char *text, int len)
{
	int i, pos, x, y;

	if (startx < 0)
		startx = 0;
	if (startx>width/2) {
		startx -= len*6;
	}
	for (pos = 0; pos < len; pos++) {
		if (startx+(pos+1)*6>=width)
			break;
		i=0;
		while (draw_table[i].ascii && draw_table[i].ascii!=text[pos]) i++;
		for (x=0; x<6; x++) {
			for (y=0; y<7; y++) {
				if (draw_table[i].pix[y][x]) {
					image[x+startx+pos*6+1+(y+starty)*width]=0;
					image[x+startx+pos*6-1+(y+starty)*width]=0;
					image[x+startx+pos*6+(y+starty+1)*width]=0;
					image[x+startx+pos*6+(y+starty-1)*width]=0;
				}
			}
		}
		for (x=0; x<6; x++) {
			for (y=0; y<7; y++) {
				if (draw_table[i].pix[y][x])
					image[x+startx+pos*6+(y+starty)*width]=255;
			}
		}
	}
	return 0;
}


int draw_text (char *image, int startx, int starty, int height, int width, char *text)
{
	int num_nl = 0;
	char *end, *begin;
	
	/* Count the number of newlines in "text" so we scroll it up the image */
	end = text;
	while ((end = strstr(end, NEWLINE))) {
	  num_nl++;
	  end += sizeof(NEWLINE)-1;
	}
	starty -= LINE_SPACE * num_nl;
	
	begin = end = text;
	while ((end = strstr(end, NEWLINE))) {
		int len = end-begin;
		draw_textn(image, startx, starty, height, width, begin, len);
		end += sizeof(NEWLINE)-1;
		begin = end;
		starty += LINE_SPACE;
	}
	draw_textn(image, startx, starty, height, width, begin, strlen(begin));
	return 0;
}
