///////////////////////////////////////////////////////////////////////////////
// $Id: mapview.h,v 1.6 2004/04/21 17:51:43 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    mapview.h
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Declaration of the view area for level maps
*/

#ifndef VIEW_H
#define VIEW_H

// Qt includes
#include <qscrollview.h>

// forward declarations
class MapDocument;
class MapTool;
class QLabel;

///////////////////////////////////////////////////////////////////////////////

//! The view showing the map
/*!
*/

class MapView : public QScrollView  {
	Q_OBJECT

public:
	enum Tool {
		Select,
		Point,
		Line,
		Rectangle
	};

	MapView(MapDocument* doc, QLabel* poslabel, QWidget* parent=0, const char* name=0);
	~MapView();

	inline int columnAt(int x) {
		return x / m_cellSize.width();
	}

	inline int rowAt(int y) {
		return y / m_cellSize.height();
	}

	QLabel* posLabel() { return m_posLabel; }

	void showGrid(bool show) {
		m_drawGrid = show;
		updateContents();
	}

	bool showsGrid() const { return m_drawGrid; }

	void activateTool(Tool tool);

signals:
	void showing();
	void hiding();

	void contextMenu(const QPoint& pos);

public slots:
	void setNumCols(int cols);
	void setNumRows(int rows);
	void setDrawGrid(bool on);

protected:
	MapDocument* m_doc;
	QLabel* m_posLabel;

	int m_numCols;
	int m_numRows;
	QSize m_cellSize;

	bool m_drawGrid;

	MapTool* m_currentTool;
	MapTool* m_toolLine;
	MapTool* m_toolPoint;
	MapTool* m_toolRectangle;
	MapTool* m_toolSelect;

protected:
	void showEvent(QShowEvent* event) {
		emit showing();
		QScrollView::showEvent(event);
	}

	void hideEvent(QHideEvent* event) {
		emit hiding();
		QScrollView::hideEvent(event);
	}

	void contentsMousePressEvent(QMouseEvent* e);
	void contentsMouseReleaseEvent(QMouseEvent* e);
	void contentsMouseMoveEvent(QMouseEvent* e);
	void contentsContextMenuEvent(QContextMenuEvent* e);
	void drawContents(QPainter* p, int clipx, int clipy, int cliph, int clipw);
	void paintCell (QPainter* p, int row, int col);

public slots:
	void slotDocumentChanged();
};

#endif

// End of file
