
#	MMAauto.py
	
"""
	This module is an integeral part of the program 
	MMA - Musical Midi Accompaniment.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Bob van der Poel <bvdp@uniserve.com>
	
"""
	

import os
import sys
import pickle

import MMAmidi
import MMAglobals;  gbl = MMAglobals
import MMAparse
from MMAcommon import *

grooveDir = {}
mmadir = "MMADIR"	# constant, name of the lib database file
fileCount = 0
grooveCount = 0
gdDate = None
processedFiles = []

def libUpdate(force):
	""" Update the mma library database file(s) with -g or -G option.
	
		This is called from the main program after the initialization
		and other option parsing. No RETURN.
	"""

	global fileCount, grooveCount, gdDate, grooveDir, processedfiles

	# Attempt to read existing database

	if force == 1:	
		try:
			infile = os.path.join(os.path.expanduser(gbl.libPath), mmadir)
			f=file(infile, "rb")
			f.readline()	# Read/discard comment line
			grooveDir = pickle.load(f) 
			f.close()
			gdDate = os.path.getmtime(infile)
		except:
			pass
	
	print "Creating MMA groove directory database. Standby..."

	libpath = os.path.expanduser(gbl.libPath)
	dolibupdate(libpath, '')	

	# Strip out defs of deleted (not found) files.
	
	for f in grooveDir.keys():
		if f not in processedFiles:
			print "Deleting: %s" % f
			del grooveDir[f]
			

	try:
		outpath = file(os.path.join(libpath, mmadir), 'wb')
	except:
		error("Error creating lib-database file '%s'. CRITICAL!" 
			% libpath)

	outpath.write("### MMADIR ... AUTOGENERATED BINARY DATA.  DO NOT EDIT!!!\n")
	pickle.dump(grooveDir, outpath, pickle.HIGHEST_PROTOCOL	)
	outpath.close()		

	print
	print "Database update complete."
	print "  Total files: %s" % len(grooveDir)
	print "  Files processed: %s" % fileCount
	print "  Total number of grooves: %s" % grooveCount
	sys.exit(0)

		
def dolibupdate(root, subdir):
	""" Recursive function to read groove files in a directory. """

	global fileCount, grooveCount, gdDate, grooveDir, processedFiles
	
	if subdir == '.':
		print "Skipping: '.'"
	else:
		print "  Processing library directory '%s'." % subdir
	

	""" Get a list of the files in this directory. If the list
		includes a file called 'MMAIGNORE' the entire directory
		(and subdirs) is ignored. Otherwise, each file in the
		directory ending in 'mma' is parsed for groove defs.
	"""
			
	p = os.path.join(root,subdir)
	dirfiles = os.listdir(p)
	
	if dirfiles.count("MMAIGNORE"):
		print "Skipping: %s" % p
		return

	dirfiles.sort()		

	for fn in dirfiles:
		f=os.path.join(root, subdir, fn)

		if os.path.isdir(f):
			dolibupdate(root, os.path.join(subdir,fn))	# recursive!
			
		elif f.endswith(gbl.ext):
			ename = os.path.join(subdir, fn)
			
			processedFiles.append(ename)
			
			if gdDate and grooveDir.has_key(ename) and \
					os.path.getmtime(f) < gdDate:
				print "Existing: %s" % f
				grooveCount += len(grooveDir[ename])
				continue

			if grooveDir.has_key(ename):
				print "Updating: %s" % f
			else:
				print "Creating: %s" % f
			gbl.mkGrooveList = []
			gbl.mtrks = {}
			gbl.mtrks[0]=MMAmidi.Mtrk(0)
			gbl.tnames = {}
			MMAparse.parseFile(f)	# read current file, grab grooves

			fileCount += 1			# just so we can report to user
			grooveCount += len(gbl.mkGrooveList)

			grooveDir[ename]=gbl.mkGrooveList

		else:
			print "Ignoring: %s" % f
			


#################################################################


def loadGrooveDir(g):
	""" Try to auto-load a groove from the library.
	
		The compliation of all the MMADIR files is stored in the dict
		grooveDir{}. 
	
		Check the main libpath directory for the MMADIR file. The
		names of the files and corresponding grooves are extracted.
		This is stored in a dictionary with the filename as the key
		and a list of grooves as the data.
		
	"""

	global grooveDir

	""" If the global dict grooveDir is empty we first load the MMADIR info.
		We're assuming that not to much goes wrong here...if we don't find
		the database we set grooveDir{} to a BS value to avoid future
		load attempts. The entire load is in a try which means it either
		all works, or not ...
	"""

	if not grooveDir:
		try:
			infile = os.path.join(os.path.expanduser(gbl.libPath), mmadir)
			f=file(infile, "rb")
			f.readline()	# Read/discard comment line
			grooveDir = pickle.load(f) 
			f.close()
		except:
			grooveDir[0]=''


	""" Search the dict for a match. grooveDir{} is a dictionary
			for lists. Each dictionary key is filename (eg: "lib/rhumba.mma")
			and the list associated with it is a list of grooves defined
			in that file. Just a matter of stepping though the dict. and
			returning the proper filename.
			
		RETURN: Lib-Filename if found
		        None if not found
	"""		     

	for k,l in grooveDir.items():
		if l.count(g):
			return k
	
	return None


