/*
 * Copyright (c) 2001, 2002 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
/*
   Here's a small example: it asks for a portbase and a destination and starts
   sending packets to that destination.

   IMPORTANT:
   	This sample was written for unix-like environments. For a Windows
   	platform, you'll need to perform Winsock initialisation through
   	WSAStartup.
*/

#include <stdlib.h>
#include <stdio.h>
#include "rtpsession.h"
#include "rtppacket.h"

/*
   This function checks if there was a RTP error. If so, it displays an error
   message and exists.
*/

void checkerror(int rtperr)
{
	if (rtperr < 0)
	{
		char *errstr;
		
		// This function gets the error string for a certain error code
		errstr = RTPGetErrorString(rtperr);
		
		printf("Error:\n");
		printf("%s\n",errstr);
		exit(-1);
	}
}

/*
   The main routine
*/

int main(void)
{
	RTPSession sess;
	int portbase;
	unsigned long destip;
	int destport;
	char ipstr[256];
	int status,i;
	char dummybuffer[1024];

        /*
           First, we'll ask for the necessary information
        */
		
	printf("Enter the local portbase\n");
	scanf("%d",&portbase);
	printf("\n");
	
	printf("Enter the destination IP address\n");
	scanf("%s",ipstr);
	destip = inet_addr(ipstr);
	if (destip == 0xFFFFFFFF)
	{
		printf("Bad IP address specified\n");
		return -1;
	}
	
	// The inet_addr function returns a value in network byte order, but
	// we need the IP address in host byte order, so we use a call to
	// ntohl
	destip = ntohl(destip);
	
	printf("Enter the destination port\n");
	scanf("%d",&destport);
	
	/*
	   Now, we'll create a RTP session, set the destination, send some
	   packets and poll for incoming data.
	*/
	
	status = sess.Create(portbase);	
	checkerror(status);
	
	status = sess.AddDestination(destip,destport);
	checkerror(status);
	
	for (i = 1 ; i <= 10 ; i++)
	{
		printf("\nSending packet %d/10\n",i);
		
		// send the packet
		checkerror(status);
		
		// poll for incoming data
		status = sess.PollData();
		
		// check incoming packets
		if (sess.GotoFirstSourceWithData())
		{
			do
			{
				RTPPacket *pack;
				
				while ((pack = sess.GetNextPacket()) != NULL)
				{
					// You can examine the data here
					printf("Got packet !\n");
					
					// we don't longer need the packet, so
					// we'll delete it
					delete pack;
				}
			} while (sess.GotoNextSourceWithData());
		}
		
		printf("Press enter to send the next packet\n");
		gets(dummybuffer);
	}
	
	return 0;
}
