# -*- ruby -*-
#
# Expanding a template which includes already tagged text.
#

require 'xtemplate'

data = {
  'members' => [
    {'name' => 'name1', 'age' => 21},
    {'name' => 'name2', 'age' => 22},
    {'name' => 'name3', 'age' => 23},
  ],
}

text = <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<members>
  <member id="members">
     <name id="name" />
     <age id="age" />
     <comment>This entry is generated by xtemplate.</comment>
  </member>
  <member>
     <name>foo</name>
     <age>22</age>
  </member>
</members>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
