/*----------------------------------------------------------------------------

   libtunepimp -- The MusicBrainz tagging library.  
                  Let a thousand taggers bloom!
   
   Copyright (C) Robert Kaye 2003
   
   This file is part of libtunepimp.

   libtunepimp is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   libtunepimp is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with libtunepimp; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   $Id: wav_trm.h,v 1.3 2003/10/24 19:10:48 robert Exp $

----------------------------------------------------------------------------*/
#ifndef __WAV_TRM_H_
#define __WAV_TRM_H_

#include <string>
using namespace std;

#include "trm.h"

class TRMGeneratorWav : public TRMGenerator
{
    public:

                TRMGeneratorWav(TunePimp *tunepimp) : TRMGenerator(tunepimp) {};
       virtual ~TRMGeneratorWav(void) {};


       /* For generate function, the duration argument can be used to either
          override the length of the file itself (if its only a partial file), or
          to retrieve the length of the file. Your options are:

            1. Pass in 0 for duration, and the function will calculate the
               duration of the file from the file. THIS MAKES THE DECODE PROCESS
               A LOT SLOWER!! The calculated duration will be placed back into
               the duration argument.
            3. Pass in a non-zero duration for the file.

          In each case, the duration passed in or returned from these functions
          is in MILLISECONDS!

       */
       virtual TRMResult generate(const string &fileName, string &sig, 
                                  unsigned long &duration);
};
#endif
