#!/do/not/bash
# toc_run_description = looking for libcurl
# toc_begin_help =
#
# Looks for libcurl. It expects to find curl-config in the PATH, and
# will use that to export the following vars:
#
#
#	HAVE_LIBCURL = 0 or 1
#	LIBCURL_LIBS = list of libs needed when linking against
# libcurl. Empty if HAVE_LIBCURL is 0.
#	LIBCURL_CFLAGS = list (possibly empty) of arguments to pass
# to the C compiler. e.g., -I/prefix/of/curl/include
#
# It honors the configure command-line argument
# --with-curl-config=/path/to/curl-config

# = toc_end_help

toc_export HAVE_LIBCURL=0
toc_export LIBCURL_LIBS=
toc_export LIBCURL_CFLAGS=
cconf=${configure_with_curl_config}
test x = "x$cconf" && cconf=$(which curl-config 2>/dev/null)

test x = "x${cconf}" && {
    echo "curl-config not found in PATH. Try using --with-curl-config=/path/to/curl-config"
    return 1
}

test -e $cconf || {
    echo "curl-config not found."
    return 1
}

toc_export HAVE_LIBCURL=1
export cconf
toc_export LIBCURL_LIBS=$($cconf --libs)
toc_export LIBCURL_CFLAGS=$($cconf --cflags)
unset cconf

return 0
