# toc_run_description = looking for boost
# toc_begin_help =
#
#  Looks for headers for the boost C++ libraries (www.boost.org).
#
# Requires --with-boost=/path/to/boost or the environment var
# configure_with_boost, which must point to the top-most directory of
# the boost tree (e.g., the boost source tree).
#
# It does not check for boost code which requires compilation, only
# some common headers files.
#
# It calls toc_export for these config vars: 
#
# - HAVE_BOOST = zero or one
# - BOOST_HOME = path to boost source tree
#
# It accepts an optional list of boost headers to check, which should
# be given as relative paths, assuming a top path of ${BOOST_HOME}.
#
# = toc_end_help

toc_export BOOST_HOME=
toc_export HAVE_BOOST=0

path=${configure_with_boost-0}
test x$path = x0 -o x$path = 1 && {
    echo "--with-boost=/path/to/boost not set. Skipping boost test."
    return 1
}

test -d "$path" || {
    echo "--with-boost: path not found: $path"
    return 1
}
for i in version.hpp type_traits.hpp config.hpp $@; do
    toc_find $i $path/boost || return 1
done

toc_export HAVE_BOOST=1
toc_export BOOST_HOME="$path"
