// This code is copyright (C) 1998 Mikael Brandstrm <mikael@Unix.PP.SE>
// It can be freely distributed and copied under the terms of the
// GNU General Public License version 2, as published by the Free Software
// Foundation.
//
// This code comes with NO WARRANTY of any kind, either implicit or explicit.

// Credits
//
//  smtp_speaker() heavily based on Per Hedbor's low_send_mail from
//  lsabrev.pike CVS-ver 1.4
//
//
//  For more information see README
//
// WARNING: This code should be considered in alpha testing stage. There are
// probably still lots and lots of bugs. Please send any bugreports or patches
// to the address mentioned above. 
//
// Most of the comments are in Swedish. I will translate them later.
//

inherit "module";
inherit "roxenlib";
#include <module.h>
#include <roxen.h>
#include <config.h>

//#define WM_DEBUG


string version = "0.3 (alpha)";
string cvs_version = "$Id: webmail.pike,v 1.24 1998/08/29 20:22:16 mikael Exp $";
string x_mailer="WebMail "+version+" (Mail-Reader for Roxen) (CVS:$Revision: 1.24 $)";
constant thread_safe=1; 

// Variables for grabbing statistics

int no_calls, tot_time, suid_time, tid, failed, success;
mapping(string:int) users;
mapping(string:multiset) ca_inf;

// Variables used when running.

string domain="";
string mbox_path="";
string home_mbox="";
string smtpserv="";
string ca_un;
int ca_exp=900;

// Internal mailbox locking routines (protect against other threads)
// Only used with threads
#ifdef THREADS
object lt_lock=Thread.Mutex();
mapping mbox_mtxs=([ ]);
mapping mbox_locks=([ ]);
int uniqueness=0;

int mb_lock(string file){
  int unique;
  object tk,key;
  if(!(tk=lt_lock->trylock())){
#ifdef WM_DEBUG_L
    perror("WebMail: mb_lock(): lock mapping locked, will wait\n");
#endif
    tk=lt_lock->lock();
  }
#ifdef WM_DEBUG_L
  perror("WebMail: mb_lock(): lock mapping locked\n");
#endif

  //  The mutex is locked, only we do this, thus unique
  unique=uniqueness++;
  if(!mbox_mtxs[file])
    mbox_mtxs[file]=Thread.Mutex();

  if(key=mbox_mtxs[file]->trylock()){
    destruct(tk);
  }else{
#ifdef WM_DEBUG
    perror("WebMail: " + file + " is already locked. Will wait\n");
#endif
    destruct(tk);
    key=mbox_mtxs[file]->lock();
  }
#ifdef WM_DEBUG
  perror("WebMail: got lock for: " + file + "\n");
#endif   
  
  mbox_locks[unique]=key;

#ifdef WM_DEBUG
  perror("WebMail: lock id is: " + (string)unique + "\n");
#endif  

  return unique;
}

void mb_unlock(int unique){
#ifdef WM_DEBUG
  perror("WebMail: Unlocking " + (string) unique + "\n");
#endif
  object tk;
  tk=lt_lock->trylock();
  if(!tk){
#ifdef WM_DEBUG_L
    perror("WebMail: mb_unlock(): lock mapping locked, will wait\n");
#endif
    tk=lt_lock->lock();
  }
#ifdef WM_DEBUG_L
  perror("WebMail: mb_unlock(): lock mapping locked\n");
#endif
  object key=mbox_locks[unique];
  mbox_locks=mbox_locks - ([unique:key]);
  destruct(key);
}
#else // THREADS
int mb_lock(string foo){
#ifdef WM_DEBUG
  perror("No need to lock in non-threaded roxen\n");
#endif
  return 0;
}

void mb_unlock(int unique){
  return;
}
#endif




// Routines called by Roxen

mixed low_ff(object id, string f);

array register_module(){
  return ({
    MODULE_LOCATION,
    "WebMail mail-reader",
    "This module will give your users the ability to read their "
    "mail from a web-page. All you need is to have an AUTH-module "
    "ie. UserDB to authenticate the users, "
    "and set the path to where the mailboxes reside "
    "properly.",0,0});
}

void start(){
  domain=query("domain");
  mbox_path=query("mbox");
  home_mbox=query("home_mbox");
  smtpserv=query("smtpserv");
  ca_exp=query("ca_exp");
  ca_un= "WebMail(" + my_configuration()->name + query("location") +
    "):";
  tid=time();
  no_calls=0;
  tot_time=0;
  suid_time=0;
  failed=0;
  success=0;
  string tmp;
  if(users)
    foreach(indices(users),tmp)
      cache_clear(ca_un + tmp);
  ca_inf=([ ]);
  users=([ ]);
}

// Compute some stats for the cache
array cu_us(string us){
  int s=0,n=0;

  if(ca_inf[us]){
    mixed tmp;
    mixed in_cache;
    string ca_id=ca_un + us;
    foreach(indices(ca_inf[us]),tmp)
      if(in_cache=cache_lookup(ca_id,tmp)){
	n+=sizeof(in_cache->cache);
	s+=get_size(in_cache);
	/*	foreach(in_cache->cache,tmp2){
	  // This will cover most of it
	  	s+=sizeof(tmp2->subject);
 		s+=sizeof(tmp2->from);
	 	s+=sizeof(tmp2->id);
	  */
	//  s+=get_size(tmp2);
	//}
	
      }
    return ({n,s});
  }
  
  return ({0,0});
  
}

array cache_use(string|void us){
  string tmp;
  if(!us){
    int n=0,s=0;
    foreach(indices(users),tmp){
      array a;
      a=cu_us(tmp);
      n+=a[0]; s+=a[1];
    }
    return ({n,s});
  }else{
    return cu_us(us);
  }
}

string status(){
  array a;
  a=cache_use();
  string ret =  "Statistics since " + ctime(tid) +
    "<br><table border=0>"
    "<tr><td>Number of calls:<td>" + (string)no_calls +
    "<tr><td>Number of failed logins:<td>" + (string)failed +
    "<tr><td>Number of successfull logins:<td>" + (string)success +
    "<tr><td>CPU time used (ms):<td>" + (string)tot_time +
    "<tr><td>CPU time used with user-privs (ms):<td>" + (string)suid_time +
    "<tr><td>Number of cache entries:<td>" + (string)a[0] +
    "<tr><td>Size of cache:<td>" + (string)a[1] +
    "</table><p>" +
    "Per user statistics:<br><table border=0>"
    "<tr><td>User:<td>No. of acc<td>No. cache ent.<td>Size of cache";
  string t;
  foreach(indices(users),t){
    a=cache_use(t);
    ret +="<tr><td>" + t + "<td>" + (string)users[t] +
      "<td>" + (string)a[0] + "<td>" + (string) a[1] ;
  }
  ret += "</table>";
  return ret;

    
}

void create(){
  defvar("location","/mail","Location",TYPE_LOCATION,
	 "Where to mount the mailreader.");
  defvar("mbox","/var/spool/mail","Mailbox location",TYPE_DIR,
	 "The directory in which the users' mailboxes reside.");
  defvar("domain","localhost","Mail domain",TYPE_STRING,
	 "The domainname to append to the username when sending mail.");
  defvar("smtpserv","localhost","SMTP-Server",TYPE_STRING,
	 "Which smtp-server the mails should be sent via.");
  defvar("home_mbox","mail","Personal mailboxes",TYPE_STRING,
	 "Where, relative to user's homedir, personal mailboxes are kept.");
  defvar("ca_exp",900,"Cache expiry time (seconds)",TYPE_INT,
	 "How long the message index cache should be kept. (The default value "
	 "should work. If WebMail eats lots of memory you colud try to lower "
	 "it, but that will make WebMail eat more CPU time. If you only have "
	 "a few people reading their mail you could make this an hour or "
	 " more.)");
  defvar("sig",".signature","Signature file",TYPE_FILE,
	 "File in user's homedir containing a signature which is appended "
	 "the mail while sending or composing a new mail.");
  defvar("dotf",1,"Ignore dot-folders",TYPE_FLAG,
	 "If folders with names debinning with a dot be ignored in the "
	 "folder list.");
  defvar("recurse",0,"Recurse personal mailbox-dir",TYPE_FLAG,
	 "If the personal mailbox-dir should be checked for subdirs. "
	 "If so, the folders in the subdir are included in the folder-list. "
	 "(Beware that this will cause a lot of calls to stat() when the "
	 "folder-list is created.");
}

mapping find_file(string f, object id){
  no_calls ++;
  mapping ret;
  tot_time += gauge {
      ret = low_ff(id,f);
    };
  return ret;
}
    

// Low level routines

mapping myret(object id, string msg, string title, int|void nm, int|void mi,
	      int|void fl, int|void err){
  string res="";

  // Fix the head
  res += "<html>\n<!-- Ver: " + version + " -->\n<!-- CVSVER:" + cvs_version + 
    " -->\n <head><title>WebMail: " + title + "</title></head>" +
    "<body link=\"#0000ee\" text=\"#000000\" bgcolor=\"#ffffff\" " +
    "vlink=\"#551a8b\" alink=\"#ff0000\">\n";
  res += parse_rxml("<gh2 nfont=courier bg=\"#ffffff\" fg=\"#000070\">" +
		    ((sizeof(title)>25)?(title[..34]+ "..."):title) + 
		    "</gh2><br><br>", id);
  // Add the body
  res += msg;
  // Fix the end
  res += "<hr>";
  string r="";
  if(nm)
    r += "<gtext 3 magic bg=\"#aaaacc\" fg=\"#000070\" border=3,\"#0000aa\" "
      "notrans magic_fg=\"#000070\" magic_glow=\"#ff0000\" href=/(new)" + 
      id->not_query + ">Compose</gtext>";
  if(mi)
    r += "<gtext 3 magic bg=\"#aaaacc\" fg=\"#000070\" border=3,\"#0000aa\" "
      "notrans magic_fg=\"#000070\" magic_glow=\"#ff0000\" href=" + 
      id->not_query + ">Mail index</gtext>";
  if(fl)
    r += "<gtext 3 magic bg=\"#aaaacc\" fg=\"#000070\" border=3,\"#0000aa\" "
      "notrans magic_fg=\"#000070\" magic_glow=\"#ff0000\" href=/(fl)" + 
      id->not_query + ">Folder list</gtext>";
  
  res += parse_rxml(r,id);

  res += "<hr> WebMail "+version+" Copyright &copy; 1998 Mikael Brandstrm " +
    "<a href=mailto:mikael@unix.pp.se>&lt;mikael@Unix.PP.SE&gt;</a>";
  res += "</body></html>";

  mapping ret;
  if(err)
    ret=http_low_answer(err,res);
  else
    ret=http_low_answer(200,res);
  ret->extra_heads=(["Pragma":"no-cache"]);

  return ret;
      
}

object open_mailbox(object id, string f){
  object inf;
  int err;
  
  
  inf = Stdio.FILE();

  string file;
  if(f=="INBOX")
    file=mbox_path + id->auth[1];
  else{
    array ui=id->conf->userinfo(id->auth[1]);
    file=ui[5] + "/" + home_mbox + "/" + f;
  }
  
  suid_time += gauge {

      // Vi behver lite rttigheter fr att ppna filen
      object privs = Privs("WebMail: opening mailbox: " + file, 
			   id->misc->uid,id->misc->gid);
      err=inf->open(file,"r");
      destruct(privs);
    };
  

  if(!err)
    throw(({ "Unable to open mailbox: " + file + " (errno=" + errno() +
	     ")", backtrace()}));
  
  return inf;

}

string myconv(string str){
  array(string) spl,splny=({ });
  if(str==0)
    return "";
  spl = (string)str / " ";
  int i;
  mixed tmp;
  for(i=0;i<sizeof(spl);i++){
    splny+=({MIME.decode_word(spl[i])[0]});
  }
  string ret = splny * " ";
  ret=html_encode_string(ret);
  ret = replace(ret,({"\""}),({"&quot;"}));

  return ret;
}
      
string headrewr(string str){
  string ts;
  array t = ({});


  if(!(sizeof(str / ",") > 1)){
    t+=({ str });
  }else{
    t = str / ",";
  }
  str="";

  // Verktyg
  object re=Regexp("([^ \t\n]*)[ \t\n]*\\((.+)\\)");

  foreach(t,ts){
    if(re->match(ts)){
      array t1=re->split(ts);
      str += t1[1] + " <" + t1[0] + ">, ";
    }else{
      str += ts + ", ";
    }
  }
  str = str[..(sizeof(str) - 3)]; // Ta bort sista ", "
  
  return str;
}

array|int getnextmsg(object inf){

  mixed buf="",tmp;
  int where;
  
  // Ett litet verktyg
  object nymsg;
  nymsg=Regexp("^From ");
  
  // Tom mailbox eller slut p mail
  if(!(tmp=inf->gets()))
    return(0);

  // Annars har vi lst en ndvndig rad
  buf+=tmp + "\n";

  // Fortstt lsa tills vi nr nytt meddelande eller slutet
  while((tmp=inf->gets())&&!nymsg->match(tmp)){
    buf+=tmp + "\n";
  }
  if(tmp)
    inf->ungets(tmp);
  where=inf->tell();
  buf += "\n";
  return ({buf,where});
}

// Update the cache if needed

void update_cache(object id, string f){
  string user=id->auth[1];
  // Do we need to rebuild the cache for this mailbox?
  string file;
  if(f=="INBOX")
    file=mbox_path + id->auth[1];
  else{
    array ui=id->conf->userinfo(id->auth[1]);
    file=ui[5] + "/" + home_mbox + "/" + f;
  }
  array st;
  int lid=mb_lock(file);
  suid_time += gauge {

      // Stat the file as the user who owns it
      object privs = Privs("WebMail: stat():ing mailbox: " + file, 
			   id->misc->uid,id->misc->gid);
      st = file_stat(file);
      destruct(privs);
    };
  if(!st){
    mb_unlock(lid);
    return;
  }
  int mt=st[3];
  
  string ca_id=ca_un + user;
  
  mixed in_cache;

  array(mapping|int) ca_ents = ({ });
  
  if(!(in_cache=cache_lookup(ca_id,f)) ||  mt > in_cache->mbox_time) {
#ifdef WM_DEBUG
    perror("Rebuilding cache for " + user + ":" + f + ".\n");
#endif
    object inf;
    inf = open_mailbox(id, f);
    array buf;
    int where=inf->tell(); // Always 0 ..

    while(buf=getnextmsg(inf)){
      object msg;
      mapping(string:string|int) th=([ ]);
      th->pos=where;
      th->isize=sizeof(buf[0]) - 1; // It's 1 too long..
      where=buf[1];
      mixed err= catch{
	msg=MIME.Message(buf[0]);
      };
      if(err){
	// This is most likely a bad Content-Type ..
	// Give that a try at least
	object re=Regexp("(.*)\n[Cc]ontent-[Tt]ype:[ \t]*([^ \\t]*)\n(.*)");
	if(!re->match(buf[0])){
	  ca_ents+=({-1});
	  continue;
	}
	// This is quite ugly.. but.. at least if it is a text message
	// it will be somewhat readable..
	array sp=re->split(buf[0]);
	buf[0]=sp[0] + "\nContent-Type: text/plain \n" + sp[2];
	if(catch(msg=MIME.Message(buf[0]))){
	  ca_ents+=({-1});
	  continue;
	}
      }
      // We really need that message-id. 
      if(!msg->headers["message-id"]){
	continue;
      }
      th->from=myconv(msg->headers->from);
      th->subject=myconv(msg->headers->subject);
      th->subject = (th->subject=="")?"(no subject)":th->subject;
      th->id=MIME.encode(msg->headers["message-id"],"base64",0,1);
      th->size=(string)sizeof(buf[0]);
      ca_ents +=({th});
    }
    inf->close();
#ifdef WM_DEBUG
    perror("Read " + (string)sizeof(ca_ents) + " messages to cache index\n");
#endif
    mapping ca_ent = ([ "cache":ca_ents,
			"mbox_time":mt]);
    cache_set(ca_id,f,ca_ent,ca_exp);
    if(!ca_inf[user])
      ca_inf[user]=(< >);
    ca_inf[user][f]=1;

  }else{
#ifdef WM_DEBUG
    perror("No need to update cache\n");
#endif
  }
  mb_unlock(lid);
}

array(mapping) getmsginfo(object id, string f){
  update_cache(id,f);
  string user=id->auth[1];
  string ca_id= ca_un + user;
  mixed in_cache;
  if(in_cache=cache_lookup(ca_id,f))
    return in_cache->cache;
  else
    return ({ });
}


// Return a MIME.message

object getmsg(object id, string f, string msgid){
  update_cache(id,f); // Who knows if someone cleared the cache
  string user=id->auth[1];
  string ca_id=ca_un + user;
  mapping in_cache;
  if((in_cache=cache_lookup(ca_id,f)) && in_cache->cache != ({ })){
    // Find the mail
    mapping tmp;
    foreach(in_cache->cache,tmp)
      if(mappingp(tmp) && tmp->id == msgid){
	// We have found the mail. Read it and return it,
#ifdef WM_DEBUG
	perror("Found mail in " + f + ". Pos:" + (string)tmp->pos +
	       " Length:" + (string)tmp->isize + "\n");
#endif
	
	object inf = open_mailbox(id, f);
	inf->seek(tmp->pos);
	object msg;
	string buf=inf->read(tmp->isize);
	// Same hack as in getmsginfo
	mixed err= catch{
	    msg=MIME.Message(buf);
	  };
	if(err){
	  // This is most likely a bad Content-Type ..
	  // Give that a try at least
	  object re=Regexp("(.*)\n[Cc]ontent-[Tt]ype:[ \t]*([^ \\t]*)\n(.*)");
	  if(!re->match(buf)){
	    return 0;
	  }
	  array sp=re->split(buf);
	  buf=sp[0] + "\nContent-Type: text/plain \n" + sp[2];
	  if(catch(msg=MIME.Message(buf))){
	      return 0;
	  }
	}

	
	inf->close();
	return msg;
      }
  }
  return 0;

}




mixed mkmaillist(object id, string f){
  
  array(mapping) msginf=getmsginfo(id,f);

  // Kolla om vi har mail 
  
  if(msginf == ({ }))
    return myret(id,"You have no mail","Mail index of " + f,1,0,1);
  
  // Vi har mail. Ta hand om det.

  string ret = "<table border=1><tr><td></td><td>From</td><td>Size</td><td>Subject</td></tr>\n";
  mapping|int t;
  int cnt=0;
  foreach(msginf,t){
    cnt++;
    if(mappingp(t)){
      ret += "<tr><td>" + (string) cnt + "<td><a href=\"/(read)"+ 
	id->not_query +"?id=" + t->id + "\">";
      ret += t->from + "</a></td>";
      ret += "<td align=right>" + t->size + "</td>";
      ret += "<td>" + t->subject + "</td></tr>\n";
    }else{
      ret += "<tr><td>" + (string) cnt + "<td>Unable to parse this mail</td></tr>\n";
    }
  }
  ret += "</table>";
  
  return myret(id,ret,"Mail index of " + f,1,0,1);
}


string showtext(object id,object msg,int lev,int no){
  lev++;
  string ret="\n<!-- lev=" + (string) lev + "; no=" + (string) no + "-->\n";
  if(msg->body_parts==0){
    // Vi r i ett endels-meddelande
    
    // Vi kan visa text/plain och text/html p skrmen
    // Resten fr man plocka hem och lta weblsaren hantera.

    // Frsta hand text/plain
    if(msg->type=="text" && (msg->subtype=="plain" ||
			     msg->subtype=="enriched")){
      ret += "Message text";
      ret += ":<br>\n<pre>";
      ret += html_encode_string(msg->getdata());
      ret += "</pre>";
      ret += "<a href=\"/(reply)"+
	id->not_query + "?" +
	id->query + "&amp;part=" + (string)lev + "+" + (string)no + 
	"\"> Reply";
      if(!(lev==1 && no==0))
	ret += " to this part";
      ret += "</a>";
    }else if(msg->type=="text" && msg->subtype=="html"){
      ret += "Message text";
      ret += ":<br>\n<blockquote>";
      ret += html_encode_string(msg->getdata());
      ret += "</blockquote>";
      ret += "<a href=\"/(reply)"+
	id->not_query + "?" +
	id->query + "&part=" + (string)lev + "+" + (string)no + 
	"\"> Reply";
      if(!(lev==1 && no==0))
	ret += " to this part";
      ret += "</a>";
    }else{
      ret += "Unable to show this part. <a href=\"/(get)"+
	id->not_query + "?" +
	id->query + "&amp;part=" + (string)lev + "+" + (string)no + 
	"\">Download file (" + msg->params->name + ")</a>";
    }
  }else{
    ret += "This is a multipart message";
    object t;
    int i=1;
    foreach(msg->body_parts,t){
      ret += "<hr>Part " + (string) lev + "." + (string) i + ".<br><br>\n";
      ret += showtext(id,t,lev,i);
      i++;
    }
  }
  return ret;
}


mapping(string:string) readmail(object id, string f){
  object msg;
  if(!(msg = getmsg(id,f,replace(id->variables->id," ","+"))))
    throw(({"Did someone alter the mailbox?\n",backtrace()}));
  
  // Dags att bygga upp meddelandet
  string ret = "";
  
  // Frst brevhuvudet
  ret += "<table>";
  if(msg->headers->date)
    ret += "<tr><td>Date:</td><td>"+ myconv(msg->headers->date) + "</td></tr>";
  if(msg->headers->from)
    ret += "<tr><td>From:</td><td>"+ myconv(msg->headers->from) + "</td></tr>";
  if(msg->headers["reply-to"])
    ret += "<tr><td>Reply-To:</td><td>"+ myconv(msg->headers["reply-to"]) 
      + "</td></tr>";
  if(msg->headers->to)
    ret += "<tr><td>To:</td><td>" + myconv(msg->headers->to) + "</td></tr>";
  if(msg->headers->cc)
    ret += "<tr><td>Cc:</td><td>"+ myconv(msg->headers->cc) + "</td></tr>";
  if(msg->headers->subject)
    ret += "<tr><td>Subject:</td><td>" + myconv(msg->headers->subject) + "</td></tr>";
  ret+="</table><br><br>";

  ret += showtext(id,msg,0,0);

  ret += "<br><a href=\"/(reply,nq)"+
    id->not_query + "?" +
    id->query + "\">Reply without quoting anything</a><br>\n";
  

  return myret(id,ret,"Mail from: " + myconv(msg->headers->from), 1, 1, 1);
}

object getatrec(object msg, int lev, int no, int clev, int cno){
  clev++;
  if(clev==lev && cno==no)
    return msg;
  int i=1;
  object t;
  if(!msg->body_parts)
    return 0;
  foreach(msg->body_parts,t){
    if(getatrec(t,lev,no,clev,i))
      return getatrec(t,lev,no,clev,i);
    i++;
  }
      
  
}

mapping(string:mixed) getattach(object id, string f){
  int no,lev;
  object msg;
  msg = getmsg(id,f,replace(id->variables->id," ","+"));
  mixed tmp = id->variables->part / " ";
  no=(int) tmp[1];
  lev=(int) tmp[0];
  msg = getatrec(msg,lev,no,0,0);
  if(msg){
    return (["type":msg->type + "/" + msg->subtype  + "; name=" + 
	     msg->params->name,
	     "data":msg->getdata()
    ]);
  }else{
    return myret(id,"Requested attachment does not exist","Error",1,1,1,404);
  }
}

// Rutin fr att svara p mail
mixed reply(object id,string f){
  int no,lev;
  mapping(string:mixed) headers=([]);
  object msg,msgpart;
  if(!(msg = getmsg(id,f,replace(id->variables->id," ","+"))))
    throw(({"Mailbox disappeared?",backtrace()}));
  mixed tmp;
  if(!id->prestate->nq){
    tmp = id->variables->part / " ";
    no=(int) tmp[1];
    lev=(int) tmp[0];
  }

  // Dags att bygga upp meddelandet
  string ret = "";
  
  // Frst brevhuvudet.

  // Mottagare
  if(msg->headers["reply-to"])
    headers->to=myconv(msg->headers["reply-to"]);
  else if(msg->headers->from)
    headers->to=myconv(msg->headers->from);
  else
    headers->to="Unknown receipient";

  // Eventuella Cc
  headers->cc="";
  if(msg->headers->cc)
    headers->cc=myconv(msg->headers->cc);
  if(sizeof(msg->headers->to / ",")>1)
    headers->cc=myconv(msg->headers->to) + 
      (sizeof(headers->cc)?", ":"") + headers->cc; // BUG!

  // Subject
  if(msg->headers->subject)
    headers->subject="Re: " + (myconv(msg->headers->subject) - "Re: ");
  else
    headers->subject="(No subject)";

  // Se till att formatet p to och cc-raderna r korrekt
  // Eudora gillar adress@adress (Fullt namn..) gillar inte snedmail
  // skall allts gra motsvarande: $* ( $* )     $2 < $1 >
  headers->to=headrewr(headers->to);
  headers->cc=headrewr(headers->cc);

  

  ret += "<form method=post action=\"/(post)" + id->not_query + "\">";


  ret += "<table>";
  ret += "<tr><td>To:</td><td><input name=to type=text size=40 value=\"";
  ret += headers->to + "\"></td></tr>";
  ret += "<tr><td>Cc:</td><td><input name=cc type=text size=40 value=\"";
  ret += headers->cc + "\"></td></tr>";
  ret += "<tr><td>Subject:</td><td><input name=subject type=text ";
  ret += "size=40 value=\"" + headers->subject;
  ret += "\"></td></tr>";
  msgpart = getatrec(msg,lev,no,0,0);  
  // Hantera content-type
  if((!id->prestate->nq)&&(!(msg->type=="text" && msg->subtype=="plain"))){
    ret += "<tr><td>Content-Type:</td>";
    ret += "<td><select name=content>";
    ret += "<option>text/plain";
    ret += "<option selected>" + (msgpart->type?msgpart->type:msg->type) +
           "/" + (msgpart->subtype?msgpart->subtype:msg->subtype);
    ret += "</select></td></tr>";
  }else
    ret += "<input type=hidden name=content value=\"text/plain\">";

  ret+="</table><br><br>Message text:<br>";

  ret += "<textarea rows=24 cols=80 name=msgtext wrap=physical>";
  if(!id->prestate->nq)
    if(msgpart){
      ret += "On " + msg->headers->date + " " + msg->headers->from;
      ret += " wrote:\n";
      ret += "> " + replace(msgpart->getdata(),({"\n","</t","</T"}),
			    ({"\n> ","/t","/T"}));
    }else{
      ret += "No message text found";
    }
  
  // Find a signature
  object inf=Stdio.File();
  int err;

  array ui=id->conf->userinfo(id->auth[1]);
  string file=ui[5] + "/" + query("sig");

  suid_time += gauge {
      object privs = Privs("WebMail: opening signature file",
			   id->misc->uid,id->misc->gid);
      err=inf->open(file,"r");
      destruct(privs);
    };
  if(err)
    ret += "\n" + inf->read() + "\n";


  ret += "</textarea>";
  ret += "<br><input type=submit value=\"Send this mail\"></form>";

  return myret(id,ret,"Reply to mail from: " + msg->headers->from,1,1,1);

}

// Prata smtp med mail-servern. Baserad p Per Hedbors low_send_mail
// frn lsabrev.pike CVS-version 1.4

// Hr r vi i en separat trd, vi kan allts inte kasta ivg ngra 
// undantag etc. Bara skriva till loggen. Om adressen felaktig kan vi ju
// alltid frska att maila avsndaren om det. Om avsndaren r felaktig
// r det bara att klaga p administratren i loggen.

void smtp_speaker(object msg)
{
  string fqdn=(gethostbyname(gethostname()))[0];
  string from=msg->headers->from;
  string to=msg->headers->to;
  object re=Regexp(".*<(.+)>");
  if(re->match(from))
    from=(re->split(from))[0];
  if(re->match(to))
    to=(re->split(to))[0];

  // write("WM: " + from + " " + to + "\n");
  string ret;
  object smtp = Stdio.File();
  smtp->connect(smtpserv, 25);
  ret=smtp->read(199999,1);
  if(ret[0..2]!="220"){
    write("Seems like the other end isn't an SMTP-server. It said:\n" + ret +
	  "\n");
    return;
  }
  smtp->write("EHLO " + fqdn + "\r\n");
  ret=smtp->read(199999,1);
  if(ret[0..2]!="250"){
    write("Greeting failed.\nI said: EHLO " + fqdn + "\nIt said: " + ret + 
	  "\n");
    return;
  }
  smtp->write("MAIL FROM: <" + from + ">\r\n");
  ret=smtp->read(199999,1);
  if(ret[0..2]!="250"){
    write("MAIL FROM failed.\nI said: MAIL FROM: <" + from + ">\nIt said: " + 
	  ret + "\n");
    return;
  }
  smtp->write("RCPT TO: <" + to + ">\r\n");
  ret=smtp->read(199999,1);
  if(ret[0..2]!="250"){
    if(from!=to){
      object ermsg=MIME.Message("Failed to send your last mail to " + to + 
				".\nThe mailer said:\n" + ret + "\n",
				([ "MIME-Version":"1.0",
				   "From":"WebMail <postmaster@" + domain+">",
				   "Subject":"Error in sending mail",
				   "To":msg->headers->from
				]));
      smtp_speaker(ermsg);
    }else{
      write("RCPT TO failed.\nI said: RCPT TO: <" + to + ">\nIt said: " + 
	    ret + "\n");
    }
    return;
  }
  smtp->write("DATA\r\n");
  ret=smtp->read(199999,1);
  if(ret[0..2]!="354"){
    write("DATA failed.\nI said: DATA\nIt said: " + ret + "\n");
    return;
  }
  smtp->write(replace((string)msg, "\n.", "\n .")+"\r\n.\r\n");
  string r=smtp->read(199999,1);
#ifdef WM_DEBUG
  perror("WebMail: " + r);
#endif
  smtp->write("QUIT\r\n");
  smtp->read(199999,1);
  smtp=0;
}



// Rutin fr att posta ett meddelande
mixed post(object id){
  if(id->method!="POST")
    return myret(id,"You must use the post method.","Error",1,1,1,400);
  
  object msg;
  mapping headers = ([ ]);
  
  if(sizeof(id->misc->gecos / ",")>1)
    headers["From"]=(id->misc->gecos / ",")[0] + "<" + id->auth[1] 
      + "@"+domain+">";
  else
    headers["From"]=id->misc->gecos + " <" + id->auth[1] + "@"+domain+">";
  if(id->variables->to!="")
    headers["To"]=id->variables->to;
  else
    return myret(id,"You must supply a receipient!<br>(press \"Back\" in your "
		 "browser.)","Error",0,1,1);
  if(id->variables->cc!="")
    headers["Cc"]=id->variables->cc;
  if(id->variables->content)
    headers["Content-Type"]=id->variables->content;
  if(id->variables->subject)
    headers["Subject"]=id->variables->subject;
  headers["MIME-Version"]="1.0";
  headers["x-mailer"]=x_mailer;

  msg=MIME.Message(id->variables->msgtext,headers);
#if efun(thread_create)
  thread_create(smtp_speaker,msg);
#else // efun
  // Uh.. takes resources
  int pid;
  if(pid=fork()){
    // In parent
#ifdef WM_DEBUG
    perror("WebMail: forked process for delivery. pid: " + (string) pid +"\n");
#endif // WM_DEBUG
  }else{
    // In child
    smtp_speaker(msg);
#ifdef WM_DEBUG
    perror("WebMail: Delivery done from pid: " + getpid()+"\n");
#endif // WM_DEBUG
    exit(0);
  }
#endif // efun
  
  return myret(id,"Your message is sent. Hopefully it will reach the correct" +
	       " destination. You will probably be notified by mail if " +
	       "an error occurs.","Message sent",1,1,1);
  

}

mixed newmsg(object id){
  string ret = "";

  ret += "<form method=post action=\"/(post)" + id->not_query + "\">";


  ret += "<table>";
  ret += "<tr><td>To:</td><td><input name=to type=text size=40></td></tr>";
  ret += "<tr><td>Cc:</td><td><input name=cc type=text size=40></td></tr>";
  ret += "<tr><td>Subject:</td><td><input name=subject size=40 type=text>";
  ret += "</td></tr>";
  ret += "<input type=hidden name=content value=\"text/plain\">";
  ret += "</table><br><br>Message text:<br>";
  ret += "<textarea rows=24 cols=80 name=msgtext wrap=physical>";

  // Find a signature
  object inf=Stdio.File();
  int err;

  array ui=id->conf->userinfo(id->auth[1]);
  string file=ui[5] + "/" + query("sig");

  suid_time += gauge {
      object privs = Privs("WebMail: opening signature file",
			   id->misc->uid,id->misc->gid);
      err=inf->open(file,"r");
      destruct(privs);
    };
  if(err)
    ret += "\n" + inf->read() + "\n";

  ret += "</textarea>";
  ret += "<br><input type=submit value=\"Send this mail\"></form>";


  return myret(id,ret,"Compose a message",0,1,1);
}

array my_gd_recurse(string dir){
  array st=file_stat(dir,1);
  if(st && st[1]==-2){ // It is a dir.
    array dirl=get_dir(dir);
    string t;
    foreach(dirl,t){
      array dirl1=my_gd_recurse(dir + "/" + t);
      if(dirl1){
	dirl-=({ t });
	array a=({ });
	string b;
	foreach(dirl1,b)
	  a+=({ t + "/" + b });
	dirl += a;
      }
    }
    return dirl;
  }else{
    return 0;
  }
}

mixed mkfolderlist(object id){
  string loc = query("location");
  array pwdinf = id->conf->userinfo(id->auth[1]);
  array files;
  
  suid_time += gauge {
      object privs = Privs("WebMail: getting folder list.",
			   id->misc->uid,id->misc->gid);
      if(query("recurse")){
	files=my_gd_recurse(pwdinf[5]+"/"+home_mbox);
      }else{
	files = get_dir(pwdinf[5]+"/"+home_mbox);
      }
      destruct(privs);
    };

  if(files){
    if(query("dotf")){
      array t=({ });
      object re=Regexp("(^\\.)|(/\\.)");
      string t2;
      foreach(files,t2)
	if(re->match(t2))
	  t+=({ t2 });
      files-=t;
    }
    files=sort(files);
    files = ({ "INBOX" }) + files;
  }else
    files = ({ "INBOX" });
  
  int foo=0;
  string ret,tmp;
  ret = "<table border=0>";
  foreach(files,tmp){
    if(!(foo%4))
      ret += "<tr>";
    ret += "<td><a href=\"" + replace(simplify_path(loc+"/"+tmp)," ","%20") + "\">" + tmp + 
      "</a>";
    if(foo%4==3)
      ret += "\n";
    foo++;
  }
  ret += "</table>";

  return myret(id,ret,"Folder list",1,0,0);

}


mixed low_ff(object id, string f){
  string auth_ident = "WebMail mail-reader";
  string auth_fail  = "Authorization failed";

  mixed pwdinf,auth;

  // First check
  if(!id->auth)
    return http_auth_required(auth_ident,auth_fail);
  
  failed++;
  if(!(pwdinf = id->conf->userinfo(id->auth[1])))
    return http_auth_required(auth_ident,auth_fail);

  auth=id->realauth/":";
  
  if(!crypt(auth[1],pwdinf[1]))
    return http_auth_required(auth_ident,auth_fail);

  if(!((int)pwdinf[2])) // Root-check
    return http_auth_required(auth_ident,auth_fail);
  failed --;
  success++;

  f = simplify_path(f);

  if(f=="/" || f=="")
    return http_redirect(simplify_path(query("location") + "/INBOX"),id);

  // Sanitycheck on f
  f=(f / "/")[0]==""?f[2..]:f;
  f=f-".."; // Not actually needed ?
  

  users[pwdinf[0]]++;

  mixed err;
  //  err = catch
    {
      if(id->prestate->get)
	return getattach(id,f);
      if(id->prestate->read)
	return readmail(id,f);
      if(id->prestate->reply)
	return reply(id,f);
      if(id->prestate->post)
	return post(id);
      if(id->prestate->new)
	return newmsg(id);
      if(id->prestate->fl)
	return mkfolderlist(id);
      return mkmaillist(id,f);
    };
  return myret(id,"An error occured.<br>\n\"" + err[0] + "\"",
	       "Error",1,1,1,500);
  
}

  
    
