if (Array.length Sys.argv <> 3) then (Printf.printf "\
   Usage:  dump conninfo table
   Connect to Postgres with [conninfo] (e.g. \"host=glouglou\"),
   and copy [table] to stdout
"; exit 1);;


let main() =
  let c = new Postgres.connection Sys.argv.(1) in
  let _ = c#exec_expect ("copy "^(Sys.argv.(2))^" to stdout") 
	    [Postgres.Result.Copy_out] in
  c#copy_out_channel stdout;
  c#close

let _ = 
  try main ()
  with 
    | Postgres.Error e -> prerr_endline (Postgres.string_of_error e)
    | e -> prerr_endline (Printexc.to_string e)
