/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */
package mx4j.tools.remote.soap.web.axis;

import mx4j.tools.remote.soap.web.WebContainer;
import org.apache.axis.transport.http.SimpleAxisServer;

import java.net.ServerSocket;
import java.util.Map;

import javax.management.remote.JMXServiceURL;

/**
 * Implementation of the WebContainer interface backed by AXIS' SimpleAxisServer.
 * @author <a href="mailto:a_taherkordi@users.sourceforge.net">Alireza Taherkordi</a>
 * @version $Revision: 1.4 $
 */
public class SimpleAxisWebContainer implements WebContainer
{
   private final SimpleAxisServer server;

   public SimpleAxisWebContainer()
   {
      server = new SimpleAxisServer();
   }

   public void start(JMXServiceURL url, Map environment) throws Exception
   {
      server.setServerSocket(new ServerSocket(url.getPort()));
      server.setDoThreads(true);
      server.start(true);
   }

   public void stop() throws Exception
   {
      server.stop();
   }
}
