/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package test.mx4j.tools.connector;

import junit.framework.TestCase;
import mx4j.tools.connector.JMXAddress;
import mx4j.tools.connector.MalformedJMXAddressException;

/**
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.1 $
 */
public class JMXAddressTest extends TestCase
{
	public JMXAddressTest(String s)
	{
		super(s);
	}

	public void testInvalidJMXAddress() throws Exception
	{
		try	{new JMXAddress(null); fail("Service URL is wrong");}
		catch (MalformedJMXAddressException x) {}

		try	{new JMXAddress(""); fail("Service URL is wrong");}
		catch (MalformedJMXAddressException x) {}

		try	{new JMXAddress("jmx:"); fail("Service URL is wrong");}
		catch (MalformedJMXAddressException x) {}

		try	{new JMXAddress("jmx::"); fail("Service URL is wrong");}
		catch (MalformedJMXAddressException x) {}

		try	{new JMXAddress("jmx:proto"); fail("Service URL is wrong");}
		catch (MalformedJMXAddressException x) {}

		try	{new JMXAddress("jmx:proto:"); fail("Service URL is wrong");}
		catch (MalformedJMXAddressException x) {}

		try	{new JMXAddress("jmx:proto://"); fail("Service URL is wrong");}
		catch (MalformedJMXAddressException x) {}

		try	{new JMXAddress("jmx:proto://:"); fail("Service URL is wrong");}
		catch (MalformedJMXAddressException x) {}

		try	{new JMXAddress("jmx:proto:///"); fail("Service URL is wrong");}
		catch (MalformedJMXAddressException x) {}

		try	{new JMXAddress("jmx:proto://;"); fail("Service URL is wrong");}
		catch (MalformedJMXAddressException x) {}

		try	{new JMXAddress("jmx:proto://host:port"); fail("Service URL is wrong");}
		catch (MalformedJMXAddressException x) {}

		try	{new JMXAddress("jmx:proto://host/;port"); fail("Service URL is wrong");}
		catch (MalformedJMXAddressException x) {}
   }

   public void testValidJMXAddress() throws Exception
   {
		JMXAddress url = new JMXAddress("jmx:proto://host:1/path;key=value");
		if (!url.getProtocol().equals("proto")) {fail("Service URL is correct");}
		if (!url.getHost().equals("host")) {fail("Service URL is correct");}
		if (url.getPort() != 1) {fail("Service URL is correct");}
		if (!url.getPath().equals("path")) {fail("Service URL is correct");}
		if (!url.getProperty("key").equals("value")) {fail("Service URL is correct");}
		if (url.getProperties().size() != 1) {fail("Service URL is correct");}

		new JMXAddress("jmx:proto://host");
		new JMXAddress("jmx:proto://host/");
		new JMXAddress("jmx:proto://host;key=value");
		new JMXAddress("jmx:proto://host:1");
		new JMXAddress("jmx:proto://host:1/");
		new JMXAddress("jmx:proto://host:1;key=value");
		new JMXAddress("jmx:proto://host:1/;key=value");
	}
}
