/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package javax.management;

import java.io.Serializable;

/**
 * Base class for the MBean metadata classes.
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.5 $
 */
public class MBeanFeatureInfo implements Serializable, Cloneable
{
   private static final long serialVersionUID = 3952882688968447265L;

   /**
    * @serial The name of the feature
    */
   protected String name;
   /**
    * @serial The description of the feature
    */
   protected String description;

   /**
    * Creates a new MBean feature metadata object
    * @param name The name of the feature
    * @param description The description of the feature
    */
   public MBeanFeatureInfo(String name, String description)
   {
      this.name = name;
      this.description = description;
   }

   /**
    * Returns the name of the MBean feature
    */
   public String getName()
   {
      return name;
   }

   /**
    * Returns the description of the MBean feature
    */
   public String getDescription()
   {
      return description;
   }

   public int hashCode()
   {
      String name = getName();
      return name == null ? 0 : name.hashCode();
   }

   public boolean equals(Object obj)
   {
      if (obj == null) return false;
      if (obj == this) return true;

      try
      {
         MBeanFeatureInfo other = (MBeanFeatureInfo)obj;
         String name = getName();
         String otherName = other.getName();
         if (name != null && !name.equals(otherName)) return false;
         if (name == null && otherName != null) return false;
         return true;
      }
      catch (ClassCastException ignored)
      {
      }
      return false;
   }

   public Object clone()
   {
      try
      {
         return super.clone();
      }
      catch (CloneNotSupportedException ignored)
      {
         // Never thrown as this class is Cloneable
         return null;
      }
   }
}
