<?xml version="1.0" ?>
<!DOCTYPE xsl:stylesheet [
<!ENTITY copy "&#x00A9;">
]
>
<!--
   Copyright (c) 2000,2001 Dave Carrigan <dave@rudedog.org>
   All rights reserved.
  
   This module is free software; you can redistribute it and/or modify
   it under the same terms as Apache itself. This module is
   distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. The copyright holder of this
   module can not be held liable for any general, special, incidental
   or consequential damages arising out of the use of the module.

   $Id: auth_ldap.xsl,v 1.3 2001/07/04 14:39:33 dave Exp $
-->

<xsl:stylesheet 
  version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" />

  <xsl:strip-space elements="config"/>

  <xsl:template match="module">
    <html>
      <xsl:comment>
	Copyright (C) 2000,2001 Dave Carrigan &lt;dave@rudedog.org&gt;
	Automatically generated from the XML source and XSLT stylesheet
	using Xalan and Xerces.
      </xsl:comment>
      <head>
	<title><xsl:value-of select="@title" /></title>
      </head>
    </html>
    <body bgcolor="white">
      <center><h1><xsl:value-of select="@title" /></h1></center>
      <xsl:apply-templates select="intro"/>

      <h2>Contents</h2>
      <ul>
	<xsl:apply-templates select="section" mode="TOC" />
	<li><a href="#acknowledgemnts">Acknowledgements</a></li>
	<li><a href="#copyright">Copyright</a></li>
      </ul>

      <xsl:apply-templates select="section" />
      <xsl:apply-templates select="acks" />
      <xsl:apply-templates select="copyright" />
    </body>
  </xsl:template> 

  <xsl:template match="intro">
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="module/section">
    <a name="{@anchor}"><h2><xsl:value-of select="@title" /></h2></a>
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="section/section">
    <a name="{@anchor}"><h3><xsl:value-of select="@title" /></h3></a>
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="modulename">
    <i><xsl:apply-templates /></i>
  </xsl:template>

  <xsl:template match="emph">
    <em><b><xsl:apply-templates /></b></em>
  </xsl:template>

  <xsl:template match="directive">
    <tt><xsl:apply-templates /></tt>
  </xsl:template>

  <xsl:template match="directive-value">
    <i><xsl:apply-templates /></i>
  </xsl:template>

  <xsl:template match="filename ">
    <tt><xsl:apply-templates /></tt>
  </xsl:template>

  <xsl:template match="command ">
    <i><xsl:apply-templates /></i>
  </xsl:template>

  <xsl:template match="link">
    <a href="{@href}"><xsl:apply-templates /></a>
  </xsl:template>

  <xsl:template match="email">
    <a><xsl:attribute name="href">mailto:<xsl:value-of select="@addr" /></xsl:attribute><xsl:apply-templates /></a>
  </xsl:template>

  <xsl:template match="config">
    <pre>
<xsl:apply-templates /></pre>
  </xsl:template>

  <xsl:template match="vartext">
    <i><xsl:apply-templates /></i>
  </xsl:template>

  <xsl:template match="filter">
    <tt><xsl:apply-templates /></tt>
  </xsl:template>

  <xsl:template match="dn">
    <i><xsl:apply-templates /></i>
  </xsl:template>

  <xsl:template match="attribute">
    <tt><xsl:apply-templates /></tt>
  </xsl:template>

  <xsl:template match="attrval">
    <tt><i><xsl:apply-templates /></i></tt>
  </xsl:template>

  <xsl:template match="username">
    <i><xsl:apply-templates /></i>
  </xsl:template>

  <xsl:template match="p">
    <p>
      <xsl:apply-templates />
    </p>
  </xsl:template>

  <xsl:template match="table">
    <table border="0" bgcolor="{@bgcolor}">
      <xsl:apply-templates />
    </table>
  </xsl:template>

  <xsl:template match="list">
    <xsl:if test="@type='bullet'">
      <ul>
	<xsl:apply-templates />
      </ul>
    </xsl:if>
    <xsl:if test="@type='numbered'">
      <ol>
	<xsl:apply-templates />
      </ol>
    </xsl:if>
  </xsl:template>

  <xsl:template match="item">
    <li>
      <xsl:apply-templates />
    </li>
  </xsl:template>

  <xsl:template match="directive-doc">
    <a name="dir:{@name}"><h3><xsl:value-of select="@name" /></h3></a>
    <p>
      <a href="http://www.apache.org/docs/mod/directive-dict.html#Syntax" rel="Help"><strong>Syntax:</strong></a> <xsl:text> </xsl:text> <xsl:value-of select="@name" /> <xsl:apply-templates select="syntax" /><br></br>
      <a href="http://www.apache.org/docs/mod/directive-dict.html#Context" rel="Help"><strong>Context:</strong></a> <xsl:text> </xsl:text><xsl:value-of select="@context" /><br></br>
      <a href="http://www.apache.org/docs/mod/directive-dict.html#Override" rel="Help"><strong>Override:</strong></a> <xsl:text> </xsl:text> <xsl:value-of select="@override" /><br></br>
      <a href="http://www.apache.org/docs/mod/directive-dict.html#Status" rel="Help"><strong>Status:</strong></a> <xsl:text> </xsl:text> <xsl:value-of select="@status" /><br></br>
      <a href="http://www.apache.org/docs/mod/directive-dict.html#Module" rel="Help"><strong>Module:</strong></a> <xsl:text> </xsl:text> <xsl:value-of select="@module" />
    </p>
    <xsl:apply-templates select="p|table|list" />
    <hr></hr>
  </xsl:template>

  <xsl:template match="syntax">
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="syn-value">
    <em><xsl:apply-templates /></em>
  </xsl:template>

  <xsl:template match="syn-flag">
    <xsl:if test="@default='on'"> 
      &lt; <strong>on</strong>(default) | off &gt;
    </xsl:if>
    <xsl:if test="@default='off'">
      &lt; on | <strong>off</strong>(default) &gt;
    </xsl:if>
  </xsl:template>

  <xsl:template match="tr">
    <tr valign="{@valign}">
      <xsl:apply-templates />
    </tr>
  </xsl:template>

  <xsl:template match="th">
    <th colspan="{@colspan}" align="{@align}">
      <xsl:apply-templates />
    </th>
  </xsl:template>

  <xsl:template match="td">
    <td colspan="{@colspan}" align="{@align}">
      <xsl:apply-templates />
    </td>
  </xsl:template>

  <xsl:template match="filtcolor">
    <font color="{@color}"><xsl:apply-templates /></font>
  </xsl:template>

  <!-- Handle the acknowledgements -->
  <xsl:template match="acks">
    <a name="acknowledgements"><h2>Acknowledgements</h2></a>
    <p>
      Thanks go to
    </p>

    <ul>
      <xsl:apply-templates />
    </ul>
  </xsl:template>

  <xsl:template match="ack">
    <li>
      <a href="mailto:{@email}"><xsl:value-of select="@name"/></a>
      <xsl:apply-templates />
    </li>
  </xsl:template>

  <!-- Handle the copyright section -->

  <xsl:template match="copyright">
    <a name="copyright"><h2>Copyright</h2></a>
    <xsl:apply-templates select="holder" />
    All rights reserved.
    <xsl:apply-templates select="p" />
    <hr></hr>
    <xsl:apply-templates select="address" />
    <a><xsl:attribute name="href">mailto:<xsl:value-of select="@address" /></xsl:attribute>
    <i>&lt;<xsl:value-of select="@address" />&gt;</i></a>
  </xsl:template>

  <xsl:template match="holder">
    Copyright &copy; <xsl:value-of select="@years" />,
    <xsl:apply-templates /> <br></br>
  </xsl:template>

  <xsl:template match="section" mode="TOC">
    <li>
      <a><xsl:attribute name="href">#<xsl:value-of select="@anchor" /></xsl:attribute>
      <xsl:value-of select="@title" /></a>
      <ul>
	<xsl:apply-templates select="section|directive-doc" mode="TOC">
	  <xsl:sort select="@name" />
	</xsl:apply-templates>
      </ul>
    </li>
  </xsl:template>

  <xsl:template match="directive-doc" mode="TOC">
    <li>
      <a><xsl:attribute name="href">#dir:<xsl:value-of select="@name" /></xsl:attribute><xsl:value-of select="@name" /></a>
    </li>
  </xsl:template>

</xsl:stylesheet>  
