/*
 *  error.c  --  routines for handling errors and displaying error
 *		 messages in the client.
 *
 *
 *  Copyright (C) 1990	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	Bellman@Lysator.LiU.SE
 *
 *
 *  Any opinions expressed in this code are the author's PERSONAL opinions,
 *  and does NOT, repeat NOT, represent any official standpoint of Lysator,
 *  even if so stated.
 */

#include <config.h>
#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <stdarg.h>
#include <sys/types.h>

#include <libintl.h>

#include <kom-types.h>
#include <kom-errno.h>

#include "xoutput.h"
#include "internal.h"	/* Sigh. */

#include "error.h"

#define	Export


#define errprint(msg)	write (2, msg, strlen (msg))

Kom_err	kom_errno = KOM_NO_ERROR;


/*
 *  Inform the user about some error he or she did.
 *  BUG: This function is probably under-used...
 */
extern  void
inform_user (Type_of_error	  condition,
	     Conf_z_info_list	* confs)

{
#define FUNCTION "inform_user()"

    switch (condition)
    {
    case  ambigous_or_no_conf:
	if (confs == NULL  ||  confs->no_of_confs == 0)
	    xprintf (gettext("Det finns inget mte med det namnet.\n"));
	else
	{
	    int i;

	    xprintf(gettext("Mtesnamnet var tvetydigt. "
			    "Du kan mena ngot av dessa:\n"));
	    for (i = 0; i < confs->no_of_confs; i++)
	    {
		print_conf_name (confs->confs[i].conf_no);
		newline();
	    }
	}
	break;

    default:
	fatal1 (CLIENT_SHOULDNT_HAPPEN, "Bad type of user mistake");
	break;
    }
#undef FUNCTION
}



/*
 * kom_error_string
 * Returns a const char pointer to a message describing the error ERROR_NO.
 * The messages are not for the end user but only shown in the error message
 * before core dump.
 */
Export  const char *
kom_error_string(Kom_err  error_no)
{
    switch (error_no)
    {
    case KOM_NO_ERROR:	return "KOM_NO_ERROR";
    case KOM_NOT_IMPL:	return "KOM_NOT_IMPL";
    case KOM_OBSOLETE:	return "KOM_OBSOLETE";
    case KOM_PWD:	return "KOM_PWD";
    case KOM_LONG_STR:	return "KOM_LONG_STR";
    case KOM_LOGIN:	return "KOM_LOGIN";
    case KOM_LOGIN_DISALLOWED:	return "KOM_LOGIN_DISALLOWED";
    case KOM_CONF_ZERO:	return "KOM_CONF_ZERO";
    case KOM_UNDEF_CONF:	return "KOM_UNDEF_CONF";
    case KOM_UNDEF_PERS:	return "KOM_UNDEF_PERS";
    case KOM_ACCESS:	return "KOM_ACCESS";
    case KOM_PERM:	return "KOM_PERM";
    case KOM_NOT_MEMBER:	return "KOM_NOT_MEMBER";
    case KOM_NO_SUCH_TEXT:	return "KOM_NO_SUCH_TEXT";
    case KOM_NO_SUCH_LOCAL_TEXT:	return "KOM_NO_SUCH_LOCAL_TEXT";
    case KOM_BAD_NAME:	return "KOM_BAD_NAME";
    case KOM_CONF_EXISTS:	return "KOM_CONF_EXISTS";
    case KOM_PERS_EXISTS:	return "KOM_PERS_EXISTS";
    case KOM_SECRET_PUBLIC:	return "KOM_SECRET_PUBLIC";
    case KOM_LETTER_BOX:	return "KOM_LETTER_BOX";
    case KOM_LDB_ERR:	return "KOM_LDB_ERR";
    case KOM_ILL_MISC:	return "KOM_ILL_MISC";
    case KOM_ILLEGAL_INFO_TYPE:	return "KOM_ILLEGAL_INFO_TYPE";
    case KOM_ALREADY_RECIPIENT:	return "KOM_ALREADY_RECIPIENT";
    case KOM_NOT_RECIPIENT:	return "KOM_NOT_RECIPIENT";
    case KOM_RECIPIENT_LIMIT:	return "KOM_RECIPIENT_LIMIT";
    case KOM_COMM_LIMIT:	return "KOM_COMM_LIMIT";
    case KOM_FOOT_LIMIT:	return "KOM_FOOT_LIMIT";
    case KOM_NOT_AUTHOR:	return "KOM_NOT_AUTHOR";
    case KOM_NO_CONNECT:	return "KOM_NO_CONNECT";
    case KOM_OUT_OF_MEMORY:	return "KOM_OUT_OF_MEMORY";
    case KOM_SERVER_IS_CRAZY:	return "KOM_SERVER_IS_CRAZY";
    case KOM_CLIENT_IS_CRAZY:	return "KOM_CLIENT_IS_CRAZY";
    case KOM_UNDEF_SESSION:	return "KOM_UNDEF_SESSION";
    case KOM_REGEX_ERROR:	return "KOM_REGEX_ERROR";
    case KOM_NOT_MARKED:	return "KOM_NOT_MARKED";
    case KOM_TEMPFAIL:	return "KOM_TEMPFAIL";

    default:
        {
	    static char error_text[20];

	    sprintf(error_text, "Error %d - Unknown", error_no);
	    return error_text;
	}
    }
}


Export  void
fatal_client_error (Fatal_client_error	  error,
		    const char		* function_name,
		    const char		* filename,
		    const int		  lineno,
		    const char		* descrfmt, ...)

{
#define FUNCTION "fatal_client_error"
    va_list	  argp;


    errprint (gettext("Du har rkat ut fr en fatal bugg.\n"));

    switch (error)
    {
    case  CLIENT_OUT_OF_MEMORY:
	errprint (gettext("Minnet har tagit slut."));
	break;

    case  CLIENT_SERVER_ERROR:
	if (kom_errno == KOM_NO_CONNECT) {
	    fprintf (stderr, "%s.\n",
		     gettext("Servern svarar inte."));
	    fprintf (stderr, "kom_errno = %d %s\n",
		     kom_errno, kom_errno_string());
	    break;
	}
	fprintf (stderr, "%s: %s\n",
		 gettext("desdigert fel."),
		 gettext("Ovntat felmeddelande frn servern."));
	fprintf (stderr, "kom_errno = %d %s\n", kom_errno, kom_errno_string());
	break;

    case  CLIENT_CONNECTION_LOST:
	fprintf (stderr, "%s: %s\n",
		 gettext("desdigert fel."),
		 gettext("Vi har tappat frbindelsen till servern."));
	fprintf (stderr, "kom_errno = %d %s\n", kom_errno, kom_errno_string());
	break;

    case  CLIENT_UNEXPECTED_SERVER_ERROR:
	fprintf (stderr, "%s: %s\n",
		 gettext("desdigert fel."),
		 gettext("Ovntat felmeddelande frn servern."));
	fprintf (stderr, "kom_errno = %d %s\n", kom_errno, kom_errno_string());
	break;

    case  CLIENT_SITUATION_NOT_HANDLED:
	errprint (gettext("Denna situation tas nnu inte om hand av klienten.\n"));
	fprintf (stderr, "kom_errno = %d %s\n", kom_errno, kom_errno_string());
	break;

    case  CLIENT_SHOULDNT_HAPPEN:
	fprintf (stderr, "%s %s: %d\n",
		 gettext("Internt fel uppstod i funktionen."),
		 function_name,
		 lineno);
	break;

    case  CLIENT_ERROR_TOO_boring:
	fprintf (stderr, "\a\a\aAaarrrggghhh!!! This error isn't handled!\n");
	fprintf (stderr, "kom_errno = %d %s\n", kom_errno, kom_errno_string());
	break;

    default:
	fatal1 (CLIENT_SHOULDNT_HAPPEN, "fatal");
	break;
    }

    errprint (gettext("Hr fljer debug-information:\n"));
    errprint ("Client version: " VERSION "\n");
    errprint ("Current function: ");
    errprint (function_name);
    errprint ("\tFile: ");
    errprint (filename);
    {
	char  buf[12];
	
	sprintf(buf, ":%d", lineno);
	errprint (buf);
    }
    errprint ("\n");
    va_start (argp, descrfmt);
    vfprintf (stderr, descrfmt, argp);
    va_end (argp);
    errprint ("\n");
    abort();
#undef FUNCTION
}



/*
 *  Print a message telling the user that a bug in the LysKOM
 *  server has been detected, the symtoms of the bug (BUG_TEXT),
 *  in what function in the client the bug was detected
 *  (FUNCTION) and some more information that might be used for
 *  post-mortem debugging.
 */
Export  void
server_bug (const char	* bug_text,
	    const char	* function,
	    bug_info	  extra_info)

{
    xprintf ("Oops! I have detected a bug in the LysKOM server.\n"
	     "Symtoms: %s\n"
	     "Function where the bug was detected: %s\n"
	     "Extra debug-info: %ul\n",
	     bug_text, function, (unsigned long) extra_info);
    xprintf ("\nI will dump core now. Please save the core file, and\n"
	     "tell someone who is responsible for this LysKOM\n"
	     "installation about what happened, so that the bug\n"
	     "can be fixed.  Thanks.\n");
    xprintf ("\nThe person you should contact is linus@lysator.liu.se\n");

    abort();
}
