/*
 *  functions-edit.c
 *		Functions for the commands that edit a text being written.
 *
 *
 *  Copyright (C) 1990	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	Bellman@Lysator.LiU.SE
 *
 *
 *  Any opinions expressed in this code are the author's PERSONAL opinions,
 *  and does NOT, repeat NOT, represent any official standpoint of Lysator,
 *  even if so stated.
 */

#include <config.h>
#include <stdio.h>
/* #include <time.h> included from kom-types.h */
#if STDC_HEADERS || HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#ifdef __vax__
#define __SIZE_T included from string.h
#endif
#include <kom-types.h>	/* Before zmalloc.h */
#include <zmalloc.h>
#include <s-string.h>
#include <s-collat.h>

#include <libintl.h>

#include <kom-errno.h>
#include <services.h>

/* Must be included before "read-line.h" on a vax because it includes <sgtty.h>
 * and that does not work after inclusion of <sys/ioctl.h> because of
 * stupid include-file construction.
 */
#include "xoutput.h"

#include "read-line.h"
#include "commands.h"
#include "parser.h"
#include "edit.h"
#include "error.h"
#include "cache.h"
#include "quit.h"

#include "internal.h"
#include "cmds.h"
#include "conf.h"


/* This is to emphasize that a function is exported. */
#define Export



#define CHECK_ACTIVE_TEXT() if (active_text < 0) { \
   xprintf(gettext("Du hller inte p att skriva ngot inlgg\n")); RETURN(FAILURE); }

/*
 *  Remove the word before the insertion point.
 */
Export  Success
cmd_remove_last_word (String	  argument)

{
    String_size		  i, pos;
    int			  no_of_words;
    String_size		  error_check;
    String		* text;
    String		  word_separators	= s_fcrea_str ("\t\n ,.!?;:-");

#define CLEAN_UP()	do { s_clear (&argument); } while (0)

    TOPLOOP_SETJMP();

    if (s_empty (argument))
	no_of_words = 1;
    else
    {
	no_of_words = s_strtol (argument, &error_check,
				DEFAULT_NUMBER_BASE);
	if (error_check < s_strlen (argument))
	{
	    /*  No, it wasn't a number.  */
	    xprintf (gettext("Oknt argument:  "));
	    s_puts (argument);
	    newline();
	    RETURN (FAILURE);
	}
	xprintf ("%d", no_of_words);
    }
    newline();


    /*  Find the beginning of the word.  Do this by searching backwards
     *  from the insertion point for any of the characters in the word
     *  separator string.						*/
    CHECK_ACTIVE_TEXT();
    i = pos = edit_insertion_point (active_text) - 1;
    text = edit_text (active_text);

    while (i > 0 && no_of_words > 0)
    {
	/* Skip past word separators */
	while (i >= 0  &&  s_strchr (word_separators, text->string[i], 0) >= 0)
	    i--;
	/* Skip to next word separator */
	while (i >= 0  &&  s_strchr (word_separators, text->string[i], 0) < 0)
	    i--;
	no_of_words--;
    }

    edit_del_string (active_text, i - pos);	/* BUG! Check retval. */

    RETURN (OK);
#undef CLEAN_UP
}



Export  Success
cmd_remove_last_line (String	argument)

{
    int			  no_of_lines;
    String_size		  i, pos;
    String_size		  error_check;
    String		* text;

#define CLEAN_UP()	do { s_clear (&argument); } while (0)

    TOPLOOP_SETJMP();

    if (s_empty (argument))
	no_of_lines = 1;
    else
    {
	no_of_lines = s_strtol (argument, &error_check,
				DEFAULT_NUMBER_BASE);
	if (error_check < s_strlen (argument))
	{
	    /*  No, it wasn't a number.  */
	    xprintf (gettext("Oknt argument:  "));
	    s_puts (argument);
	    newline();
	    RETURN (FAILURE);
	}
	xprintf ("%d", no_of_lines);
    }
    newline();

    /* Find where the NO_OF_LINES:th newline backward from point is */
    CHECK_ACTIVE_TEXT();
    i = pos = edit_insertion_point (active_text) - 1;
    text = edit_text (active_text);
    /* If we're standing at the end of a line, step past that */
    if (text->string[pos] == '\n')
	i--;
    while (i >= 0  &&  no_of_lines > 0)
    {
	if (text->string[i] == '\n')
	    no_of_lines--;
	i--;
    }
    /*  Since the loop goes past the newline, we position 'i' on the
     *  newline here.							*/
    i++;	

    edit_del_string (active_text, i - pos);	/* BUG! Check retval. */

    RETURN (OK);
#undef CLEAN_UP
}



Export  Success
cmd_previous_line (String	  argument)

{
    int			  no_of_lines;
    String_size		  i, pos;
    String_size		  error_check;
    String		* text;

#define CLEAN_UP()	do { s_clear (&argument); } while (0)

    TOPLOOP_SETJMP();

    if (s_empty (argument))
	no_of_lines = 1;
    else
    {
	no_of_lines = s_strtol (argument, &error_check,
				DEFAULT_NUMBER_BASE);
	if (error_check < s_strlen (argument))
	{
	    /*  No, it wasn't a number.  */
	    xprintf (gettext("Oknt argument:  "));
	    s_puts (argument);
	    newline();
	    RETURN (FAILURE);
	}
	xprintf ("%d", no_of_lines);
    }
    newline();

    /* Find where the NO_OF_LINES:th newline backward from point is */
    CHECK_ACTIVE_TEXT();
    i = pos = edit_insertion_point (active_text) - 1;
    text = edit_text (active_text);
    /* If we're standing at the end of a line, step past that */
    if (text->string[pos] == '\n')
	i--;
    while (i >= 0  &&  no_of_lines > 0)
    {
	if (text->string[i] == '\n')
	    no_of_lines--;
	i--;
    }
    /*  Since the loop goes past the newline, we position 'i' on the
     *  newline here.							*/
    i++;	

    edit_set_insertion_point (active_text, i);

    RETURN (OK);
#undef	CLEAN_UP
}



Export  Success
cmd_next_line (String	argument)
{
    int			  no_of_lines;
    String_size		  pos;
    String_size		  error_check;
    String		  text;

#define CLEAN_UP()	do { s_clear (&argument); } while (0)

    TOPLOOP_SETJMP();

    if (s_empty (argument))
	no_of_lines = 1;
    else
    {
	no_of_lines = s_strtol (argument, &error_check,
				DEFAULT_NUMBER_BASE);
	if (error_check < s_strlen (argument))
	{
	    /*  No, it wasn't a number.  */
	    xprintf (gettext("Oknt argument:  "));
	    s_puts (argument);
	    newline();
	    RETURN (FAILURE);
	}
	xprintf ("%d", no_of_lines);
    }
    newline();

    /* Find where the NO_OF_LINES:th newline forward from point is */
    CHECK_ACTIVE_TEXT();
    pos = edit_insertion_point (active_text);
    text = *edit_text (active_text);
    while (pos < s_strlen (text)  &&  no_of_lines > 0)
    {
	if (text.string[pos] == '\n')
	    no_of_lines--;
	pos++;
    }

    edit_set_insertion_point (active_text, pos);

    RETURN (OK);
#undef	CLEAN_UP
}


Export  Success
cmd_new_subject (String	argument)
{
#define FUNCTION "cmd_new_subject()"
    String_size		  pos;
    String		  text;
    String_size		  end_of_subject;

#define CLEAN_UP()	do { s_clear (&argument); } while (0)

    TOPLOOP_SETJMP();

    CHECK_ACTIVE_TEXT();

    if (s_empty (argument))
    {
	xprintf(gettext("Vilket rende vill du stta?\nrende: "));
	read_line(&argument);
	newline();
	argument = s_strip_trailing(argument, command_separators);
	if (s_empty(argument))
	{
	    xprintf(gettext("Nehej.\n"));
	    RETURN (OK);
	}
    }

    s_strcat(&argument, s_fcrea_str("\n"));

    /* The edit position will be changed to follow the point where it was. */
    pos = edit_insertion_point(active_text);
    text = *edit_text (active_text);

    for (end_of_subject = 0; end_of_subject < s_strlen(text); end_of_subject++)
    {
	if (text.string[end_of_subject] == '\n')
	{
	    end_of_subject++;
	    break;
	}
    }

    /* Now end_of_subject is the end of the first line in the text, 
       i.e. the end of the subject.
       Lets remove that one and insert the new subject in argument.
       */
    edit_set_insertion_point(active_text, 0);
    edit_del_string(active_text, end_of_subject);
    edit_add_string(active_text, argument);

    if (pos <= end_of_subject)
    {
	/* The insertion point is already at the line after the subject. */
    }
    else
    {
	edit_set_insertion_point(active_text, 
				 pos + s_strlen(argument) - end_of_subject);
    }

    RETURN (OK);
#undef CLEAN_UP
#undef FUNCTION
}



Export  Success
cmd_look_at_text (String	  argument)

{
#define CLEAN_UP()	do { s_clear (&argument); } while (0)

    TOPLOOP_SETJMP();

    CHECK_NO_ARGUMENTS();

    newline();

    if (active_text >= 0)
    {
        /*xgettext:c-format*/
	xprintf (gettext("rende: %S"), *edit_text (active_text));
    }
    else
    {
	cmd_not_yet_implemented (EMPTY_STRING);
	RETURN (FAILURE);
    }

    RETURN (OK);
#undef CLEAN_UP
}
