/*
 * $Id: send.c,v 1.2 1994/11/05 16:12:32 linus Exp $
 * Copyright (C) 1991  Lysator Academic Computer Association.
 *
 * This file is part of the LysKOM server.
 * 
 * LysKOM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 1, or (at your option) 
 * any later version.
 * 
 * LysKOM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LysKOM; see the file COPYING.  If not, write to
 * Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
 * or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 * MA 02139, USA.
 *
 * Please mail bug reports to bug-lyskom@lysator.liu.se. 
 */
/*
 * send.c  -  write objects throug an isc connection.
 *
 * Written by ceder 1990-07-13
 */

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include <sys/types.h>
#include <sys/file.h>
#include <unistd.h>

#include <kom-types.h>

#include "send.h"

extern void
output_string(FILE *fp,
	      String str)
{
    fprintf(fp, " %luH", (unsigned long)str.len);
    fflush(fp);
    write(fileno(fp), str.string, str.len);
}


extern void
output_priv_bits(FILE *fp,
		 Priv_bits bits)
{
    putc(' ', fp);
    putc(bits.wheel + '0', fp);
    putc(bits.admin + '0', fp);
    putc(bits.statistic + '0', fp);
    putc(bits.create_pers + '0', fp);
    putc(bits.create_conf + '0', fp);
    putc(bits.change_name + '0', fp);
    putc(bits.extern_gw + '0', fp);
    putc(bits.flg8 + '0', fp);
    putc(bits.flg9 + '0', fp);
    putc(bits.flg10 + '0', fp);
    putc(bits.flg11 + '0', fp);
    putc(bits.flg12 + '0', fp);
    putc(bits.flg13 + '0', fp);
    putc(bits.flg14 + '0', fp);
    putc(bits.flg15 + '0', fp);
    putc(bits.flg16 + '0', fp);
}


extern void
output_personal_flags(FILE *fp,
		      Personal_flags flags)
{
    putc(' ', fp);
    putc(flags.unread_is_secret + '0', fp);
    putc(flags.flg2 + '0', fp);
    putc(flags.flg3 + '0', fp);
    putc(flags.flg4 + '0', fp);
    putc(flags.flg5 + '0', fp);
    putc(flags.flg6 + '0', fp);
    putc(flags.flg7 + '0', fp);
    putc(flags.flg8 + '0', fp);
}	

extern void
output_conf_type(FILE *fp,
		 Conf_type type)
{
    putc(' ', fp);
    putc(type.rd_prot + '0', fp);
    putc(type.original + '0', fp);
    putc(type.secret + '0', fp);
    putc(type.letter_box + '0', fp);
}



extern void
output_misc_info(FILE *fp, 
		 Misc_info misc)
{
    fprintf(fp, " %lu", (unsigned long)misc.type);
    
    switch(misc.type)
    {
    case recpt:
	fprintf(fp, " %lu", (unsigned long)misc.datum.recipient);
	break;
	
    case cc_recpt:
	fprintf(fp, " %lu", (unsigned long)misc.datum.cc_recipient);
	break;
	
    case loc_no:
	fprintf(fp, " %lu", (unsigned long)misc.datum.local_no);
	break;
	
    case rec_time:
	fprintf(stderr, "Internal error in LysKOM-klient: output_misc_info(): can't send a rec_time.\n");
	abort();
	break;
	
    case comm_to:
	fprintf(fp, " %lu", (unsigned long)misc.datum.comment_to);
	break;
	
    case comm_in:
	fprintf(fp, " %lu", (unsigned long)misc.datum.commented_in);
	break;
	
    case footn_to:
	fprintf(fp, " %lu", (unsigned long)misc.datum.footnote_to);
	break;
	
    case footn_in:
	fprintf(fp, " %lu", (unsigned long)misc.datum.footnoted_in);
	break;
	
    case sent_by:
	fprintf(fp, " %lu", (unsigned long)misc.datum.sender);
	break;
	
    case sent_at:
	fprintf(stderr, "Internal error in LysKOM-klient: output_misc_info(): can't send a sent_at.\n");
	abort();
	break;

    default:
	fprintf(stderr, "output_misc_info: Illegal misc\n");
	fflush(stdout);
	fflush(stderr);
	abort();
    }
}

