import gtk
import gobject
import os


import Alert
import BaseFolderTree
import Filesel
import MetaData
import MetaDataDialog
import ExportWeb
import lodjusetup


class WebExportDialog(Filesel.Filesel):

    def __init__(self, prev_location, prev_template, ok_hook):
    	Filesel.Filesel.__init__(self, u"Export to web gallery", 
	    	    	    	 prev_location, gtk.TRUE,
	    	    	    	 gtk.FALSE, ok_hook, show_p=0)

    	hbox = gtk.HBox()
	
    	label = gtk.Label(u"Template:")
	label.show()
	hbox.pack_start(label, gtk.FALSE, gtk.FALSE)
	
    	template_dirs = self.find_template_dirs()

	combo = gtk.Combo()
	combo.set_value_in_list(gtk.TRUE, gtk.FALSE)
	combo.set_popdown_strings(template_dirs)
	if prev_template in template_dirs:
	    combo.entry.set_text(prev_template)
	combo.show()
	hbox.pack_start(combo, gtk.TRUE, gtk.TRUE)
	self.combo = combo
	
	hbox.set_homogeneous(gtk.FALSE)
	hbox.show()
	self.filesel.action_area.pack_start(hbox)

    	self.filesel.show()

    def find_template_dirs(self):
	peruser = os.path.expanduser(u"~/.lodju/templates")
	system = lodjusetup.LODJU_TEMPLATES
	roots = filter(os.path.isdir, [peruser, system])
	dirs = []
	for root in roots:
	    for basename in os.listdir(root):
	    	fullname = os.path.join(root, basename)
		if self.is_template_dir(fullname):
		    dirs.append(fullname)
	return dirs

    def is_template_dir(self, dirname):
    	if not os.path.isdir(dirname):
	    return 0
	files = os.listdir(dirname)
	for file in files:
	    if file[-len(u".template"):] == u".template":
	    	return 1
    	return 0

    def ok(self, *args):
    	filenames = self.filesel.get_selections()
	template = self.combo.entry.get_text()
	self.filesel.destroy()
	self.ok_hook(filenames, template)


class Model(BaseFolderTree.Model):

    def __init__(self, doc, trash):
    	BaseFolderTree.Model.__init__(self, doc)
	self.trash = trash

    def move_to_trash(self, iter):
    	assert self.store != self.trash
	self.trash.folder_tree.model.copy_folder(self.store, iter)
    	self.store.remove(iter)
	self.doc.make_dirty()

    def new_folder(self, selected_iter):
    	return self.paste_folder(selected_iter, MetaData.Folder())

    def rename_folder(self, iter, new_name):
	folder = self.store.get_value(iter, self.OBJECT_COLUMN)
	folder[u"name"] = new_name


class View(BaseFolderTree.View):

    def __init__(self, window, doc, trash, xml):
    	model = Model(doc, trash)
    	BaseFolderTree.View.__init__(self, window, model,
				     Controller(model, self),
				     xml)
	self.dialog = MetaDataDialog.View(xml, "Folder properties")
	

class Controller(BaseFolderTree.Controller):

    def __init__(self, model, view):
    	BaseFolderTree.Controller.__init__(self, model, view)
	self.filesel_location = u""
	self.template = u""

    def on_new_folder_activate(self, *args):
    	selected_iters = self.get_selection_iters()
	if selected_iters:
	    iter = selected_iters[0]
	else:
	    iter = None
	iter = self.model.new_folder(iter)
	path = self.model.store.get_path(iter)
	self.view.widget.set_cursor(path, self.view.column, gtk.TRUE)

    def folder_name_edited(self, *args):
	self.model.rename_folder(self.model.store.get_iter(args[1]), 
	    	    	    	 unicode(args[2]))

    def on_delete_folder_activate(self, *args):
    	for iter in self.get_selection_iters():
	    self.model.move_to_trash(iter)

    def on_folder_properties_activate(self, *args):
	iters = self.get_selection_iters()
	assert len(iters) == 1
	folder = self.model.get_folder(iters[0])
	self.view.dialog.show(self.model.doc.folderattrs, folder)

    def export_folder_really_ok(self, dirname, template):
	self.filesel_location = dirname
	self.template = template
    	try:
	    if os.path.isdir(dirname):
		for basename in os.listdir(dirname):
		    os.remove(os.path.join(dirname, basename))
	    iters = self.get_selection_iters()
	    folders = map(lambda i: self.model.get_folder(i), iters)
	    ExportWeb.ExportWeb(self.view.window, dirname, self.model.doc, 
	    	    	    	folders, template)
    	except IOError, (code, txt):
	    Alert.Alert(gtk.STOCK_DIALOG_ERROR,
	    	    	[(gtk.STOCK_OK,)],
			u"Something went wrong.",
			u"Error %d: %s" % (code, txt))
    	except OSError, (code, txt):
	    Alert.Alert(gtk.STOCK_DIALOG_ERROR,
	    	    	[(gtk.STOCK_OK,)],
			u"Something went wrong.",
			u"Error %d: %s" % (code, txt))

    def export_folder_ok(self, filenames, template):
    	assert len(filenames) == 1
	dirname = filenames[0]
	if os.path.isdir(dirname):
	    if os.listdir(dirname) == []:
	    	self.export_folder_really_ok(dirname, template)
	    else:
		Alert.Alert(gtk.STOCK_DIALOG_WARNING,
			    [(gtk.STOCK_CANCEL,),
			     (gtk.STOCK_OK, 
			      lambda: self.export_folder_really_ok(dirname, 
			      	    	    	    	    	   template))],
			    u"Remove files in %s?" % dirname,
			    u"The directory you chose exists and contains " +
			    u"files. Should they be deleted?")
    	elif os.path.exists(dirname):
	    Alert.Alert(gtk.STOCK_DIALOG_ERROR,
			[(gtk.STOCK_OK,)],
			u"%s is not a directory." % dirname,
			u"You selected something that exists, but is not " +
			u"a directory. Please select something else.")
    	else:
    	    self.export_folder_really_ok(dirname, template)

    def on_export_folder_activate(self, *args):
    	WebExportDialog(self.filesel_location, self.template,
	    	    	self.export_folder_ok)
