/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

/*
 * This needs to be completely rewritten to p2open() a helper script (process),
 * ala linuxtrade.qm (I think).
 *
 * That will get rid of the blocking in the UI when the symbols need to be
 * changed, and also get rid of a lot of the C code below.
 *
 * Its a real shame that the Yahoo streamer protocol is so awful. 
 * It requires a new HTTP connection to a control server every time
 * you want to change the symbols.  You cannot change the symbols
 * by simply sending commands thru the existing data connection.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <ncurses.h>
#include <panel.h>
#include <errno.h>
#include <string.h>
#include <time.h>
#include <pthread.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include "error.h"
#include "rc.h"
#include "streamer.h"
#include "linuxtrade.h"
#include "util.h"
#include "p2open.h"

#include "optchain.h"
#include "info.h"

static void do_ctrlquote(STREAMER sr, unsigned char *buf);

#define         SYMCNT          200
#define         SYMBUFLEN       (SYMCNT * (SYMLEN+1) + 1)

typedef struct streamerpriv
{
	FILE	*fp;
	FILE	*afp[2];

	time_t	last_flush;

	char	symbuf[SYMBUFLEN];
	int	symcnt;

	char	cookies[2048];

	char	ctrlhost[256];
	short	port;
	int	cfd;
	FILE	*cfp;

	char	*arg;

	int	delayed;
} STREAMERDATA;

typedef struct
{
	char	*canon, *sym;
} SYMMAP;

static SYMMAP SymMap[] =
{
	{	"$DJI",		"^DJI",		},
	{	"$DJT",		"^DJT",		},
	{	"$DJU",		"^DJU",		},

	{	"$NYA",		"^NYA",		},
	{	"$TRIN",	"^STI.N",	},
	{	"$TICK",	"^TIC.N",	},

	{	"$COMP",	"^IXIC",	},
	{	"$NDX",		"^NDX",		},
	{	"$SPX",		"^GSPC",	},
	{	"$OEX",		"^OEX",		},
	{	"$MID",		"^MID",		},
	{	"$SML",		"^SML",		},
	{	"$RLX",		"^RLX",		},

	{	"$XAL",		"^XAL",		},
	{	"$BTK",		"^BTK",		},
	{	"$XBD",		"^XBD",		},
	{	"$XAX",		"^XAX",		},
	{	"$XCI",		"^XCI",		},
	{	"$IIX",		"^IIX",		},
	{	"$NWX",		"^NWX",		},
	{	"$XOI",		"^XOI",		},
	{	"$DRG",		"^DRG",		},
	{	"$XTC",		"^XTC",		},

	{	"$GSO",		"^GSO",		},
	{	"$HWI",		"^HWI",		},
	{	"$RUI",		"^RUI",		},
	{	"$RUT",		"^RUT",		},
	{	"$RUA",		"^RUA",		},
	{	"$SOX",		"^SOXX",	},
	{	"$OSX",		"^OSX",		},

	{	"$BKX",		"^BKX",		},
	{	"$XAU",		"^XAU",		},
	{	"$GOX",		"^GOX",		},
	{	"$YLS",		"^YLS",		},
	{	"$DDX",		"^DDX",		},
	{	"$DOT",		"^DOT",		},

	{	"$TYX",		"^TYX",		},
	{	"$TRINQ",	"^STI.O",	},
	{	"$TICKQ",	"^TIC.O",	},
	{	"$TRINA",	"^STI.AQ",	},
	{	"$TICKA",	"^TIC.AQ",	},
	{	"$VIX",		"^VIX",		},
	{	"$VXN",		"^VXN",		},
	{	NULL,		NULL		}
};

//
// Convert canonical index names to/from streamer index names
//
static void
streamer_canon2sym(char *out, char *in)
{
	char	*ip, *op;
	char	*p;
	char	*cp;
	int	len;
	SYMMAP	*map;

	ip = in;
	op = out;
	for (;;)
	{
		p = strchr(ip, '|');
		if (!p) p = strchr(ip, ' ');
		if (!p) p = strchr(ip, 0);

		len = p - ip;
		memcpy(op, ip, len); op[len] = 0;

		// Convert market designator
		cp = strchr(op, ':');
		if (cp) *cp = ',';

		for (map = SymMap; map->canon; ++map)
			if (strcmp(op, map->canon) == 0)
			{
				strcpy(op, map->sym);
				break;
			}

		if (*p == 0)
			break;

		ip += len + 1;
		op = strchr(op, 0);
		*op++ = *p;
		*op = 0;
	}
}

void
yahoo_canon2sym(char *out, char *in)
{
    streamer_canon2sym(out, in);

    // Last shot at converting unknown canonical index symbol
    if (out[0] == '$')
	out[0] = '^';
}

static void
streamer_sym2canon(char *out, char *in)
{
	SYMMAP	*map;
	char	*cp;

	for (map = SymMap; map->sym; ++map)
		if (strcmp(in, map->sym) == 0)
		{
			strcpy(out, map->canon);
			return;
		}

	if (in != out)
		strcpy(out, in);
	cp = strchr(out, ',');
	if (cp) *cp = ':';
}

void
yahoo_sym2canon(char *out, char *in)
{
    streamer_sym2canon(out, in);

    // Last shot at converting unknown canonical index symbol
    if (out[0] == '^')
	out[0] = '$';
}

static void
streamer_init(STREAMER sr)
{
	sr->refresh = 0;
	sr->fd[0] = -1;
	sr->nfd = 1;
	strcpy(sr->id, "yahoo");

	time(&sr->priv->last_flush);

	sr->priv->fp = NULL;
	sr->priv->afp[0] = NULL;
	sr->priv->afp[1] = NULL;

	sr->priv->symcnt = 0;
	sr->priv->delayed = 1;
}

static int
streamer_puts(STREAMER sr, char *str)
{
	int	len = strlen(str);
	int	slen;
	char	*p;

	p = strchr(str, '\r');
	if (p)
		slen = p - str;
	else
		slen = len;

	if (StreamerLog)
		fprintf(StreamerLog, "> %.*s\n", (int) slen, (char *)str);

	if (Debug >= 5)
	{
		timestamp(stderr);
		fprintf(stderr, "> %.*s\n", (int) slen, (char *)str);
	}

	return write(sr->fd[0], str, len);
}

static int
streamer_fread(STREAMER sr, unsigned char *buf, int size)
{
	int	len;
	int	rc;

	rc = fread(buf, 1, 2, sr->priv->fp);
	if (rc != 2)
		return -1;
	sr->cnt_rx += rc;

	len = (buf[0] << 8) | buf[1];
	if (len <= 0)
		return 0;
	if (len > (size-2) )
	{
		if (Debug)
			fprintf(stderr, "streamer len=%d!!!\n", len);
		return -2;
	}

	rc = fread(&buf[2], 1, len, sr->priv->fp);
	if (rc != len)
		return -3;
	sr->cnt_rx += rc;

	if (sr->writefile)
		{}

	if (Debug >= 5)
	{
		timestamp(stderr);
		hexdump(stderr, "<", "            ", buf, len+2);
		//fwrite(buf, 1, len+2, stderr);
		//fprintf(stderr, "\n");
	}

	return (len);
}

static int
ctrl_open(STREAMER sr)
{
	int			rc;
	struct hostent		*hep;
	struct sockaddr_in	sockaddr;

	/*
	 *	Open control connection
	 */
	hep = mygethostbyname(sr->priv->ctrlhost);
	if (!hep)
		return (-1);

	memcpy(&sockaddr.sin_addr, hep->h_addr, hep->h_length);
	sockaddr.sin_family = AF_INET;
	sockaddr.sin_port = htons(sr->priv->port);

	sr->priv->cfd = socket(AF_INET, SOCK_STREAM, 0);
	if (sr->priv->cfd < 0)
		return -2;

	if (Debug >= 5)
		fprintf(stderr, "Ctrl Socket fd=%d...\n", sr->priv->cfd);

	if (Debug >= 5)
		fprintf(stderr, "Connect to '%s'...\n", sr->priv->ctrlhost);

	rc = connect_timeout(sr->priv->cfd,
			(SA *) &sockaddr, sizeof(sockaddr), 15);
	if (rc < 0)
	{
		if (Debug >= 5)
			syserror(0, "Couldn't connect to '%s'\n",
					sr->priv->ctrlhost);
		return (0);
	}

	sr->priv->cfp = fdopen(sr->priv->cfd, "r+");
	return (1);
}

static int
ctrl_puts(STREAMER sr, char *str)
{
	int	len = strlen(str);
	int	slen;
	char	*p;

	p = strchr(str, '\r');
	if (p)
		slen = p - str;
	else
		slen = len;

	if (StreamerLog)
		fprintf(StreamerLog, "c> %.*s\n", (int) slen, (char *)str);

	if (Debug >= 5)
	{
		timestamp(stderr);
		fprintf(stderr, "c> %.*s\n", (int) slen, (char *)str);
	}

	return write(sr->priv->cfd, str, len);
}

static int
ctrl_post(STREAMER sr, char *str)
{
	int	len = strlen(str) - 2;
	char	buf[BUFSIZ];

	ctrl_puts(sr, "POST / HTTP/1.0\r\n");
	ctrl_puts(sr, "Connection: Keep-Alive\r\n");
	ctrl_puts(sr, "User-Agent: "
			"Mozilla/4.0 (compatible; MSIE 5.5; Windows 98)\r\n");
	sprintf(buf, "Host: %s\r\n", sr->priv->ctrlhost);
	ctrl_puts(sr, buf);
	ctrl_puts(sr, "Accept: image/gif, image/jpeg, image/png, */*\r\n");
	ctrl_puts(sr, "Accept-Encoding: gzip\r\n");
	ctrl_puts(sr, "Accept-Language: en\r\n");
	ctrl_puts(sr, "Accept-Charset: iso-8859-1,*,utf-8\r\n");
	sprintf(buf, "Cookie: %s\r\n", sr->priv->cookies);
	ctrl_puts(sr, buf);
	ctrl_puts(sr, "User-Agent:MarketTracker 1.1.7 1.2.0\r\n");
	ctrl_puts(sr, "Content-type: multipart/form-data\r\n");
	sprintf(buf, "Content-length: %d\r\n", len);
	ctrl_puts(sr, buf);
	ctrl_puts(sr, "\r\n");
	ctrl_puts(sr, str);
	return (0);
}

/*
 *	Read a NUL terminated string from control channel
 */
static int
ctrl_resp0(STREAMER sr, char *buf, int size)
{
	int	c;
	char	*p = buf;
	char	*e = buf + size - 1;

	while ( (c = fgetc(sr->priv->cfp)) != EOF)
	{
		if (p < e)
			*p++ = c;
		if (c == 0)
			break;
	}
	*p = 0;
	return (p - buf);
}


static int
ctrl_resp(STREAMER sr)
{
	int	rlen = 0;
	int	len;
	char	buf[BUFSIZ];
	int	size = sizeof(buf);

	//HTTP/1.0 200 OK 
	//Cache-Control: private
	//Connection: Keep-Alive
	//Content-Type: application/octet-stream
	//Content-Length: 15
	//
	//0       1.1.6 1.2.0^@^@P
	for (;;)
	{
		char	*p;
		int	len;

		if (fgets(buf, size, sr->priv->cfp) == NULL)
			return -1;
		sr->cnt_rx += strlen(buf);

		p = strchr(buf, '\r');
		if (!p) p = strchr(buf, '\n');
		if (!p) p = strchr(buf, 0);
		len = p - buf;

		if (StreamerLog)
			fprintf(StreamerLog, "c< %.*s\n", len, buf);
		if (Debug >= 5)
		{
			timestamp(stderr);
			hexdump(stderr, "<", "            ", buf, len);
			// fprintf(stderr, "c< %.*s\n", len, buf);
		}

		if (strncmp(buf, "Content-Length:", 15) == 0)
			rlen = atoi(buf+15);

		if (len == 0)
			break;
	}

	while ( (len = ctrl_resp0(sr, buf, size)) > 0)
	{
		if (StreamerLog)
			fprintf(StreamerLog, "c< %.*s\n", len, buf);
		if (Debug >= 5)
		{
			timestamp(stderr);
			hexdump(stderr, "<", "            ", buf, len+1);
		}
		if (strncmp(buf, "0\t", 2))
			continue;
		if (!strchr(buf, 0xff))
			continue;

		/* we got a quote */
		do_ctrlquote(sr, buf+2);
	}

	return (0);
}

static int
ctrl_sr(STREAMER sr, char *str)
{
	int	rc;

	rc = ctrl_open(sr);
	if (rc <= 0)
		return rc;
	rc = ctrl_post(sr, str);

	rc = ctrl_resp(sr);
	fclose(sr->priv->cfp);
	return rc;
}

//static void
//ctrl_sr_thread(void *arg)
//{
//}

static int 
streamer_open( STREAMER sr, RCFILE *rcp, FILE *readfile)
{
	int			rc;
	char			buf[BUFSIZ];
	struct hostent		*hep;
	struct sockaddr_in	sockaddr;
	int			conn_tries;
	//int			read_tries;
	char			*username = get_rc_value(rcp, "username");
	char			*password = get_rc_value(rcp, "password");
	char			*hostname = get_rc_value(rcp, "hostname");
	char			*p;

	streamer_init(sr);
	++sr->cnt_opens;
	++sr->cnt_realopens;
	time(&sr->time_open);
	time(&sr->time_realopen);

	sr->priv->port = atoi(get_rc_value(rcp, "port"));

	/*
	 * Get cookies
	 */
	if (Debug >= 5)
		fprintf(stderr, "Authorize...\n");
	rc = p2open("/bin/bash", PROGNAMESTR ".auth yahoo.com 2>/dev/null",
			sr->priv->afp);
	if (rc < 0)
		return -1;

	fprintf(sr->priv->afp[1], "%s\n", username);
	fprintf(sr->priv->afp[1], "%s\n", password);
	fflush(sr->priv->afp[1]);

	fgets(sr->priv->cookies, sizeof(sr->priv->cookies), sr->priv->afp[0]);
	p = strchr(sr->priv->cookies, '\r');
	if (!p) p = strchr(sr->priv->cookies, '\n');
	if (!p) p = strchr(sr->priv->cookies, 0);
	*p = 0;

	rc = p2close(sr->priv->afp);
	if (rc < 0)
		return -1;

	if (Debug >= 5)
		fprintf(stderr, "Authorized: '%s'\n", sr->priv->cookies);

	/*
	 *	Open streamer
	 */
	hep = mygethostbyname(hostname);
	if (!hep)
		return (-1);

	memcpy(&sockaddr.sin_addr, hep->h_addr, hep->h_length);
	sockaddr.sin_family = AF_INET;
	sockaddr.sin_port = htons(sr->priv->port);

	conn_tries = 0;
reconnect:
	if (++conn_tries >= 5)
		return -4;

	if (Debug >= 5)
		fprintf(stderr, "Open socket...\n");

	sr->fd[0] = socket(AF_INET, SOCK_STREAM, 0);
	if (sr->fd[0] < 0)
		return -2;

	if (Debug >= 5)
		fprintf(stderr, "Socket fd=%d...\n", sr->fd[0]);

	if (Debug >= 5)
		fprintf(stderr, "Connect to '%s'...\n", hostname);

	rc = connect_timeout(sr->fd[0], (SA *) &sockaddr, sizeof(sockaddr), 15);
	if (rc < 0)
	{
		if (Debug >= 5)
			syserror(0, "Couldn't connect\n");
		close(sr->fd[0]);
		sr->fd[0] = -1;
		sleep(1);
		goto reconnect;
	}

	sr->priv->fp = fdopen(sr->fd[0], "r+");

	streamer_puts(sr, "GET / HTTP/1.0\r\n");
	streamer_puts(sr, "Connection: Keep-Alive\r\n");
	streamer_puts(sr, "User-Agent: "
			"Mozilla/4.0 (compatible; MSIE 5.5; Windows 98)\r\n");
	streamer_puts(sr, "Host: markettracker.finance.yahoo.com\r\n");
	streamer_puts(sr, "Accept: image/gif, image/jpeg, image/png, */*\r\n");
	streamer_puts(sr, "Accept-Encoding: gzip\r\n");
	streamer_puts(sr, "Accept-Language: en\r\n");
	streamer_puts(sr, "Accept-Charset: iso-8859-1,*,utf-8\r\n");
	sprintf(buf, "Cookie: %s\r\n", sr->priv->cookies);
	streamer_puts(sr, buf);
	streamer_puts(sr, "\r\n");

	for (;;)
	{
		char	*p;
		int	len;

		if (fgets(buf, sizeof(buf), sr->priv->fp) == NULL)
		{
err:
			fclose(sr->priv->fp);
			sr->fd[0] = -1;
			goto reconnect;
		}

		p = strchr(buf, '\r');
		if (!p) p = strchr(buf, '\n');
		if (!p) p = strchr(buf, 0);
		len = p - buf;

		if (StreamerLog)
			fprintf(StreamerLog, "< %.*s\n", len, buf);
		if (Debug >= 5)
		{
			timestamp(stderr);
			fprintf(stderr, "< %.*s\n", len, buf);
		}

		if (len == 0)
			break;
	}

	rc = streamer_fread(sr, buf, sizeof(buf));
	if (rc <= 0)
		goto err;

	strcpy(sr->priv->ctrlhost, buf+2);
	if (Debug >= 5)
			fprintf(stderr, "Control host is '%s'\n",
					sr->priv->ctrlhost);

	/*
	 *	Open control connection
	 */
	if (Debug >= 5)
		fprintf(stderr, "Send version info...\n");

	rc = ctrl_sr(sr, "version 1.1.7 1.2.0\r\n");

	rc = ctrl_sr(sr, "symbol add\tS0006 S0008 ^DJI ^IXIC ^GSPC\r\n");

	return sr->fd[0];
}
static int
streamer_select(
		STREAMER sr,
		int n, fd_set *readfds, fd_set *writefds,
		fd_set *exceptfds, struct timeval *timeout
		)
{
	if (readfds && FD_ISSET(sr->fd[0], readfds) && FRcnt(sr->priv->fp))
	{
			FD_ZERO(readfds);
			FD_SET(sr->fd[0], readfds);
			if (writefds)
				FD_ZERO(writefds);
			if (exceptfds)
				FD_ZERO(exceptfds);
			return 1;
	}
	return select(n, readfds, writefds, exceptfds, timeout);
}

static void
streamer_close(STREAMER sr)
{
	fclose(sr->priv->fp);
	sr->priv->fp = NULL;
}

static void
streamer_record(STREAMER sr, FILE *fp)
{
	sr->writefile = fp;
}

static void
streamer_timetick(STREAMER sr, time_t now)
{
	if (now > sr->priv->last_flush + 5)
	{
		if (sr->writefile)
			fflush(sr->writefile);
	}
}

#if 0
static void
send_stocklist(STREAMER sr)
{
	char	buf[BUFSIZ];
	char	*p;
	int	i;

	// Walk list of all stocks and write symbols to streamer process
	p = buf;
	p += sprintf(p, "symbol add\t");
	for (i = 0; i < NumStock; ++i)
	{
		char sym[SYMLEN+1];

		streamer_canon2sym(sym, Stock[i].sym);
		p += sprintf(p, "%s ", sym);
	}
	p += sprintf(p, "\r\n");

	ctrl_sr(sr, buf);
}
#endif

static void
streamer_send_quickquote(STREAMER sr, char *sym)
{
	char	csym[SYMLEN+1];
	char	buf[BUFSIZ];

	if (sr->fd[0] < 0 || sr->readfile)
		return;

	streamer_canon2sym(csym, sym);
	sprintf(buf, "symbol get\t%s \r\n", csym);
	ctrl_sr(sr, buf);
}

static void
streamer_send_livequote(STREAMER sr, char *sym)
{
	if (sr->fd[0] < 0 || sr->readfile)
		return;

	if (sr->priv->symcnt >= SYMCNT)
		return;

	if (sr->priv->symcnt == 0)
		strcpy(sr->priv->symbuf, "");

	strcat(sr->priv->symbuf, sym);
	strcat(sr->priv->symbuf, " ");
	++sr->priv->symcnt;
}

static void
streamer_send_livequote_end(STREAMER sr)
{
	char	buf[128+SYMBUFLEN];

	if (!sr->priv->symcnt)
		return;

	sprintf(buf, "symbol get\t%s\r\n", sr->priv->symbuf);
	sr->priv->symcnt = 0;
	ctrl_sr(sr, buf);
}

static void
streamer_send_symbols(STREAMER sr, char *symbols, int add)
{
	char	*p;
	int	cnt;

	if (sr->fd[0] < 0 || sr->readfile)
		return;

	if (sr->priv->symcnt >= SYMCNT)
		return;

	if (sr->priv->symcnt == 0)
		strcpy(sr->priv->symbuf, "");

	for (cnt = 1, p = symbols; *p; ++p)
		if (*p == ' ' || *p == ',')
			++cnt;

	sr->priv->symcnt += cnt;
	strcat(sr->priv->symbuf, symbols);
	strcat(sr->priv->symbuf, " ");
}

static void
streamer_send_symbols_end(STREAMER sr, int add, int all)
{
	char	*p;
	char	sbuf[SYMBUFLEN];
	char	buf[128+SYMBUFLEN];

	if (sr->fd[0] < 0 || sr->readfile)
		return;

	for (p = sr->priv->symbuf; *p; ++p)
		if (*p == ' ' || *p == ',')
			*p = ' ';

	streamer_canon2sym(sbuf, sr->priv->symbuf);

	sprintf(buf, "symbol %s\t%s\r\n",
			add ? "add" : "remove",
			sbuf);

	sr->priv->symcnt = 0;
	ctrl_sr(sr, buf);
}

#if 0
static void
streamer_send_disconnect(STREAMER sr) {}

static void
streamer_send_top10(STREAMER sr, char market, int type, int add) {}

static void
streamer_send_movers(STREAMER sr, int on) {}

static void
streamer_send_info(STREAMER sr, char *sym, int type) {}

static void
streamer_send_optchain(STREAMER sr, char *sym) {}

static void
streamer_send_chart(STREAMER sr, char *sym, int freq, int periods) {}
#endif

static int
adv(char *p, char sep)
{
	char	*b = p;

	while (*p && *p++ != sep)
		{}
	return (p - b);
}

static void
do_ctrlquote(STREAMER sr, unsigned char *buf)
{
	char		*p;
	int		rc;
	int		len;
	char		mname[32];
	QUOTE		q;
	QUICKQUOTE	qq;
	LIVEQUOTE	lq;
	int		hh, mm, ss;
	char		sep = 0xff;

	// SUNW|SUN MICROSYS INC|12.110|-.420|-3.46|12.150|12.290|11.950|
	// 12.530|0|12.230|500|12.260|200|34|60513100|35.125|7.520|16:0|
	// NSD|realtime|0|0|N/A
	
	// AT-N|ATEL N|860|830|850|4|860|215|860|850|25|134046
	// ATLAN|ATLAN SAR C 12/02|.08|.08|.07|50000|.09|50000|0|0|0|121616
	// SYM | NAME | LAST | PCLOSE | BID | BSIZE | ASK | ASIZE
	// | HI | LO | VOL | HHMMSS

	memset(&q, 0, sizeof(q));
	memset(&qq, 0, sizeof(qq));

	p = buf;
	len = adv(p, sep);
	if (len > SYMLEN+1)
		return;
	strncpy(q.sym, p, len-1); q.sym[len-1] = 0;

	streamer_sym2canon(q.sym, q.sym);

	strcpy(qq.sym, q.sym);
	strcpy(lq.sym, q.sym);
	p += len;

	len = adv(p, sep); /* unknown */; p += len;
	len = adv(p, sep); lq.last = qq.last = q.last = atof(p); p += len;
	len = adv(p, sep); memcpy(qq.fullname, p, len);
				qq.fullname[len-1]=0; p += len;
	len = adv(p, sep); /* date */; p += len;
	len = adv(p, sep); /* time */;
		rc = sscanf(p, "%2d:%2d", &hh, &mm); ss = 0;
		hh -= 4; /* TODO fix for DST */
		qq.timetrade = q.time = hh * 3600 + mm * 60 + ss;
		p += len;
	len = adv(p, sep); qq.high = q.high = atof(p); p += len;
	len = adv(p, sep); qq.low = q.low = atof(p); p += len;
	len = adv(p, sep); qq.volume = q.volume = atof(p); p += len;
	len = adv(p, sep); qq.last_size = q.last_size = atoi(p); p += len;
	len = adv(p, sep); qq.bid = q.bid = atof(p); p += len;
	len = adv(p, sep); qq.ask = q.ask = atof(p); p += len;
	len = adv(p, sep); /* open? */; p += len;
	len = adv(p, sep); lq.close=qq.prev_close = q.close = atof(p); p += len;
#define P fprintf(stderr, "<%s>\n", p);
	len = adv(p, sep); qq.high52 = atof(p); p += len;
	len = adv(p, sep); qq.low52 = atof(p); p += len;
	len = adv(p, sep); /* EPS */; p += len;
	len = adv(p, sep); /* unknown */; p += len;
	len = adv(p, sep); qq.annualdiv = 10000 * atof(p); p += len;
	len = adv(p, sep); /* unknown */; p += len;
	len = adv(p, sep); /* div date */
			sscanf(p, "%d %s %d", &qq.divDD, mname, &qq.divYY);
			if (strcmp(mname, "JAN") == 0) qq.divMM = 1;
			else if (strcmp(mname, "FEB") == 0) qq.divMM = 2;
			else if (strcmp(mname, "MAR") == 0) qq.divMM = 3;
			else if (strcmp(mname, "APR") == 0) qq.divMM = 4;
			else if (strcmp(mname, "MAY") == 0) qq.divMM = 5;
			else if (strcmp(mname, "JUN") == 0) qq.divMM = 6;
			else if (strcmp(mname, "JUL") == 0) qq.divMM = 7;
			else if (strcmp(mname, "AUG") == 0) qq.divMM = 8;
			else if (strcmp(mname, "SEP") == 0) qq.divMM = 9;
			else if (strcmp(mname, "OCT") == 0) qq.divMM = 10;
			else if (strcmp(mname, "NOV") == 0) qq.divMM = 11;
			else if (strcmp(mname, "DEC") == 0) qq.divMM = 12;
			else qq.divMM = 0;
			p += len;
	len = adv(p, sep); /* ex div date unknown */; p += len;
	len = adv(p, sep); qq.sharesout = atof(p); p += len;
	len = adv(p, sep); /* unknown */; p += len;

	len = adv(p, sep); /* unknown */; p += len;
	len = adv(p, sep); /* unknown */; p += len;
	len = adv(p, sep); /* unknown */; p += len;
	len = adv(p, sep); /* unknown */; p += len;
	len = adv(p, sep); /* unknown */; p += len;
	len = adv(p, sep); qq.ask_size = q.ask_size = atoi(p) / 100; p += len;
	len = adv(p, sep); qq.bid_size = q.bid_size = atoi(p) / 100; p += len;

	q.delayed = 0;

	qq.bid_id = qq.ask_id = '?';
	qq.last_eps = 12345678;
	qq.cur_eps = 12345678;

	display_quote(&q, 0);
	optchain_quote(&q);

	info_quickquote(&qq);

	display_livequote(&lq);
}

static void
do_rquote(STREAMER sr, unsigned char *buf)
{
	char		*p;
	int		rc;
	int		len;
	STOCK		*sp;
	QUOTE		q;
	LIVEQUOTE	lq;
	int		hh, mm, ss;
	char		sep = 0xff;

	//RINTC28.2 10 APR 200214:1928.2 28.21 1.17257e+07500300120017408
	memset(&q, 0, sizeof(q));

	p = buf;
	len = adv(p, sep); /* R */; p += len;

	len = adv(p, sep);
	if (len > SYMLEN+1)
		return;
	strncpy(q.sym, p, len-1); q.sym[len-1] = 0;

	streamer_sym2canon(q.sym, q.sym);

	sp = find_stock(q.sym);
	if (!sp)
		return;

	copy_quote(&sp->cur, &q, NULL, &lq);

	strcpy(lq.sym, q.sym);
	p += len;

	len = adv(p, sep); lq.last = q.last = atof(p); p += len;
	len = adv(p, sep); /* date */; p += len;
	len = adv(p, sep); /* time */;
		rc = sscanf(p, "%2d:%2d", &hh, &mm); ss = 0;
		hh -= 4; /* TODO fix for DST */
		q.time = hh * 3600 + mm * 60 + ss;
		p += len;
	len = adv(p, sep); q.bid = atof(p); p += len;
	len = adv(p, sep); q.ask = atof(p); p += len;
	len = adv(p, sep); q.volume = atof(p); p += len;
	len = adv(p, sep); q.last_size = atoi(p); p += len;
	len = adv(p, sep); q.bid_size = atoi(p) / 100; p += len;
	len = adv(p, sep); q.ask_size = atoi(p) / 100; p += len;
	len = adv(p, sep); /* unknown */; p += len;

	q.delayed = 0;

	display_quote(&q, sp->old.volume != q.volume);
	optchain_quote(&q);
	display_livequote(&lq);
}

static void
do_news(STREAMER sr, unsigned char *buf)
{
	char	*sym;
	char	*link;
	char	*headline;
	time_t	tim;
	char	*src;
	int	len;
	char	*p;
	char	sep = 0xff;

	// 30  ffff 2772 0000 00b3 4eff 4a44 5355 ff68   ..'r....N.JDSU.h 
	// 40  7474 703a 2f2f 6269 7a2e 7961 686f 6f2e   ttp://biz.yahoo. 
	// 50  636f 6d2f 6277 2f30 3230 3431 332f 3133   com/bw/020413/13 
	// 60  3230 3036 5f31 2e68 746d 6cff 5370 6563   2006_1.html.Spec 
	// 70  746f 722c 2052 6f73 656d 616e 2026 204b   tor, Roseman & K 
	// 80  6f64 726f 6666 2c20 502e 432e 2041 6e6e   odroff, P.C. Ann 
	// 90  6f75 6e63 6573 2043 6c61 7373 2041 6374   ounces Class Act 
	// a0  696f 6e20 4c61 7773 7569 7420 4167 6169   ion Lawsuit Agai 
	// b0  6e73 7420 4a44 5320 556e 6970 6861 7365   nst JDS Uniphase 
	// c0  2043 6f72 706f 7261 7469 6f6e ff31 3031    Corporation.101 
	// d0  3837 3036 3436 30ff 4275 7369 6e65 7373   8706460.Business 
	// e0  2057 6972 65ff 3236 3000 00                Wire.260..      
	//
	p = buf;
	len = adv(p, sep); /* R */; p += len;
	len = adv(p, sep); sym = p; p[len-1] = 0; p += len;
	len = adv(p, sep); link = p; p[len-1] = 0; p += len;
	len = adv(p, sep); headline = p; p[len-1] = 0; p += len;
	len = adv(p, sep); tim = atoi(p); p += len;
	len = adv(p, sep); src = p; p[len-1] = 0; p += len;
	len = adv(p, sep); len = atoi(p); p += len;
	display_scrollnews(sym, link, headline, tim, src, 0);
}

static int
streamer_process(STREAMER sr, int fdindex)
{
	char	buf[4096];
	int	len;

	len = streamer_fread(sr, buf, sizeof(buf));
	if (len < 0)
	{
		if (Debug)
			syserror(0, "streamer_process: len = %d\n", len);
		return -1;
	}

	switch (buf[2])
	{
	case 'R':
	case 'Q':
		do_rquote(sr, buf+2);
		break;
	case 'N':
		do_news(sr, buf+2);
		break;
	case 'U':
	case 'I':
	case 'S':
		break;
	}

	if (Debug >= 5 && buf[2] == 'N')
		do_rquote(sr, "RINTC28.2 10 APR 200214:1928.2 28.21 1.17257e+07500300120017408");

	return 0;
}

STREAMER
yahoo_new(void)
{
	STREAMER	sr;

	sr = (STREAMER) malloc(sizeof(*sr));
	if (!sr)
		return NULL;
	memset(sr, 0, sizeof(*sr));

	sr->open = streamer_open;
	sr->select = streamer_select;
	sr->close = streamer_close;
	sr->record = streamer_record;
	sr->timetick = streamer_timetick;

	sr->send_quickquote = streamer_send_quickquote;
	sr->send_livequote = streamer_send_livequote;
	sr->send_livequote_end = streamer_send_livequote_end;
	sr->send_symbols = streamer_send_symbols;
	sr->send_symbols_end = streamer_send_symbols_end;

	// sr->send_disconnect = streamer_send_disconnect;
	// sr->send_top10 = streamer_send_top10;
	// sr->send_movers = streamer_send_movers;
	// sr->send_info = streamer_send_info;
	// sr->send_optchain = streamer_send_optchain;
	// sr->send_chart = streamer_send_chart;

	sr->process = streamer_process;

	sr->priv = (STREAMERDATA *) malloc(sizeof(*sr->priv));
	if (!sr->priv)
	{
		free(sr);
		return NULL;
	}

	time(&sr->time_start);

	streamer_init(sr);

	return (sr);
}
