/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/
#include "parameter.h"
#include "crxchannel.h"
#include "constants.h"

extern Parameter settings;

void ModeMenu::init()
{
RxMode->insertItem("BPSK",0);
RxMode->insertItem("QPSK",1);
RxMode->insertItem("RTTY",2);
RxMode->insertItem("MFSK16",3);
RxMode->setSelected(settings.ActChannel->getModulationType() ,true);
if ( settings.ActChannel->getModulationType() != RTTY)
 {
  Parity->hide();
  Spacing->hide();
  Reverse->hide();
 }   
}
void ModeMenu::changeView(int index)
{
RxMode->setSelected(index,true);
if ( index == RTTY )
 {
  Parity->show();
  Spacing->show();
  Reverse->show();
  Stopbits->show(); 
 }
else
 {
  Parity->hide();
  Spacing->hide();
  Reverse->hide();
  Stopbits->hide();

 } 
}
void ModeMenu::setParameter(ExtraParameter Param)
{
RTTYSpacing->setValue(Param.offset);
Parity->setButton(Param.parity);
Stopbits->setButton(Param.stopbits);
Reverse->setChecked(Param.reverse);
}
ExtraParameter ModeMenu::getParameter()
{
ExtraParameter Param;

Param.offset=RTTYSpacing->value();
Param.reverse=Reverse->isChecked();
Param.parity=(Paritaet) Parity->selectedId();
Param.stopbits=(StopBits) Stopbits->selectedId();
return Param;
}


