
#include "controlpanel.h"

#include <qvariant.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

#include "spectrumdisplay.h"
#include "qsodata.h"
#include "macrowindow.h"

/* 
 *  Constructs a ControlPanel which is a child of 'parent', with the 
 *  name 'name'.' 
 */
ControlPanel::ControlPanel( QWidget* parent,  const char* name )
    : QFrame( parent, name )
{
    setFrameShape( QFrame::StyledPanel );
    setFrameShadow( QFrame::Sunken );

    Display = new SpectrumDisplay( this, "SpectrumDisplay" );
    QSO = new QSOData(this,"QSOData");
    MacroBox = new MacroWindow(this,"MacroBox");
    languageChange();
}

/*
 *  Destroys the object and frees any allocated resources
 */
ControlPanel::~ControlPanel()
{
 if(QSO)
  delete QSO;
 QSO=0;
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void ControlPanel::languageChange()
{
    setCaption( tr( "QFrameForm" ) );
}
void ControlPanel::calculateSizeofComponents()
{
#define TOPMARGIN 2
#define LEFTMARGIN 2
#define SPECTRUMWIDTH 35
#define SPECTRUMHEIGHT 85

int xpos,ypos,width,height,innerheight,innerwidth;
width=this->width();
height=this->height();
xpos=width*LEFTMARGIN/100;
ypos=height*TOPMARGIN/100;
innerwidth=(width-xpos)*SPECTRUMWIDTH/100;
innerheight=((height-2*ypos)*SPECTRUMHEIGHT)/100;
Display->setGeometry(xpos,ypos,innerwidth,innerheight);
xpos=xpos+innerwidth+10;
innerwidth=innerwidth+20;
innerheight=(height*(100-2*TOPMARGIN))/100;

QSO->setGeometry(xpos,ypos,innerwidth,innerheight);
xpos = xpos+innerwidth+10;
innerwidth = width-xpos-5;
//if (MacroBox->verticalScrollBar()->isVisible() )

MacroBox->setGeometry(xpos,ypos,innerwidth,innerheight);

}

void ControlPanel::resizeEvent( QResizeEvent * )
{
calculateSizeofComponents();
}
