#!/bin/bash

# copyright 2002 lmoore@tump.com under the terms of the GNU LGPL.

# setApplicationTitle text
#   set the application title.  this may be ignored by the implementations
#
# setDimension width height
#   set the width and height of the box.  this may be ignored by the
#   implementations
#
# booleanBox title text
#   issue a yes/no box.  presents two buttons "yes" and "no".  
#   returns 0 on yes, 1 on no, 255 on cancel/error.
#
# msgBox title text
#   show a message in a box
#
# inputBox title text [initial-input]
#   show a text message and text input field.  the optional initial-input
#   may be ignored by implementations.  returns 0 and puts the input in the 
#   variable REPLY input on success and non-zero on failure.
# 
# menuBox title text {tag item}+
#   show a text message and a menu.  returns 0 and puts the tag of the 
#   selected item in the variable REPLY success. returns non-zero on failure.
#
# checkBox title text {tag item status}+
#   show a text message and a list of checkable items.  multiple items can be 
#   checked.  status is either "on" or "off".  returns 0 and puts the tags
#   of all selected items in the variable REPLY. returns non-zero on failure.
#   
# radioBox title text {tag item status}+
#   this is the same as checkBox but only a single item selected at a time.
#
# textBox title file
#   show a file in a text box
#
# passwordBox title text
#   same as inputBox, but the input text won't be echoed.  some 
#   implementations may not support non-echoing input.

# the following is private implementation, users don't need to look past
# here

console_dialogs="dialog whiptail"
x_dialogs="Xdialog"

test -z "$WIDTH" && WIDTH=0
test -z "$HEIGHT" && HEIGHT=0
BACKTITLE=""

setApplicationTitle() {
    BACKTITLE=$*
}

setDimension() {
    WIDTH=$1
    HEIGHT=$2
}

findProg() {
    # this is probably overkill
    which $1 > /dev/null 2> /dev/null
}

testXserver() {
  # attempts to test if user can write to the X server
  if [ -n "$(which xdpyinfo)" ]; then
    # requires xbase-clients
    xdpyinfo &> /dev/null
    return $?
  else
    # assume the best
    return 0
  fi
}

getImplementation() {
    if [ -n "$DISPLAY" ]; then
	# they running X, let's try to use an X based dialog
	testXserver
        if [ "$?" = "0" ]; then
        	for p in $x_dialogs ; do
		  findProg $p && { echo $p; return 0; }
       		done
        fi
    fi

    # no X or no X based implementation
    for p in $console_dialogs ; do
	findProg $p && { echo $p; return 0; }
    done

    # nothing matched, fallback on the command line
    echo "cmdline"
    return 0
}

# if the user specifies a preference, we'll attempt to honor it
if [ -z "$DIALOG" ]; then
    # no preference, we'll do what we can
    DIALOG=$(getImplementation)
fi

case "$DIALOG" in
    Xdialog|xdialog) source easydialog_Xdialog.sh;;
    dialog|whiptail) source easydialog_dialog.sh;;
    cmdline) source easydialog_cmdline.sh;;
    *)  echo "$DIALOG is not a valid easydialog implementation."
        exit 1
        ;;
esac
