%{
#include "parser.h"
%}

%union {
double dval;  /* For returning numbers.                   */
symrec *tptr;   /* For returning symbol-table pointers      */
}
     
%token <dval>  NUM 	/* Simple double precision number   */
%token <tptr> VAR FNCT	/* Variable and Function            */
%type  <dval>  expr
    
%right '='
%left '-' '+'
%left '*' '/'
%left NEG     /* Negation--unary minus */
%right '^'    /* Exponentiation        */
     
%%
input:   /* empty */
	| input line
;
     
line:	'\n'
	| expr '\n'   { res=$1; }
	| error '\n' { yyerrok;                  }
;
     
expr:      NUM       { $$ = $1;                         }
| VAR                { $$ = $1->value.var;              }
| VAR '=' expr       { $$ = $3; $1->value.var = $3;     }
| FNCT '(' expr ')'  { $$ = (*($1->value.fnctptr))($3); }
| FNCT '(' expr ',' expr ')'  { $$ = (*($1->value.fnctptr))($3,$5); }
| FNCT '(' expr ',' expr ','expr ')'  { $$ = (*($1->value.fnctptr))($3,$5,$7); }
| FNCT '(' expr ',' expr ',' expr ','expr ')'  { $$ = (*($1->value.fnctptr))($3,$5,$7,$9); }
| expr '+' expr      { $$ = $1 + $3;                    }
| expr '-' expr      { $$ = $1 - $3;                    }
| expr '*' expr      { $$ = $1 * $3;                    }
| expr '/' expr      { $$ = $1 / $3;                    }
| '-' expr  %prec NEG{ $$ = -$2;                        }
| expr '^' expr      { $$ = pow ($1, $3);               }
| '(' expr ')'       { $$ = $2;                         }
;

%%

/* The symbol table: a chain of `struct symrec'.  */
symrec *sym_table = (symrec *) 0;

double parse(char *str) {
	int i;
	pos=0;

	/* reset string, because it's global !	*/
	for (i=0;i<500;i++) 
		string[i]=EOF;

	strcpy(string,str);
	string[strlen(str)]='\n';
	init_table();
	yyparse();
	
	while(sym_table) {
		symrec *tmp = sym_table;
		sym_table = sym_table->next;
		free(tmp->name);
		free(tmp);
	}
		
	return res;
}
  
int yyerror (const char *s){
	printf ("ERROR : %s\n", s);
	return 0;
}
     
/* Put arithmetic functions in table. */
void init_table (void) {
	symrec *ptr;
	int i;
	/* add functions */
	for (i = 0; arith_fncts[i].fname != 0; i++) {
		ptr = putsym (arith_fncts[i].fname, FNCT);
		ptr->value.fnctptr = arith_fncts[i].fnct;
	}
	/* add constants */
	for (i = 0; constants[i].name != 0; i++) {
		ptr = putsym (constants[i].name, VAR);
		ptr->value.var = constants[i].value;
	}
}

symrec * putsym (const char *sym_name, int sym_type) {
	symrec *ptr;
	ptr = (symrec *) malloc (sizeof (symrec));
	ptr->name = (char *) malloc (strlen (sym_name) + 1);
	strcpy (ptr->name,sym_name);
	ptr->type = sym_type;
	ptr->value.var = 0; /* set value to 0 even if fctn.  */
	ptr->next = (struct symrec *)sym_table;
	sym_table = ptr;
	return ptr;
}

symrec * getsym (const char *sym_name) {
	symrec *ptr;
	for (ptr = sym_table; ptr != (symrec *) 0;
			ptr = (symrec *)ptr->next)
		if (strcmp (ptr->name,sym_name) == 0)
			return ptr;
	return 0;
}

static int getcharstr(void) {
    if (pos >= strlen(string))
         return EOF;
    return (string[pos++]);
}
 
static void ungetcstr(void) {
    if (pos > 0)
        pos--;
} 

int yylex (void) {
	int c;
	
	/* skip white space  */
	while ((c = getcharstr ()) == ' ' || c == '\t');

	/* return end-of-file  */
	if (c == EOF) {
		return 0;
	}
	/* process numbers   */
	if (c == '.' || isdigit (c)) {
		char *tmp, *tmp2;
                double resu;
                ungetcstr();
                tmp = &string[pos];
                resu = strtod(tmp,&tmp2);
                sscanf (tmp,"%lf", &(yylval.dval));
                pos+= strlen(tmp)-strlen(tmp2);
		
		return NUM;
	}

	/* Char starts an identifier => read the name.       */
	if (isalpha (c)) {
		symrec *s;
		static char *symbuf = 0;
		static int length = 0;
		int i;

		/* Initially make the buffer long enough
		   for a 20-character symbol name.  */
		if (length == 0)
			length = 20, symbuf = (char *)malloc (length + 1);

		i = 0;
		do {
			/* If buffer is full, make it bigger.        */
			if (i == length) {
				length *= 2;
				symbuf = (char *)realloc (symbuf, length + 1);
			}
			/* Add this character to the buffer.         */
			symbuf[i++] = c;
			/* Get another character.                    */
			c = getcharstr ();
		}
		while (c != EOF && (isalnum (c) || c == '_'));

		ungetcstr ();
		symbuf[i] = '\0';

		s = getsym (symbuf);
		if (s == 0)
			s = putsym (symbuf, VAR);
		yylval.tptr = s;
		return s->type;
	}


	/* return single chars */
	return c;
}
