//LabPlot : PlotGL.h

#ifndef PLOTGL_H
#define PLOTGL_H

#include <qgl.h>
#include "Plot.h"

class PlotGL : public Plot, public QGLWidget
{
public:
	PlotGL(Worksheet *p);
	QStringList Info() {return 0;}
	void initGL();
	void resizeGL(int w, int h);
	void paintGL();
	void drawGL();
	
	void saveAxes(QTextStream *t) {}
	void openAxes(QTextStream *t,int version) {}
	Axis *getAxis(int i) { return &axis[i]; }
	void setRanges(LRange* r) {range[0]=r[0];range[1]=r[1];}
	void setActRanges(LRange* r) {}
	void enableGrid(int index,bool b) { gridenabled[index] = b; }
	bool gridEnabled(int index) { return gridenabled[index]; }
	void enableBorder(int index,bool b) { borderenabled[index] = b; }
	bool borderEnabled(int index) { return borderenabled[index]; }
	void draw(QPainter *p, int w, int h);
	void setBorder(int item, bool on) {}
private:
	void draw();
	void mousePressEvent(QMouseEvent *e);
	void mouseMoveEvent(QMouseEvent *e);
	Axis axis[3];		// TODO : number of axes ?
	bool borderenabled[4];	// TODO
	bool gridenabled[8];	// TODO

	GLfloat rotationX;
	GLfloat rotationY;
	GLfloat rotationZ;
	QColor faceColors[3];
	QPoint lastPos;
};

#endif //PLOTGL_H
