//LabPlot Plot2DSimple.cc

#include <math.h>
#include <kdebug.h>
#include "Plot2DSimple.h"

// simple 2D Plot class
Plot2DSimple::Plot2DSimple(Worksheet *p)
	: Plot2D(p)
{}

QStringList Plot2DSimple::Info() {
	QStringList s;
	s<<"2D";
	s<<QString::number(position.X())+QString(" , ")+QString::number(position.Y());
	s<<QString::number(size.X())+QString(" X ")+QString::number(size.Y());
	if (transparent)
		s<<QString("yes");
	else
		s<<QString("no");
	s<<bgcolor.name();
	s<<gbgcolor.name();

	return s;
}

void Plot2DSimple::drawCurves(QPainter *p,int w, int h) {
	//kdDebug()<<" Plot2DSimple::drawCurves"<<endl;
	const int xmin = (int)(w*(size.X()*p1.X()+position.X()));
	const int xmax = (int)(w*(size.X()*p2.X()+position.X()));
	const int ymin = (int)(h*(size.Y()*p1.Y()+position.Y()));
	const int ymax = (int)(h*(size.Y()*p2.Y()+position.Y()));
	//kdDebug()<<"xmin/xmax ymin/ymax : "<<xmin<<'/'<<xmax<<' '<<ymin<<'/'<<ymax<<endl;

	// clipping rect with some space (clipoffset)
	p->setClipRect(xmin-clipoffset,ymin-clipoffset,xmax-xmin+2*clipoffset,ymax-ymin+2*clipoffset);

	for (unsigned int i=0; i < graphlist->getNumber() ; i++) {
		GRAPHType s = graphlist->getStruct(i);

		//kdDebug()<<"GRAPH "<<i<<endl;
		//kdDebug()<<"STRUCT "<<s<<endl;
		if(graphlist->getGraph(i)->isShown() == FALSE)
			continue;

		if (s == GRAPH2D) {
			Graph2D *g = graphlist->getGraph2D(i);
			//kdDebug()<<"GRAPH2D Name = "<<g->Name()<<endl;

			if(g->Type() == P2D) {
				//kdDebug()<<"Type T2D\n";
				//kdDebug()<<"xmin/xmax "<<xmin<<' '<<xmax<<endl;
				//kdDebug()<<"ymin/ymax "<<ymin<<' '<<ymax<<endl;
				//kdDebug()<<"xact1/xact2 "<<actrange[0].rMin()<<' '<<actrange[0].rMax()<<endl;
				//kdDebug()<<"yact1/yact2 "<<actrange[1].rMin()<<' '<<actrange[1].rMax()<<endl;

				Point *d = g->Data();
				double oldx = 0.0, oldy = 0.0;
				for(int j=0;j<g->Number();j++) {
					double minx = actrange[0].rMin();
					double maxx = actrange[0].rMax();
					double miny = actrange[1].rMin();
					double maxy = actrange[1].rMax();
					double x=0,y=0;
					if (axis[0].Scale() == LINEAR)
						x = xmin + (d[j].X() - minx) * (xmax-xmin)/(maxx-minx);
					else if (axis[0].Scale() == LOG10)
						x = xmin + (log10(d[j].X()/minx)) * (xmax-xmin)/(log10(maxx/minx));
					else if (axis[0].Scale() == LOG2)
						x = xmin + (log2(d[j].X()/minx)) * (xmax-xmin)/(log2(maxx/minx));
					else if (axis[0].Scale() == LN)
						x = xmin + (log(d[j].X()/minx)) * (xmax-xmin)/(log(maxx/minx));
					else if (axis[0].Scale() == SQRT)
						x = xmin + (sqrt(d[j].X())-sqrt(minx)) * 
							(xmax-xmin)/(sqrt(maxx)-sqrt(minx));

					if(axis[1].Scale() == LINEAR)
						y = ymax - (d[j].Y() - miny) * (ymax-ymin)/(maxy-miny);
					else if(axis[1].Scale() == LOG10)
						y = ymax - (log10(d[j].Y()/miny)) * (ymax-ymin)/(log10(maxy/miny));
					else if(axis[1].Scale() == LOG2)
						y = ymax - (log2(d[j].Y()/miny)) * (ymax-ymin)/(log2(maxy/miny));
					else if(axis[1].Scale() == LN)
						y = ymax - (log(d[j].Y()/miny)) * (ymax-ymin)/(log(maxy/miny));
					else if (axis[1].Scale() == SQRT)
						y = ymax - (sqrt(d[j].Y())-sqrt(miny)) * 
							(ymax-ymin)/(sqrt(maxy)-sqrt(miny));

					if (j != 0) {
						drawStyle(p,g->getStyle(),(int)oldx,(int) oldy,
							(int) x,(int) y,xmin,xmax,ymin,ymax);
					}
					g->getSymbol().draw(p,(int)oldx,(int)oldy);
					g->getAnnotateValues().draw(p,(int)x,(int)y,d[j].X(),d[j].Y());
					
					oldx = x;oldy = y;
				}
				g->getSymbol().draw(p,(int)oldx,(int)oldy);		// draw last symbol
			}
		}
		else if (s == GRAPH3D)	{ // 2D error plot
			Graph3D *g = graphlist->getGraph3D(i);

			//kdDebug()<<"GRAPH3D\n";
			//kdDebug()<<"OK : "<<i<<" 3D number="<<g->Number()<<endl;
			//kdDebug()<<"OK : "<<i<<" NX/NY="<<g->NX()<<"/"<<g->NY()<<endl;

			Point3D *d = g->Data();
			double oldx=0, oldy=0;
			int N;
			if (g->NY()==0)
				N=g->NX();
			else
				N=(g->NX())*(g->NY());

			double minx = actrange[0].rMin();
			double maxx = actrange[0].rMax();
			double miny = actrange[1].rMin();
			double maxy = actrange[1].rMax();
			for(int j=0 ;j < N;j++) {
				double x=0,y=0;
					
				if (axis[0].Scale() == LINEAR)
					x = xmin + (d[j].X() - minx) * (xmax-xmin)/(maxx-minx);
				else if (axis[0].Scale() == LOG10)
					x = xmin + (log10(d[j].X()/minx)) * (xmax-xmin)/(log10(maxx/minx));
				else if (axis[0].Scale() == LOG2)
					x = xmin + (log2(d[j].X()/minx)) * (xmax-xmin)/(log2(maxx/minx));
				else if (axis[0].Scale() == LN)
					x = xmin + (log(d[j].X()/minx)) * (xmax-xmin)/(log(maxx/minx));
				else if (axis[0].Scale() == SQRT)
					x = xmin + (sqrt(d[j].X())-sqrt(minx)) * 
						(xmax-xmin)/(sqrt(maxx)-sqrt(minx));

				double ybottom=0, ytop=0;
	
				if(axis[1].Scale() == LINEAR) {
					y = ymax - (d[j].Y() - miny) * (ymax-ymin)/(maxy-miny);
					double diff = d[j].Z() *(ymax-ymin)/(maxy-miny);
					ybottom = y-diff;
					ytop = y+diff;
				}
				else if(axis[1].Scale() == LOG10) {
					double yscale = (ymax-ymin)/log10(maxy/miny);
					y = ymax - log10(d[j].Y()/miny) * yscale;
					ybottom = ymax - log10((d[j].Y()-d[j].Z())/miny) * yscale;
					ytop = ymax - log10((d[j].Y()+d[j].Z())/miny) * yscale;
				}
				else if(axis[1].Scale() == LOG2) {
					double yscale = (ymax-ymin)/log2(maxy/miny);
					y = ymax - log2(d[j].Y()/miny) * yscale;
					ybottom = ymax - log2((d[j].Y()-d[j].Z())/miny) * yscale;
					ytop = ymax - log2((d[j].Y()+d[j].Z())/miny) * yscale;
				}
				else if(axis[1].Scale() == LN) {
					double yscale = (ymax-ymin)/log(maxy/miny);
					y = ymax - log(d[j].Y()/miny) * yscale;
					ybottom = ymax - log((d[j].Y()-d[j].Z())/miny) * yscale;
					ytop = ymax - log((d[j].Y()+d[j].Z())/miny) * yscale;
				}
				else if (axis[1].Scale() == SQRT) {
					//TODO : test
					double yscale = (ymax-ymin)/(sqrt(maxy)-sqrt(miny));
					y = ymax - (sqrt(d[j].Y())-sqrt(miny)) * yscale;
					ybottom = ymax - (sqrt(d[j].Y()-d[j].Z())-sqrt(miny)) * yscale;
					ytop = ymax - (sqrt(d[j].Y()+d[j].Z())-sqrt(miny)) * yscale;
				}

				//kdDebug()<<"ytop="<<ytop<<",ybottom="<<ybottom<<endl;

				if (j != 0) {
					drawStyle(p,g->getStyle(),(int)oldx,(int) oldy,(int) x,(int) y,
						xmin, xmax, ymin, ymax);
				}
				p->setPen(g->getStyle().Color());
				drawErrorBar(p,(int)x,(int)y,(int)x,(int)x,(int)ytop,(int)ybottom);

				g->getSymbol().draw(p,(int)oldx,(int)oldy);

				g->getAnnotateValues().draw(p,(int)x,(int)y,d[j].X(),d[j].Y(),d[j].Z());
				
				oldx = x;oldy = y;
			}
			g->getSymbol().draw(p,(int)oldx,(int)oldy);
		}
		else if (s == GRAPH4D) {		// x-y-dx-dy or x-y-dy1-dy2
			Graph4D *g = graphlist->getGraph4D(i);

			//kdDebug()<<"GRAPH4D"<<endl;
			//kdDebug()<<"OK : "<<i<<" number="<<g->Number()<<endl;

			Point4D *d = g->Data();
			double oldx=0, oldy=0;
			int N=g->Number();
			bool type = g->GType();
			double minx = actrange[0].rMin();
			double maxx = actrange[0].rMax();
			double miny = actrange[1].rMin();
			double maxy = actrange[1].rMax();
			double xscale, yscale;
			
			for(int j=0 ;j < N;j++) {
				double x=0, y=0;
				double xright=0,xleft=0, ytop=0,ybottom=0;
				
				if (axis[0].Scale() == LINEAR) {
					xscale = (xmax-xmin)/(maxx-minx);
					x = xmin + (d[j].X() - minx) * xscale;
					if (type == 0) {	// x-y-dx-dy
						double diffx = d[j].Z() * xscale;
						xright = x+diffx;
						xleft = x-diffx;
					}
					else
						xleft=xright=x;
				}
				else if (axis[0].Scale() == LOG10) {
					xscale = (xmax-xmin)/(log10(maxx/minx));
					x = xmin + (log10(d[j].X()/minx)) * xscale;
					if (type == 0) {	// x-y-dx-dy
						xleft = xmin + (log10((d[j].X()-d[j].Z())/minx)) * xscale;
						xright = xmin + (log10((d[j].X()+d[j].Z())/minx)) * xscale;
					}
					else
						xleft=xright=x;
				}
				else if (axis[0].Scale() == LOG2) {
					xscale = (xmax-xmin)/(log2(maxx/minx));
					x = xmin + (log2(d[j].X()/minx)) * xscale;
					if (type == 0) {	// x-y-dx-dy
						xleft = xmin + (log2((d[j].X()-d[j].Z())/minx)) * xscale;
						xright = xmin + (log2((d[j].X()+d[j].Z())/minx)) * xscale;
					}
					else
						xleft=xright=x;
				}
				else if (axis[0].Scale() == LN) {
					xscale = (xmax-xmin)/(log(maxx/minx));
					x = xmin + (log(d[j].X()/minx)) * xscale;
					if (type == 0) {	// x-y-dx-dy
						xleft = xmin + (log((d[j].X()-d[j].Z())/minx)) * xscale;
						xright = xmin + (log((d[j].X()+d[j].Z())/minx)) * xscale;
					}
					else
						xleft=xright=x;
				}
				else if (axis[0].Scale() == SQRT) {
					xscale = (xmax-xmin)/(sqrt(maxx)-sqrt(minx));

					// TODO  : test
					x = xmin + (sqrt(d[j].X())-sqrt(minx)) * xscale;
					if (type == 0) {	// x-y-dx-dy
						xleft = xmin + (sqrt(d[j].X()-d[j].Z())-sqrt(minx)) * xscale;
						xright = xmin + (sqrt(d[j].X()+d[j].Z())-sqrt(minx)) * xscale;
					}
					else
						xleft=xright=x;
				}

				if(axis[1].Scale() == LINEAR) {
					yscale = (ymax-ymin)/(maxy-miny);
					y = ymax - (d[j].Y() - miny) * yscale;
					if (type == 0) {	// x-y-dx-dy
						double diff = d[j].T() * yscale;
						ytop = y+diff;
						ybottom = y-diff;
					}
					else {
						double diff1 = d[j].Z() * yscale;
						double diff2 = d[j].T() * yscale;
						ybottom = y-diff1;
						ytop = y+diff2;
					}
				}
				else if(axis[1].Scale() == LOG10) {
					yscale = (ymax-ymin)/log10(maxy/miny);
					y = ymax - log10(d[j].Y()/miny) * yscale;
					if (type == 0)
						ybottom = ymax - log10((d[j].Y()-d[j].T())/miny) * yscale;
					else 
						ybottom = ymax - log10((d[j].Y()-d[j].Z())/miny) * yscale;
					ytop = ymax - log10((d[j].Y()+d[j].T())/miny) * yscale;
				}
				else if(axis[1].Scale() == LOG2) {
					yscale = (ymax-ymin)/log2(maxy/miny);
					y = ymax - log2(d[j].Y()/miny) * yscale;
					if (type == 0)
						ybottom = ymax - log2((d[j].Y()-d[j].T())/miny) * yscale;
					else
						ybottom = ymax - log2((d[j].Y()-d[j].Z())/miny) * yscale;
					ytop = ymax - log2((d[j].Y()+d[j].T())/miny) * yscale;
				}
				else if(axis[1].Scale() == LN) {
					yscale = (ymax-ymin)/log(maxy/miny);
					y = ymax - log(d[j].Y()/miny) * yscale;
					if (type == 0)
						ybottom = ymax - log((d[j].Y()-d[j].T())/miny) * yscale;
					else
						ybottom = ymax - log((d[j].Y()-d[j].Z())/miny) * yscale;
					ytop = ymax - log((d[j].Y()+d[j].T())/miny) * yscale;
				}
				else if (axis[1].Scale() == SQRT) {
					//TODO : test
					yscale = (ymax-ymin)/(sqrt(maxy)-sqrt(miny));
					y = ymax - (sqrt(d[j].Y())-sqrt(miny)) * yscale;
					if (type == 0)
						ybottom = ymax - (sqrt(d[j].Y()-d[j].T())-sqrt(miny)) * yscale;
					else
						ybottom = ymax - (sqrt(d[j].Y()-d[j].Z())-sqrt(miny)) * yscale;
					ytop = ymax - (sqrt(d[j].Y()+d[j].T())-sqrt(miny)) * yscale;
				}

				//kdDebug()<<"xleft="<<xleft<<",xright="<<xright<<endl;
				//kdDebug()<<"ytop="<<ytop<<",ybottom="<<ybottom<<endl;

				if (j != 0) {
					drawStyle(p,g->getStyle(),(int)oldx,(int) oldy,
						(int) x,(int) y,xmin, xmax, ymin,ymax);
				}
				p->setPen(g->getStyle().Color());
				drawErrorBar(p,(int)x,(int)y,(int)xleft,(int)xright,(int)ytop,(int)ybottom);

				g->getSymbol().draw(p,(int)oldx,(int)oldy);

				// TODO : use Z,T too ?
				g->getAnnotateValues().draw(p,(int)x,(int)y,d[j].X(),d[j].Y());
				
				oldx = x;oldy = y;
			}
			g->getSymbol().draw(p,(int)oldx,(int)oldy);
		}
	}
	
	p->setClipping(false);
}
