//LabPlot : GraphM.h

#ifndef GRAPHM_H
#define GRAPHM_H

#include <qtextstream.h>
#include "Graph.h"
#include "LRange.h"
#include "defs.h"

class GraphM: public Graph
{
public:
	GraphM(QString n="", QString l="", LRange r[3]=0, LSource src=SFUNCTION, PType t=PSURFACE, Style st=Style(), 
		Symbol sy=Symbol(), double *a=0, int dimx=0, int dimy=0, bool s=TRUE);
	double *Data() { return array; }
	QPixmap Pixmap();
	void setPixmap(QPixmap pm);
	int width() { return (int)range[0].rMax(); }
	int height() { return (int)range[1].rMax(); }
	void setWidth(int w) { range[0] = LRange(0,w); }
	void setHeight(int h) { range[1] = LRange(0,h); }
	LRange Range(int i) { return range[i]; }
	void setRange(LRange *r) { range[0]=r[0];range[1]=r[1];range[2]=r[2]; }
	void setZRange(LRange *r) { range[2]=*r; }	// only set z range (EditDialog)
	int NX() { return nx; }
	int NY() { return ny; }
	void setNumber(int NX,int NY) {nx=NX, ny=NY; }
	QStringList Info();
	void save(QTextStream *t);
	void open(QTextStream *t, int version);	
private:
	int nx, ny;		//dimension
	double *array;
	LRange *range;
};

#endif // GRAPHM_H
