//LabPlot : GraphListDialog.cc

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <qstring.h>
#include <klocale.h>
#include "GraphListDialog.h"
#include "DataDialog.h"
#include "FunctionDialog.h"
#include "VTKDialog.h"
#include "GRASSDialog.h"

GraphListDialog::GraphListDialog(MainWin *mw,const char *name)
	: ListDialog(mw->activeWorksheet(), 0, name)
{
	setCaption(i18n("Graph List Dialog"));

	plot = p->getPlot(p->API());

	QGroupBox *gb = new QGroupBox(1,QGroupBox::Horizontal,i18n("Manipulation"),vbox);

	QHBox *hb = new QHBox(gb);
	KPushButton *addData = new KPushButton(i18n("Add Datafile"),hb);
	addData->setMaximumWidth(150);
	QObject::connect(addData,SIGNAL(clicked()),SLOT(newData()));
	KPushButton *addFunction = new KPushButton(i18n("Add Function"),hb);
	QObject::connect(addFunction,SIGNAL(clicked()),SLOT(newFunction()));
	addFunction->setMaximumWidth(150);
	KPushButton *toggleshown = new KPushButton(i18n("Show/Hide"),hb);
	QObject::connect(toggleshown,SIGNAL(clicked()),SLOT(toggleShown()));
	toggleshown->setMaximumWidth(150);
	
	hb = new QHBox(gb);
	KPushButton *del = new KPushButton(i18n("Delete Graph"),hb);
	del->setMaximumWidth(150);
	QObject::connect(del,SIGNAL(clicked()),SLOT(deleteGraph()));
	KPushButton *ch = new KPushButton(i18n("Change Graph"),hb);
	ch->setMaximumWidth(150);
	QObject::connect(ch,SIGNAL(clicked()),SLOT(changeGraph()));	
	KPushButton *edit = new KPushButton(i18n("Edit Data"),hb);
	edit->setMaximumWidth(150);
	QObject::connect(edit,SIGNAL(clicked()),SLOT(editGraph()));
	
	hb = new QHBox(gb);
	KPushButton *dump = new KPushButton(i18n("Export Data"),hb);
	dump->setMaximumWidth(150);
	QObject::connect(dump,SIGNAL(clicked()),SLOT(dumpGraph()));
	KPushButton *spreadsheet = new KPushButton(i18n("Open in Spreadsheet"),hb);
	spreadsheet->setMaximumWidth(150);
	QObject::connect(spreadsheet,SIGNAL(clicked()),SLOT(openSpreadsheet()));
	KPushButton *info = new KPushButton(i18n("Data Statistics"),hb);
	info->setMaximumWidth(150);
	QObject::connect(info,SIGNAL(clicked()),SLOT(statGraph()));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(accept()));
	apply->hide();
	cancel->hide();
	
	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void GraphListDialog::newFunction() {
	// no pie/vtk/grass/ternary function ?
	if(type == P2D || type == PSURFACE || type == P3D || type == PPOLAR)
		(new FunctionDialog(p,0,this,-1,plot->Type()))->show();
}

void GraphListDialog::newData() {
	if (type == PVTK)
		(new VTKDialog(p,0,-1))->show();
	else if (type == PGRASS)
		(new GRASSDialog(p,0,-1))->show();
	else
		(new DataDialog(p,0,this,-1,plot->Type()))->show();
}
