//LabPlot : GraphIMAGE.h

#ifndef GRAPHIMAGE_H
#define GRAPHIMAGE_H

#include <qpixmap.h>
#include <qtextstream.h>
#include "Graph.h"
#include "defs.h"

class GraphIMAGE: public Graph
{
public:
	GraphIMAGE(QString n="", QString l="", LRange r[3]=0, LSource src=SFUNCTION, PType t=PSURFACE, Style st=Style(), 
		Symbol sy=Symbol(), QPixmap pm=0, int dimx=0, int dimy=0, bool s=TRUE);
	QPixmap Pixmap() { return pixmap; }
	void setPixmap(QPixmap pm) { pixmap = pm; }
	LRange Range(int i) { return range[i]; }
	void setRange(LRange *r) { range[0]=r[0];range[1]=r[1];range[2]=r[2]; }
	int width() { return (int)range[0].rMax(); }
	int height() { return (int)range[1].rMax(); }
	void setWidth(int w) { range[0] = LRange(0,w); }
	void setHeight(int h) { range[1] = LRange(0,h); }
	QStringList Info();
	void save(QTextStream *t);
	void open(QTextStream *t, int version);
private:
	QPixmap pixmap;
	LRange *range;
};

#endif // GRAPHIMAGE_H
