/*
                   (C) Copyright 2000-2002 NAVICON ApS
                   Author: Carsten O. Madsen
$Id: GRASSRasterColorMap.cpp,v 1.3 2002/04/23 09:28:18 com Exp $
*/

#include <GRASSRasterColorMap.h>
#include <qcolor.h>
#include <iostream.h>


GRASSRasterColorMap::~GRASSRasterColorMap() {}

GRASSRasterColorMap::GRASSRasterColorMap() :
  colors(), 
  fixed(1), 
  red(0), 
  grn(0), 
  blu(0), 
  set(0), 
  cmin(0),
  cmax(-1),
  nalloc(0),
  color_buf_size(0),
  color_buf(0)
{}

void GRASSRasterColorMap::setColors(struct Colors* colors_) {
  colors = colors_;
  int ncolors;
  int nl, i, r, g, b;
  unsigned char junk, R,G,B;
  CELL cat;
  double span;

  G_get_color_range (&cmin, &cmax, colors);
  
  fixed = ! check_colormap_size (cmin, cmax, &ncolors);
  fprintf (stderr, "# GRASSRasterColorMap colors = %d (mode: %s) "
	   "cmin [%d] cmax [%d]\n", ncolors, fixed?"fixed":"float", 
	   cmin, cmax);

//    int t;
//    cin >> i;
 
  if (fixed) {
    if (is_grey_scale (/*colors*/)) {
      /* restrict colortable to a feasible size */
      if (ncolors > 256) ncolors = 256;

      for (i = 0; i < 256; i++)	{
	_RED[i] = (int) (i * (ncolors-1))/256;
	_GRN[i] = 0;
	_BLU[i] = 0;
      }
      if (ncolors > nalloc)
	allocate_colors (ncolors);
      for (i = 0; i < ncolors; i++)
	red[i] = grn[i] = blu[i] = (i*255)/ncolors;
    }
    else  /* use a color cube */
      {
	/* compute size of color cube */
	for(nl=0; nl*nl*nl <= ncolors-1; nl++) {}
	nl--;

	/* restrict colortable to a feasible size */
	if (nl > 32) nl = 32;

	/* reset ncolors to what we need for color cube */
	ncolors = nl*nl*nl+1;

	/* create color translation table */
	for(i=0; i<256; i++)
	  {
	    _RED[i] = (int)((i / 256.0) * nl) * nl * nl ;
	    _GRN[i] = (int)((i / 256.0) * nl) * nl ;
	    _BLU[i] = (int)((i / 256.0) * nl) ;
	  }

	/* create the colortable for the driver */

	if (ncolors > nalloc)
	  allocate_colors (ncolors);
     
	if (nl > 1)
	  span = 255.0 / (nl-1) ;
	else
	  span = 0.0;

	*red = *grn = *blu = 255;
	i = 1 ;

	for(r=0; r<nl; r++) {
	  R = (int)(r * span) ;
	  for(g=0; g<nl; g++) {
	    G = (int)(g * span) ;
	    for(b=0; b<nl; b++) {
	      B = (int)(b * span) ;
	      red[i] = R;
	      grn[i] = G;
	      blu[i] = B;
	      i++;
	    }
	  }
	}
      }
  } else {
    int r, b, g;
    if (ncolors > nalloc)
      allocate_colors (ncolors);

    for (i = 1, cat = cmin; cat <= cmax; cat++, i++)
      G_lookup_colors (&cat, red+i, grn+i, blu+i, &junk, 1, colors);

    G_get_null_value_color(&r, &g, &b, colors);
    /* G_get_null_value_color expects int pointers */
    red[ncolors-2] = r;
    grn[ncolors-2] = g;
    blu[ncolors-2] = b;
    red[0] = r;
    grn[0] = g;
    blu[0] = b;

    G_get_default_color(&r, &g, &b, colors);
    red[ncolors-1] = r;
    grn[ncolors-1] = g;
    blu[ncolors-1] = b;

  }

  //      /* send the colortable to the driver */
  //      R_reset_colors (0, ncolors-1, red, grn, blu);
  //      synch();

  //  /* tell if the color table fits into the hardware */
  //      return !fixed;
}


GRASSRasterColorMap::GRASSRasterColorMap(struct Colors* colors_) :
  colors(colors_), 
  fixed(1), 
  red(0), 
  grn(0), 
  blu(0), 
  set(0), 
  cmin(0),
  cmax(-1),
  nalloc(0),
  color_buf_size(0),
  color_buf(0)
{
  setColors(colors_);
}


int GRASSRasterColorMap::is_grey_scale(/*struct Colors *colors*/) {
  int r, g, b;
  CELL min, max;
  struct _Color_Rule_ *rule;
  struct _Color_Info_ *cp;

  G_get_color_range (&min, &max, colors);

  cp = &colors->modular;
  for (rule = cp->rules; rule; rule = rule->next) {
    if (rule->low.red != rule->low.grn 
	|| rule->low.red != rule->low.blu 
	|| rule->low.grn != rule->low.blu)
      {
	return 0;
      }
    
    if (rule->high.red != rule->high.grn 
	|| rule->high.red != rule->high.blu 
	|| rule->high.grn != rule->high.blu)
      {
	return 0;
      }
  }

  cp = &colors->fixed;
  for (rule = cp->rules; rule; rule = rule->next) 
    {
      if (rule->low.red != rule->low.grn 
	  || rule->low.red != rule->low.blu 
	  || rule->low.grn != rule->low.blu)
        {
	  return 0;
        }

      if (rule->high.red != rule->high.grn 
	  || rule->high.red != rule->high.blu 
	  || rule->high.grn != rule->high.blu)
        {
	  return 0;
        }
    }

  G_get_null_value_color(&r, &g, &b, colors);
  if (r != g || r != b || g != b) return 0;
  G_get_default_color(&r, &g, &b, colors);
  if (r != g || r != b || g != b) return 0;
  return 1;
}


int GRASSRasterColorMap::check_colormap_size (CELL min, CELL max, int *ncolors)
{

  
  /* find out how many colors the hardware has */
  //R_get_num_colors (&hardware_ncolors);
  int hardware_ncolors = QColor::maxColors();
  cerr << "hardware_ncolors " << hardware_ncolors << endl;
  *ncolors = max - min + 4; /* 2 extra color for null and undef */
  
  /* if we need more colors than there are in the driver,
   * then return hardware_ncolors
   * otherwise return ncolors;
   */
  if (*ncolors <= 1 || *ncolors > hardware_ncolors) {
    *ncolors = hardware_ncolors;
    return 0;
  }
  return 1;
}


int GRASSRasterColorMap::allocate_colors(int ncolors) {
  red = (unsigned char *) G_realloc (red, ncolors);
  grn = (unsigned char *) G_realloc (grn, ncolors);
  blu = (unsigned char *) G_realloc (blu, ncolors);
  set = (unsigned char *) G_realloc (set, ncolors);
  nalloc = ncolors;

  return 0;
}


void GRASSRasterColorMap::lookup_raster_colors(void* raster, int ncols, RASTER_MAP_TYPE data_type) { 
  if (fixed) {
    if (ncols > nalloc)
      allocate_colors (ncols);
    G_lookup_raster_colors (raster, red, grn, blu, set, ncols, colors, data_type);
  }
}



