/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "flossscheme.h"

FlossScheme::FlossScheme()
{
  m_flosses.setAutoDelete(true);
}

QString FlossScheme::schemeName()
{
  return m_name;
}

void FlossScheme::setSchemeName(QString name)
{
  m_name = name;
}

void FlossScheme::addFloss(Floss *floss)
{
  m_flosses.append(floss);
}

Floss *FlossScheme::find(QString name)
{
  for (Floss* floss = m_flosses.first() ; floss ; floss = m_flosses.next())
  {
    if (floss->name == name)
      return floss;
  }
  return 0;
}

QPtrListIterator<Floss> FlossScheme::flossIterator()
{
  return QPtrListIterator<Floss>(m_flosses);
}

void FlossScheme::clearScheme()
{
  m_flosses.clear();
}

