/***************************************************************************
                          wwidget.cpp  -  description
                             -------------------
    begin                : Die Nov 12 2002
    copyright            : (C) 2002 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "wwidget.h"

WWidget::WWidget(WCard *pCard, Options *pOptions, QWidget *parent, const char *name ) : QWidget(parent,name)
{

	card		= pCard;
  options = pOptions;

  buffer = (char*)malloc(100);
  	  eh = (char*)malloc(5);  
  bitRates = (BitRates*)malloc(sizeof(BitRates));

  isWave = true;

  tab = new KTabCtl(this);
  tab->move(5, 5);
  tab->resize(260, 310);
  tab->show();

	firstTab  = new KTabWidget(tab);
	secondTab = new KTabWidget(tab);
//	thirdTab  = new KTabWidget(tab);
	infoTab		= new KTabWidget(tab);
	tab->addTab(firstTab,  i18n("Basic"));
	tab->addTab(secondTab, i18n("Extended"));
//	tab->addTab(thirdTab,  "3");
	tab->addTab(infoTab,"Info");

	deviceEdit		= new KWCEntryEdit(i18n("Device"), 0, firstTab);
	IPLabel				= new KWCEntryLabel(i18n("IP-Address"), 1, firstTab);

	nickLabel			=  new KWCEntryLabel(i18n("Nickname"), 7, firstTab);
	
	modeSelection	= new KWCEntrySelection(i18n("Mode"), 2, firstTab);
  	modeSelection->insertItem("Auto" ,      IW_MODE_AUTO);
	  modeSelection->insertItem("Ad-hoc" ,    IW_MODE_ADHOC);
  	modeSelection->insertItem("Infrastr." , IW_MODE_INFRA);
	  modeSelection->insertItem("Master" ,    IW_MODE_MASTER);
  	modeSelection->insertItem("Repeater" ,  IW_MODE_REPEAT);
	  modeSelection->insertItem("Second" ,    IW_MODE_SECOND);
  
	linkBar				= new KWCEntryBar(i18n("Link Quality"), 3, firstTab);
	signalBar			= new KWCEntryBar(i18n("Signal Level"), 4, firstTab);
	noiseBar			= new KWCEntryBar(i18n("Noise Level"), 5, firstTab);
	encodingLabel	= new KWCEntryLabel(i18n("Encoding"), 6, firstTab);

 	pollingSpin		= new  KWCEntrySpin(i18n("Polling"), 9, 1, 100, 1, firstTab);

	protocolLabel = new KWCEntryLabel(i18n("Protocol"), 0, secondTab);
	bitrateSelection	= new KWCEntrySelection(i18n("Bit-Rate"), 1, secondTab);
	frequencyLabel= new KWCEntryLabel(i18n("Frequency"), 2, secondTab);
	channelLabel 	= new KWCEntryLabel(i18n("Channel"), 3, secondTab);
	txPowerLabel	= new KWCEntryLabel(i18n("Tx-Power"), 4, secondTab);
	sensitivitySelection = new KWCEntrySelection(i18n("Sensitivity"), 5, secondTab);
	essidEdit			= new KWCEntryEdit(i18n("ESSID"), 6, secondTab);
	sentLabel			= new KWCEntryLabel(i18n("Sent"), 7, secondTab);
	recvLabel			= new KWCEntryLabel(i18n("Received"), 8, secondTab);

	macAPLabel		= new KWCEntryLabel(i18n("AP Mac"), 9, secondTab);


	authorLabel		= new KWCEntryLabel(i18n("Author"), 3, infoTab);
		authorLabel->setValue("Matthias Reif");
	homepageLabel = new KWCEntryLabel(i18n("Homepage"), 4, infoTab);
	  homepageLabel->setValue("http://kwc.progeln.de");
	licenseLabel	= new KWCEntryLabel(i18n("License"), 5, infoTab);
		licenseLabel->setValue("GPL");
	versionLabel	= new KWCEntryLabel(i18n("Version"), 6, infoTab);
		versionLabel->setValue(VERSION);

	emailLabel		= new QLabel(infoTab);
	emailLabel->setGeometry(10, 240, 250, 20);
	emailLabel->setText("matthias.reif@informatik.tu-chemnitz.de");

  logoImage = new QImage(*(options->getKwcDir()) + "kwc.png");


  connect(deviceEdit, SIGNAL(changed(const QString &)), this, SLOT(deviceSlot(const QString &)));
	connect(essidEdit,  SIGNAL(changed(const QString &)), this, SLOT(essidSlot(const QString &)));
	connect(modeSelection, SIGNAL(activated(int)),  		  this, SLOT(modeSlot(int)));  
	connect(bitrateSelection, SIGNAL(activated(int)), 		this, SLOT(bitrateSlot(int)));
	connect(sensitivitySelection, SIGNAL(activated(int)), 		this, SLOT(sensitivitySlot(int)));	
  connect(pollingSpin, SIGNAL(valueChanged(int)),    options, SLOT(slotPolling(int)));

	deviceEdit->setValue(*options->getDevice());
  pollingSpin->setValue(options->getPolling());
                        
  closeButton = new KPushButton(this);
  closeButton->setText(i18n ("&OK"));
  closeButton->move(170, 320);
  closeButton->show();

  connect(closeButton, SIGNAL(clicked()), this, SLOT(slotClose()));

  connect(tab, SIGNAL(tabSelected(int)), this, SLOT(tabSelectedSlot(int)));
  connect(infoTab, SIGNAL(paintEventSignal()), this, SLOT(infoRepaintSlot()));

}

WWidget::~WWidget()
{
	free(buffer);
	free(bitRates);
  free(eh); 
}

/** No descriptions */
void WWidget::slotClose()
{
  hide();
}

/** No descriptions */
void WWidget::basicTimerSlot()
{
	if(isVisible())
	{
		IPLabel->setValue(card->getIP());

		if(card->isWave())
		{
      if(!isWave)
      {
      	setWave();
      }

      card->getNickName(buffer);
      nickLabel->setValue(buffer);
			
			modeSelection->setCurrentItem(card->getMode());
			
			card->getLinkQual(link, avg, signal, noise);
			linkBar->showBar();
			linkBar->setValue(link);
			if(link>0)
			{
				signalBar->showBar(false);
				noiseBar->showBar(false);
				signalBar->setValue("-" + QString::number(256 - signal) + " dBm");
				noiseBar->setValue("-" + QString::number(256 - noise) + " dBm");
			}else{
				signalBar->showBar();
				noiseBar->showBar();
				signalBar->setValue(signal);
				noiseBar->setValue(noise);				
			}

			card->getProtocol(buffer);
			protocolLabel->setValue(buffer);

      if(card->getEncode(buffer))
      {
        encodingLabel->setValue(i18n("enabled"));
      }else{
        encodingLabel->setValue(i18n("disabled"));
      }

      txPowerLabel->setValue(QString::number(card->getTransmitPower(buffer)) + " " + buffer);

      card->getAPMac(buffer);
      macAPLabel->setValue(buffer);
			
  	}else{
			if(isWave)
			{
				setWave(false);
			}		 	
		}
		
	}
}

/** No descriptions */
void WWidget::shortTimerSlot()
{
	if(isVisible())
	{
		if(card->isWave())
		{
	    int numFreq;
  	  double freq;
    	int numChannel;
	    int channel;
    	if( card->getChannel(numFreq, freq, eh, numChannel, channel) < 0 )
	    {
  	    frequencyLabel->setValue(i18n ("error"));
    	  channelLabel->setValue(i18n ("error"));
	    }else{
  	    frequencyLabel->setValue(QString::number(freq) + " " + eh);
    	  channelLabel->setValue(QString::number(channel) + " " + i18n ("of") + " " + QString::number(numChannel));
	    }
		}

    int	recv , sent;
    
    if(card->getTraffic(sent, recv))
    {
	    sentLabel->setValue(QString::number(sent) + " bytes");
  	  recvLabel->setValue(QString::number(recv) + " bytes");
    }else{
	    sentLabel->setValue(i18n("Wrong") + " " + i18n("Device"));
  	  recvLabel->setValue(i18n("Wrong") + " " + i18n("Device"));
		}
	}
}

/** when another tab was selected */
void WWidget::tabSelectedSlot(int index)
{
	if(card->isWave())
	{
		int index;
    card->getBitRate(bitRates, index);
    bitrateSelection->clear();
    for( int i=0; i < bitRates->num; i++)
    {
      bitrateSelection->insertItem(QString::number(bitRates->bitRate[i].value) + " " + bitRates->bitRate[i].unit, i);
    }
    bitrateSelection->setCurrentItem(index);

    int sens, sensRange;
    card->getSensitivity(sens, sensRange);

    sensitivitySelection->clear();
    for(int i=0; i < sensRange; i++)
    {
      sensitivitySelection->insertItem(QString::number(i+1) + " dBm", i);
    }
		sensitivitySelection->setCurrentItem(sens-1);

    card->getESSID(buffer);
    essidEdit->setValue(buffer);
  }
}

/** when the device was changed */
void WWidget::deviceSlot(const QString & text)
{
	card->setDevice(text.data());
	options->saveDevice(text);
}

/** when the essid was changed */
void WWidget::essidSlot(const QString & text)
{
	card->setESSID(text.data());
	card->getESSID(buffer);
	essidEdit->setValue(buffer);
}

/** when the bitrate was changed */
void WWidget::bitrateSlot(int index)
{
  card->setBitRate(index);
  tabSelectedSlot(1);	
}

/** when the mode was changed */
void WWidget::modeSlot(int index)
{
  modeSelection->setCurrentItem(card->setMode(index));
}

/** when the sensitivity was changed */
void WWidget::sensitivitySlot(int index)
{
	card->setSensitivity(index+1);
  tabSelectedSlot(1); 
}

/** set isWave true, if the card is a wavelan device */
void WWidget::setWave(bool is)
{
	modeSelection->showValue(is);
	linkBar->showValue(is);
	signalBar->showValue(is);
	noiseBar->showValue(is);
	encodingLabel->showValue(is);
	protocolLabel->showValue(is);
	bitrateSelection->showValue(is);
	frequencyLabel->showValue(is);
	channelLabel->showValue(is);
	txPowerLabel->showValue(is);
	sensitivitySelection->showValue(is);
	essidEdit->showValue(is);
	macAPLabel->showValue(is);

	nickLabel->showValue(is);

	isWave = is;
}

/** when the logo has to repaint */
void WWidget::infoRepaintSlot()
{
  int x = ( infoTab->width() - logoImage->width() ) / 2;
  QPainter p(infoTab);
    p.drawImage(x, 30, *logoImage);
  p.end();	
}
