/***************************************************************************
                          connectorpropertydialog.cpp  -  description
                             -------------------
    begin                : Fri Jan 12 2001
    copyright            : (C) 2001 by Rasmus Diekenbrock
    email                : ksimus@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// C-Includes

// QT-Includes
#include <qvbox.h>

// KDE-Includes
#include <klocale.h>
#include <kconfig.h>
#include <kapp.h>

// Project-Includes
#include "component.h"
#include "connectorpropertydialog.h"
#include "connectorbase.h"
#include "connectorlist.h"
#include "ksimundo.h"
#include "propertywidget.h"

// Forward declaration

ConnectorPropertyDialog::ConnectorPropertyDialog(ConnectorList * connList, ConnectorBase * activeConn,
                                                 const QString & caption, QWidget *parent, const char *name )
	:	ComponentPropertyDialog((Component *)0, caption, parent, name)
{
	if (connList && connList->count())
	{
		PropertyWidget * wid;
		QVBox * page;
		setComponent(connList->first()->getComponent());
			
		FOR_EACH_CONNECTOR(it,*connList)
		{
			if (it.current()->getAction().isInitPropertyDialogEnabled())
			{
				page = addVBoxPage(it.current()->getName());
				wid = it.current()->propertyWidget(page);
				connectSlots(wid);
				
				if (it.current() == activeConn)
				{
					showPage(pageIndex(page));
				}
			}
		}
	}
}

ConnectorPropertyDialog::~ConnectorPropertyDialog()
{
}

int ConnectorPropertyDialog::execute(ConnectorList * connList, ConnectorBase * activeConn,
                                     const QString & caption, QWidget *parent, const char *name)
{
	int result;

	ConnectorPropertyDialog * dia;
	dia = new ConnectorPropertyDialog(connList, activeConn, caption, parent, name);

	// Load last size
	KConfig * config=kapp->config();
	QString group(config->group());
	config->setGroup("Connector/Property Dialog");
	QSize size=config->readSizeEntry("Geometry");
	config->setGroup(group);
	if(!size.isEmpty())
	{
		dia->resize(size);
	}

	result = dia->exec();

	// Save size
	config->setGroup("Connector/Property Dialog");
	config->writeEntry("Geometry", dia->size());
	config->setGroup(group);

	delete dia;

	return result;
}
