/***************************************************************************
                          lmsensor.cpp  -  description
                             -------------------
    begin                : Mon Aug 6 2001
    copyright            : (C) 2001 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lmsensor.h"

#include "lmsensorschip.h"

#include "stdio.h"

LMSensor::LMSensor(SensorsList *parent): Sensor(parent)
{
  feature= -1;
}


LMSensor::~LMSensor(){
}


bool LMSensor::init(const sensors_feature_data **data, int *nr1,int *nr2)
{
double min,max;

 const sensors_chip_name *chip_name= getChipName();

 if (strstr((*data)->name, "temp"))
 {
    setType(lmTemp);
    max= 65;
    min= 0;
 }
 else if (strstr((*data)->name, "fan"))
 {
    setType(lmFan);
    max= 10000;
    min= 3000;
 }
 else
 {
    setType(lmVoltage);
    max= 16;
    min= -16;
 }

 feature= (*data)->number;

 QString str;
 str.sprintf("%s.%s", chip_name->prefix, (*data)->name );
 setName( str.latin1() );

 char *label;
 sensors_get_label(*chip_name,feature,&label);
 setDescription(QString(label));

 bool valid= false;
 while( (*data= sensors_get_all_features(*chip_name, nr1, nr2)) && (*data)->mapping!=SENSORS_NO_MAPPING) {
   str= (*data)->name;
   if(str.find("_min")>=0 || str.find("_low")>=0) {
       sensors_get_feature(*chip_name, (*data)->number, &valMin);
       valid= true;
   } else
       if(str.find("_max")>=0 || str.find("_over")>=0  || str.find("_high")>=0) {
          sensors_get_feature(*chip_name, (*data)->number, &valMax);
          valid= true;
       }
 }

 if(valid) {
    double newVal;
    valid= (sensors_get_feature(*chip_name, feature, &newVal)==0);
    if(valid) {
        if(min>max) {
          double pivot= valMin;
          min= max;
          max= pivot;
        }
        setValueMax(max,dgCelsius);
        setValueMin(min,dgCelsius);
        setValue((max+min)/2,dgCelsius);
        readConfig();
        updateValue();
        setValueIdeal(getValue());
    }
 }
 return valid;
}

void LMSensor::updateValue()
{
 setValue( readSensorValue(), dgCelsius );
}

double LMSensor::readSensorValue()
{
 double newVal;
 const sensors_chip_name *chip_name= getChipName();
 sensors_get_feature(*chip_name, feature, &newVal);
 return newVal;
}

#define ABSOLUTE_VALUE(n)  ( (n)>=0 ? (n) : -(n) )
#define TRUNCATE_VALUE(n)  ( (double)(int)(n)    )

double LMSensor::calculateIdealValue()
{
 double value= readSensorValue();

 if(getType()==lmVoltage) {
     double decimals= 10;
     double module = ABSOLUTE_VALUE(value);
     if(module>3.0) {
       if( ABSOLUTE_VALUE( 12.0-value)<2.0 ) return  12.0;
       if( ABSOLUTE_VALUE(-12.0-value)<2.0 ) return -12.0;
       if( ABSOLUTE_VALUE(  5.0-value)<1.0 ) return   5.0;
       if( ABSOLUTE_VALUE( -5.0-value)<1.0 ) return  -5.0;
       if( ABSOLUTE_VALUE(  3.3-value)<0.3 ) return   3.3;
       if( ABSOLUTE_VALUE( -3.3-value)<0.3 ) return  -3.3;
       if(module>4.0) decimals= 1;
     }
     return TRUNCATE_VALUE((value * decimals)) / decimals;
  } else {
     return value;
  }
}

const sensors_chip_name *LMSensor::getChipName()
{
  return ((LMSensorsChip *)parent())->getChipName();
}
