/* cfgfile.h - handle configuration file.
 *
 * King of the Hill (KOTH) Copyright (C) 1999 Peter Amstutz
 * KOTH comes with ABSOLUTELY NO WARRANTY
 * This is free software, and you are welcome to redistribute it
 * under the conditions of the GNU GPL
 *
 * Created by Ariel Eizenberg (arielez@cs.huji.ac.il)
 * Configuration is read from a file into an add-only hashtable.
 * Default configuration file name is DEFAULT_CONFIGFILE
 * 
 * functions:
 * Configuration_cfg* cfgReadConfiguration(const char* filename);
 *    * reads configuration from filename and returns it
 *
 * void cfgFreeConfiguration(Configuration_cfg* config);
 *    * frees memory taken up by a configuration
 *
 * const ConfigItem_cfg* getConfigItem(Configuration_cfg* config,
 *                                        const char* option);
 *    * returns a configuration item
 *    * options is a string of the form: "category.item",
 *    * for example "server.port" or "options.wind"
 *
 * int cfgLoadConfigItemXXX(Configuration_cfg* config,const char* option,
 * 					         XXX* buf,int load);
 *    * return a configuratio item
` *    * option is a string of the form "category.item" (see getConfigItem())
 *    * buf is the target for the value retrieved
 *    * the functions does the actual loading only if load!=0
 *
 * void cfgCheckError(int iserror, const char* error)
 *    * if iserror!=0 prints error string and exit(-1) 
 */

#ifndef _CFGFILE_H
#define _CFGFILE_H

#define CONFIGFILE_STUB "koth.cfg"
#define DEFAULT_CONFIGFILE "/etc/koth/" CONFIGFILE_STUB

typedef struct ConfigItem_cfg
{
    char *name;
    char *value;
}
ConfigItem_cfg;

typedef struct Category_cfg Category_cfg;
typedef struct Configuration_cfg Configuration_cfg;

void cfgCheckError(int iserror, const char *error);

Configuration_cfg *cfgReadConfiguration(const char *filename);
void cfgFreeConfiguration(Configuration_cfg * config);
const ConfigItem_cfg *cfgGetConfigItem(Configuration_cfg * config,
				       const char *option);
int cfgLoadConfigItemStrBuf(Configuration_cfg * config, const char *option,
			    char *buf);
int cfgLoadConfigItemStr(Configuration_cfg * config, const char *option,
			 char **buf);

int cfgLoadConfigItemInt(Configuration_cfg * config, const char *option,
			 int *buf);
int cfgLoadConfigItemIntD(Configuration_cfg * config, const char *option,
			  int *buf, int def);

int cfgLoadConfigItemDouble(Configuration_cfg * config, const char *option,
			    double *buf);
int cfgLoadConfigItemDoubleD(Configuration_cfg * config, const char *option,
			     double *buf, double def);

int cfgLoadConfigItemOption(Configuration_cfg * config, const char *option,
			    const char **possible, const int *values, int *buf);
int cfgLoadConfigItemOptionD(Configuration_cfg * config, const char *option,
			     const char **possible, const int *values,
			     int *buf, int def);

extern Configuration_cfg *cfg_configuration;

#endif
