/* @(#) buffer.h 1.7 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*
*	Module: BUFFER
\***************************************************************/

#ifndef _KOALAMUD_BUFFER_H
#define _KOALAMUD_BUFFER_H "@(#) nitehawk@winghove.1ststep.net|include/buffer.h|20000307194808|41592 @(#)"

#include "koalatypes.h"

/* Output buffer functions */
/* Queue data to be sent */
koalaerror buffer_queue(pdescriptor desc, const char *data, int len);
/* Write data out to descriptor */
koalaerror buffer_sendbytes(pdescriptor desc, int len);
/* is the outbuffer empty? */
inline bool buffer_outbufempty(pdescriptor desc);

/* Input buffer functions */
/* Read data from socket to input buffer */
koalaerror buffer_receive(pdescriptor desc);
/* Read a number of bytes from buffer */
koalaerror buffer_readbytes(pdescriptor desc, char *buf, int *len, bool exact);
/* Read single char from buffer */
char buffer_readchar(pdescriptor desc);
/* Read a single word delimited by whitespace from the buffer */
koalaerror buffer_readword(pdescriptor desc, char *word, int maxlen);
/* Read one line from the buffer terminated by \r or \n */
koalaerror buffer_readline(pdescriptor desc, char *line, int maxlen);
/* Flush remainder of current line from input buffer */
koalaerror buffer_flushline(pdescriptor desc);
/* Check the buffer for a line of input */
bool buffer_isalinein(pdescriptor desc);

#endif
