#include "ezthread.h"

EZThread::EZThread()
{

#ifndef __WIN32__
   pthread_mutex_init(&th_mutex,NULL);
   th_id = 0;
#else
  th_id = INVALID_HANDLE_VALUE;
  InitializeCriticalSection(&critsect);
#endif // __WIN32__
}
EZThread::~EZThread()
{
#ifndef __WIN32__
   pthread_mutex_destroy(&th_mutex);
#else
  if(th_id != INVALID_HANDLE_VALUE)
  {
     // make sure its killed
     CloseHandle(th_id);
  }
  DeleteCriticalSection(&critsect);
#endif // __WIN32__
}
bool EZThread::isRunning()
{
#ifndef __WIN32__
   return th_id!=0;
#else
   return th_id != INVALID_HANDLE_VALUE;
#endif // __WIN32__
}
bool EZThread::run()
{
#ifndef __WIN32__
   typedef void * (* pthread_func)(void *);

   pthread_create(&th_id,NULL,(pthread_func)thread_task,(void *)this);
   pthread_detach(th_id);
#else
    DWORD th_info;
    th_id = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)thread_task,this,0,&th_info);
#endif // __WIN32__
   return true;
}
bool EZThread::kill()
{
  down();
#ifndef __WIN32__
   if(th_id) pthread_cancel(th_id);
   th_id=0;
#else
  // TODO : will this kill the thread???
  CloseHandle(th_id);
  th_id = INVALID_HANDLE_VALUE;
#endif // __WIN32__
  up();

  return true;
}

void *EZThread::thread_task(EZThread *our_class)
{
   if(our_class)
   {
      // allow a cancel to work straight away
#ifndef __WIN32__
      pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS,NULL);
#endif // __WIN32__

      our_class->run_method();

      our_class->down();
#ifndef __WIN32__
        our_class->th_id = 0;
#else
        CloseHandle(our_class->th_id);
        our_class->th_id = INVALID_HANDLE_VALUE;
#endif
      our_class->up();
   }
   return NULL;
}

void EZThread::down()
{
#ifndef __WIN32__
   pthread_mutex_lock(&th_mutex);
#else
  // lock for a critical section
  EnterCriticalSection(&critsect);
#endif // __WIN32__
}
void EZThread::up()
{
#ifndef __WIN32__
   pthread_mutex_unlock(&th_mutex);
#else
  // lock for a critical section
  LeaveCriticalSection(&critsect);
#endif // __WIN32__

}
bool EZThread::trydown()
{
#ifndef __WIN32__
   // currently only coded for UNIX
   if(pthread_mutex_trylock(&th_mutex)==0) return true;
#endif
   return false;
}

void EZThread::run_method()
{
   // the actual runnable method - Implement a new one of these
   return;
}
