#include <gtk/gtk.h>
#include <glade/glade.h>
#include <string.h>
#include <time.h>

#include "kptransferdialog.h"
#include "../../gui/kpguiutils.h"
#include "../../gui/kpmainwindow.h"

#include "s410.h"
#include "../../kptraininglog.h"
#include "../../kipina-i18n.h"
#include "../../kpsettings.h"
#include "../../kputil.h"
#include "../../kpworkout.h"

/* Gobject stuff */
static void       kp_transfer_dialog_class_init (KPTransferDialogClass * klass);
static void       kp_transfer_dialog_init (KPTransferDialog * dialog);
static void       kp_transfer_dialog_finalize (GObject * object);
static void       kp_transfer_dialog_response_cb (GtkDialog * gtkdialog,
                                                  int response_id,
                                                  KPTransferDialog * dialog);
/* Callbacks */
static void       start_transfer_button_clicked (GtkButton * button,
                                                 KPTransferDialog * dialog);
static void       browse_button_clicked (GtkButton * button,
                                         KPTransferDialog * dialog);


typedef struct KPTransferDialogPrivateData_
{
  KPWorkout **workout;

  GtkWidget  *title_entry;
  GtkWidget  *textview;
  GtkWidget  *calendar;

  GtkWidget  *save_button;
  GtkWidget  *cancelbutton;
  GtkWidget  *start_transfer_button;

  GtkWidget  *label_error;
  GtkWidget  *label_success;

  GtkWidget  *file_entry;
} KPTransferDialogPrivateData;

#define KP_TRANSFER_DIALOG_PRIVATE_DATA(widget) (((KPTransferDialogPrivateData*) \
        (KP_TRANSFER_DIALOG (widget)->private_data)))

static GObjectClass *parent_class = NULL;

GType
kp_transfer_dialog_get_type (void)
{
  static GType kp_transfer_dialog_type = 0;

  if (kp_transfer_dialog_type == 0) {
    static const GTypeInfo our_info = {
      sizeof (KPTransferDialogClass),
      NULL,
      NULL,
      (GClassInitFunc) kp_transfer_dialog_class_init,
      NULL,
      NULL,
      sizeof (KPTransferDialog),
      0,
      (GInstanceInitFunc) kp_transfer_dialog_init,
      NULL,
    };

    kp_transfer_dialog_type = g_type_register_static (GTK_TYPE_DIALOG,
                                                         "KPTransferDialog",
                                                         &our_info, 0);
  }

  return kp_transfer_dialog_type;
}

static void
kp_transfer_dialog_class_init (KPTransferDialogClass * klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  parent_class = g_type_class_peek_parent (klass);
  object_class->finalize = kp_transfer_dialog_finalize;
}


static void
kp_transfer_dialog_init (KPTransferDialog *dialog)
{
  KPTransferDialogPrivateData *p_data;
  GladeXML *xml;

  xml = kp_gui_load ("transferdialog", "transfer_dialog_box");

  dialog->private_data = g_new0 (KPTransferDialogPrivateData, 1);
  p_data = KP_TRANSFER_DIALOG_PRIVATE_DATA (dialog);

  g_signal_connect (G_OBJECT (dialog),
                   "response",
                    G_CALLBACK (kp_transfer_dialog_response_cb), dialog);

  gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
  gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (dialog)->vbox), 2);

  gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_NONE);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Add a new comment to the log."));

  p_data->cancelbutton = gtk_dialog_add_button (GTK_DIALOG (dialog),
                                                GTK_STOCK_CANCEL,
                                                GTK_RESPONSE_CANCEL);

  p_data->save_button = gtk_dialog_add_button (GTK_DIALOG (dialog),
                                               GTK_STOCK_ADD,
                                               GTK_RESPONSE_OK);
  p_data->start_transfer_button = KP_W (xml, "start_transfer_button");

  p_data->label_error = KP_W (xml, "transfer_failed_label");
  p_data->label_success = KP_W (xml, "transfer_completed_label");

  p_data->file_entry = KP_W (xml, "file_entry");
  
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox),
                     KP_W (xml, "transfer_dialog_box"));

  g_signal_connect (G_OBJECT (KP_W (xml, "browse_button")), "clicked",
                    G_CALLBACK (browse_button_clicked), dialog);
  
  g_signal_connect (G_OBJECT (p_data->start_transfer_button), "clicked",
                    G_CALLBACK (start_transfer_button_clicked), dialog);

  g_signal_connect (G_OBJECT (dialog),
                   "response",
                    G_CALLBACK (kp_transfer_dialog_response_cb), dialog);

  gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_NONE);

  g_object_unref (G_OBJECT (xml));
}


static void
kp_transfer_dialog_finalize (GObject *object)
{
  KPTransferDialog *dialog;

  g_return_if_fail (object != NULL);
  g_return_if_fail (KP_IS_TRANSFER_DIALOG (object));

  dialog = KP_TRANSFER_DIALOG (object);

  g_return_if_fail (dialog->private_data != NULL);
  g_free (dialog->private_data);

  G_OBJECT_CLASS (parent_class)->finalize (object);
}


GtkWidget *
kp_transfer_dialog_new (KPWorkout **workout)
{
  KPTransferDialogPrivateData *p_data;
  KPTransferDialog *dialog;

  dialog = g_object_new (KP_TYPE_TRANSFER_DIALOG, NULL);

  p_data = KP_TRANSFER_DIALOG_PRIVATE_DATA (dialog);
  p_data->workout = workout;

  return GTK_WIDGET (dialog);
}

static void
browse_button_clicked (GtkButton * button, KPTransferDialog * dialog)
{
  KPTransferDialogPrivateData *p_data;
  gchar *file;
  
  p_data = KP_TRANSFER_DIALOG_PRIVATE_DATA (dialog);
  file = kp_gui_get_filename_from_user ();
  gtk_entry_set_text (GTK_ENTRY (p_data->file_entry), file);
}

static void
start_transfer_button_clicked (GtkButton *button, KPTransferDialog * dialog)
{
  KPTransferDialogPrivateData *p_data;
  KPTrainingLog *log;
  const gchar *file;
  KPWorkout *wo;
  HrmData data;
  
  p_data = KP_TRANSFER_DIALOG_PRIVATE_DATA (dialog);
  
  file = gtk_entry_get_text (GTK_ENTRY (p_data->file_entry)); 
 
  if (file) {
    s410_set_file (file);
    s410_extract_bytes (&data, NULL, -1);
  } else
    return;

  wo = kp_workout_new ();
  kp_workout_set_sport (wo, "Running");
  kp_calendar_time_set_dmy (kp_calendar_entry_get_date (KP_CALENDAR_ENTRY (wo)),
                            29, 6, 2004);
    
  /*gtk_widget_set_sensitive (p_data->start_transfer_button, FALSE);*/
  log = kp_main_window_get_log ();

  kp_training_log_add (log, KP_CALENDAR_ENTRY (wo));
}

static void
kp_transfer_dialog_response_cb (GtkDialog *gtk_dialog, int response_id,
                                KPTransferDialog *dialog)
{
  KPTransferDialogPrivateData *p_data;
  
  p_data = KP_TRANSFER_DIALOG_PRIVATE_DATA (dialog);
}
